<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Lesson;

class StudentRequest extends Model
{
    protected $table= 'student_requests';
    protected $guarded =[];  

    public $timestamps =false;
    public function user() {
        return $this->belongsTo(User::class,'user_id');
    }
    public function student_info() {
        return $this->hasOne(StudentInfo::class,'user_id','user_id');
    }
    public function course() {
        return $this->belongsTo(Course::class,'course_id');
    }
    public static function studentRequestCount(){
        return Self::where('seen',0)->count();
    }
    
    
}
