<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Lesson;

class Student extends Model
{
    protected $table= 'student_training_registered';
    protected $guarded =[];  

    public $timestamps =false;
    public function user() {
        return $this->belongsTo(User::class,'user_id');
    }
    
    public function attendance() {
        $training = $this->training();
        return $this->hasMany(TrainingAttendance::class,'user_id','user_id');
    }
    public function attendance_report() {
        return $this->hasMany(TrainingAttendance::class, 'user_id', 'user_id')
                    ->whereColumn('training_id', 'student_training_registered.training_id');
    }
    public function studentinfo(){
        return $this->hasOne(StudentInfo::class,'user_id','user_id');
    }
    public function training(){
        return $this->belongsTo(Training::class,'training_id');
    }

}
