<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\ExameQuestion;
class PartnerTrainingRequest extends Model
{
    protected $table = 'partner_training_requests';
    protected $guarded =[];  
    
    public function user(){
        return $this->hasOne(User::class,'id','user_id');
    }
    public function center(){
        return $this->hasOne(Center::class,'id','center_id');
    }
    public function instructor(){
        return $this->hasOne(User::class,'id','instructor_id');
    }
    public function hall(){
        return $this->hasOne(CenterHall::class,'id','hall_id');
    }
    public function training(){
        return $this->belongsTo(Training::class,'request_id');
    }
    public function field(){
        return $this->hasOne(TrainingField::class,'id','training_field_id');
    }
    public static function partnerTrainingRequestCount(){
        return PartnerTrainingRequest::where('seen',0)->count();
    }   
    
     
}
