<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\User;
use App\Models\Center;

class Partner extends Model
{
    protected $table = 'partners_centers';
    protected $guarded  = [];
    public function centers() {
        return $this->hasMany(Center::class,'id','center_id');
    }
    public function user() {
        return $this->hasone(User::class,'id','user_id');
    }
     public static function partnerRequestCount()
    { 
        return User::where('type', 'partner')->where('verified_partner', 0)->count();
    }
}
