<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;


class Order extends Model
{
    use HasFactory;
	protected $table='orders';
    public function orderCourses(){
        return $this->hasMany(OrderCourse::class)->with('course');
    }

    public function completedCourses(){
		return $this->hasMany(OrderCourse::class)->where('progress',100);
	}
    
    public function user(){
        return $this->belongsTo(User::class);
    }
    public function paymentMethod(){
        return $this->belongsTo(PaymentMethod::class,'payment_id');
    }
}
