<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;


class Lesson extends Model
{
    protected $guarded=[];
    public function getRouteKeyName(): string
    {
        $locale = LaravelLocalization::getCurrentLocale();
        return 'link_' . $locale;
    }

    public function chapter(){
        return $this->belongsTo(Chapter::class);
    }
    public function course(){
        return $this->belongsTo(Course::class);
    }
    public function attachments(){
        return $this->hasMany(Attachment::class);
    }
}