<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Lesson;

class InstructorInfo extends Model
{
    protected $table= 'instructors_info';
    protected $guard =[];  
    public $timestamps = false;

    public function user() {
        return $this->hasOne(User::class,'id','user_id');
    }
    public function centers() {
        return $this->belongsToMany(Center::class,'instructors_centers','user_id','center_id');
    }
    public function address() {
        return $this->hasOne(InstructorAddress::class,'instructor_id');
    }

}
