<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CrmSms extends Model
{
    protected $table = 'crm_sms';
    protected $guarded= [];
    
    
    public function sender(){
        return $this->belongsTo(User::class,'sender_id');
    }
    
    public function meeting(){
        return $this->hasOne(CrmMeetings::class,'crm_sms_id');
    }
    public function task(){
        return $this->hasOne(CrmTask::class,'crm_sms_id');
    }
    public function client(){
        return $this->belongsTo(CrmClient::class,'client_id');
    }

}
