<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CrmClient extends Model
{
    protected $table = 'crm_clients';
    protected $guarded = [];
    public function company(){
        return $this->belongsTo(CrmClient::class,'company_id');
    }
    public function companyTraining(){
        return $this->hasMany(CrmCompanyTraining::class,'company_id')->with('training');
    }
    
    public function company_data(){
        return $this->hasOne(CrmCompanyData::class,'crm_client_id')->with('field');
    }
    public function training(){
        return $this->belongsTo(Training::class,'training_id');
    }
    public function status(){
        return $this->belongsTo(Status::class,'status_id');
    }
    public function source(){
        return $this->belongsTo(CrmSource::class,'come_from');
    }
    public function area(){
        return $this->belongsTo(Area::class,'area_id');
    }
    public function region(){
        return $this->belongsTo(Region::class,'region_id');
    }
    public function responsible_employee(){
        return $this->hasOne(CrmClientEmployees::class,'crm_client_id');
    }

}
