<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class CrmMeetings extends Model
{
    protected $table = 'crm_meetings';
    protected $guarded= [];
    protected $casts= [
        "team_ids"=>"array",
        ];
        
    public function clientSms(){
        return $this->belongsTo(CrmSms::class,'crm_sms_id')->with('client');
    }
   
    public function getParsedDateAttribute(){
        return Carbon::parse($this->date);
    } 

}
