<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CrmInvoice extends Model
{
    protected $table = 'crm_invoices';
    protected $guarded = [];
    public function client(){
        return $this->belongsTo(CrmClient::class,'client_id');
    }
    public function items(){
        return $this->hasMany(CrmInvoicesItem::class,'crm_invoice_id');
    }
    public function crm_company_tranining(){
        return $this->belongsTo(CrmCompanyTraining::class,'crm_company_tranining_id')->with('training');
    }


}
