<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CrmCompanyTraining extends Model
{
    protected $table = 'crm_company_traninings';
    protected $guarded = [];
    
    public function training(){
        return $this->belongsTo(Training::class,'training_id');
    }
    public function payments(){
        return $this->hasMany(CrmPaymentRecord::class,'company_tranining_id');
    }
    
    public function invoice(){
        return $this->hasOne(CrmInvoice::class,'crm_company_tranining_id');
    }
    
    
    

}
