<?php

namespace App\Models;

use App\Http\Middleware\Admin;
use Illuminate\Database\Eloquent\Model;
use App\Models\Training;

class Center extends Model
{
    protected $fillable = [
        'name_en','name_ar','text_en','text_ar','logo',
        'country_id','region_id','area_id','map_url',
        'status','responsible_name','responsible_email','responsible_phone','responsible_whatsapp'
    ];

    public function country() {
        return $this->belongsTo(Country::class,'country_id');
    }
    
    public function region() {
        return $this->belongsTo(Region::class,'region_id');
    }
    
    public function area() {
        return $this->belongsTo(Area::class,'area_id');
    }
    public function partner() {
        return $this->hasone(Partner::class, 'center_id');    
    }
    public function trainingsSchadual() {
        return $this->hasMany(TrainingSchadual::class,'center_id');    
    }
    public function responsibles() {
        return $this->hasMany(CenterResponsible::class,'center_id');
    }
    
    public function instructors_count() {
        $center_ids = Instructor::where('center_id',$this->id)->groupBy('center_id')->pluck('center_id')->toArray();
        return $this->whereIn('id',$center_ids)->count();
    }
    
    public function students_count() {
        $trainings_ids = TrainingSchadual::where('center_id',$this->id)->groupBy('training_id')->pluck('training_id')->toArray();
        $students_ids = Student::whereIn('training_id',$trainings_ids)->groupBy('user_id')->pluck('user_id')->toArray();
        return count($students_ids);
    }
    
    public function trainings_count() {
        $trainings_ids = TrainingSchadual::where('center_id',$this->id)->groupBy('training_id')->pluck('training_id')->toArray();
        return count($trainings_ids);
    }
    
    public function courses_count() {
        $trainings_ids = TrainingSchadual::where('center_id',$this->id)->groupBy('training_id')->pluck('training_id')->toArray();
        $courses_ids = TrainingCourse::whereIn('training_id',$trainings_ids)->groupBy('course_id')->pluck('course_id')->toArray();
        return count($courses_ids);
    }
    
    
    
}
