<?php

namespace App\Imports;

use App\Models\Training;
use App\Models\TrainingSchadual;
use App\Models\Survey;
use App\Models\TrainingSurvey;
use App\Models\InstructorInfo;
use App\Models\TrainingCourse;
use App\Models\Center;
use App\Models\Course;
use App\Models\Region;
use App\Models\User;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;

use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Writer\ValidationException;
use PhpOffice\PhpSpreadsheet\Shared\Date;

class TrainingImport implements ToModel, WithStartRow
{
    public function model(array $row)
    {
        if (strlen($row[0]) === 0) {
            return null;
        }

        $training = Training::where('code', $row[1])->first();

        $instructor = User::where('type', 'instructor')->where('f_name', $row[16])->first();
        $instructorId = $instructor ? $instructor->id : null;

        $coordinator = User::where('type', 'coordinator')->where('f_name', $row[17])->first();
        $coordinatorId = $coordinator ? $coordinator->id : null;

        $marketer = User::where('type', 'marketer')->where('f_name', $row[18])->first();
        $marketerId = $marketer ? $marketer->id : null;

        $region = Region::where('name_ar', $row[8])->first();
        if (!$region) {
            return null;
        }

        $center = Center::where('name_ar', $row[15])->first();
        if (!$center) {
            return null;
        }

        $course = Course::where('code', $row[0])->first();
        if (!$course) {
            return null;
        }

        $startDate = Date::excelToDateTimeObject($row[5]);
        $endDate = Date::excelToDateTimeObject($row[6]);

        if ($training) {
            $training->update([
                'code' => $row[1],
                'name_ar' => $row[2],
                'name_en' => $row[3],
                'time_from' => $row[10],
                'time_to' => $row[11],
                'timing_type' => $row[12],
                'overall_days' => $row[13],
                'overall_time' => $row[14],
                'region_id' => $region->id,
                'instructor_id' => $instructorId,
                'coordinator_id' => $coordinatorId,
                'marketer_id' => $marketerId,
                'training_certificate' => '20359.jpeg',
                'status' => 1,
                'updated_by' => auth()->user()->id,
            ]);

            $training->trainings_schaduals->update([
                'start_date' => $startDate,
                'end_date' => $endDate,
                'training_id' => $training->id,
                'center_id' => $center->id,
                'updated_by' => auth()->user()->id,
            ]);

            TrainingCourse::where('training_id', $training->id)->update([
                'training_id' => $training->id,
                'course_id' => $course->id,
                'instructor_id' => $instructorId,
                'updated_by' => auth()->user()->id,
            ]);

            $survey = Survey::where('name_ar', "استبيان دورات مهارات مبدعون للمتدربين")->first();
            TrainingSurvey::where('training_id', $training->id)->update([
                'training_id' => $training->id,
                'survey_id' => $survey ? $survey->id : null,
                'updated_by' => auth()->user()->id,
            ]);
        } else {
            $training = Training::create([
                'code' => $row[1],
                'name_ar' => $row[2],
                'name_en' => $row[3],
                'time_from' => $row[10],
                'time_to' => $row[11],
                'timing_type' => $row[12],
                'overall_days' => $row[13],
                'overall_time' => $row[14],
                'region_id' => $region->id,
                'instructor_id' => $instructorId,
                'coordinator_id' => $coordinatorId,
                'marketer_id' => $marketerId,
                'training_certificate' => '20359.jpeg',
                'status' => 1,
                'created_by' => auth()->user()->id,
            ]);
            

            $qrCodeFilePath = $this->createQRCode($training->id);
            $training->update(['qr_code' => $qrCodeFilePath]);

            TrainingSchadual::create([
                'start_date' => $startDate,
                'end_date' => $endDate,
                'training_id' => $training->id,
                'center_id' => $center->id,
                'created_by' => auth()->user()->id,
            ]);

            TrainingCourse::create([
                'training_id' => $training->id,
                'course_id' => $course->id,
                'instructor_id' => $instructorId,
                'created_by' => auth()->user()->id,
            ]);

            $surveys = [11,12,13];
            foreach($surveys as $survey) {
                TrainingSurvey::create([
                    'training_id' => $training->id,
                    'survey_id' => $survey,
                    'created_by' => auth()->user()->id,
                ]);
            }
            
        }
    }

    public function createQRCode($id)
    {
        $writer = new PngWriter();
        $qrCode = QrCode::create(url('training/' . $id . '/attendance'))
            ->setEncoding(new Encoding('UTF-8'))
            ->setErrorCorrectionLevel(ErrorCorrectionLevel::Low)
            ->setSize(100)
            ->setMargin(10)
            ->setRoundBlockSizeMode(RoundBlockSizeMode::Margin)
            ->setForegroundColor(new Color(0, 0, 0))
            ->setBackgroundColor(new Color(255, 255, 255));

        $result = $writer->write($qrCode);
        $filePath = base_path("uploads/trainings/QRCodes/$id-qrCode.png");
        $result->saveToFile($filePath);

        return "$id-qrCode.png";
    }

    public function startRow(): int
    {
        return 2;
    }
}
