<?php

namespace App\Imports;

use App\Models\Student;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithUpserts;

class RoundImport implements ToModel,WithUpserts,WithStartRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        return new Student([
            'std_name_en' => $row[0],
            'std_name_ar' => $row[1],
            'email' => $row[2],
            'branch_id' => $row[3],
            'field_id' => $row[4],
            'nationality' => $row[5],
            'iqama_num' => $row[6],
            'iqama_expire_at' => $row[7],
            'qualification' => $row[8],
            'job_number' => $row[9],
            'phone1' => $row[10],
            'phone2' => $row[11],
            'notes' => $row[12],
            'created_by' => auth()->user()->id,
        ]);
    }

    public function uniqueBy()
    {
        return 'iqama_num';
    }
    
    public function startRow(): int
    {
        return 2;
    }
}
