<?php

namespace App\Imports;

use App\Models\Training;
use App\Models\TrainingSchadual;
use App\Models\InstructorInfo;
use App\Models\TrainingCourse;
use App\Models\Center;
use App\Models\Region;
use App\Models\Area;
use App\Models\CenterResponsible;
use App\Models\User;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;

use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Writer\ValidationException;
use PhpOffice\PhpSpreadsheet\Shared\Date;

class CenterImport implements ToModel, WithStartRow
{

    public function __construct(){
    }
    
    
    public function model(array $row)
    {
        if(strlen($row[0]) === 0) {
            return null;
        }
        $area = Area::where('name_ar', $row[5])->first();
        $region = Region::where('name_ar', $row[4])->first();
        if (empty($region)) {
            $region = Region::create([
                'name_ar'=>$row[4],
                'name_en'=>$row[4],
                'area_id'=>$area->id,
                'status'=>1,
                'created_by' => auth()->user()->id,
                ]);
        }
        if (empty($area)) {
            $area = new Area();
            $area->name_ar=$row[5];
            $area->name_en=$row[5];
            $area->country_id=1;
            $area->status=1;
            $area->created_by = auth()->user()->id;
            $area->save();
        }
       
       $old_center = Center::where('name_ar', $row[0])->first();
        if($old_center){
            CenterResponsible::create([
                'center_id'=>$old_center->id,
                'responsible_name'=>$row[7],
                'responsible_job'=>$row[8],
                'responsible_email'=>$row[9],
                'responsible_phone'=>$row[10],
                'responsible_whatsapp'=>$row[11],
                'created_by' => auth()->user()->id,
            ]);
        }else{
            $center = Center::create([
            'name_ar'=>$row[0],
            'name_en'=>$row[1],
            'text_ar'=>$row[2],
            'text_en'=>$row[3],
            'map_url'=>$row[6],
            'country_id'=>1,
            'region_id'=>$region->id,
            'area_id'=>$area->id,
            'status'=>1,
            'created_by' => auth()->user()->id,
            ]);
            CenterResponsible::create([
                'center_id'=>$old_center->id,
                'responsible_name'=>$row[7],
                'responsible_job'=>$row[8],
                'responsible_email'=>$row[9],
                'responsible_phone'=>$row[10],
                'responsible_whatsapp'=>$row[11],
                'created_by' => auth()->user()->id,
            ]);
            
        }
    }

     public function startRow(): int
    {
        return 2; 
    }

}
