<?php

namespace App\Http\Middleware;

use Closure;
use App;
use Session;
use App\Models\Setting;
use App\Models\Service;
use App\Models\Project;
use App\Models\Category;
use App\Models\BlogItem;
use App\Models\Training;
use App\Models\BlogCategory;
use App\Models\Page;
use App\Models\Event;
use App\Models\TrainingField;

use \Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class LangRedirection
{

     public function handle($request, Closure $next)
       {
    
    $slugLang = $request->segment(1);
        App::setLocale($slugLang);
        $currentLang = App::getLocale();
        $test_lang = Setting::first()->default_lang;        
        
        if ($slugLang == $currentLang) {
            $url = $request->url();

            
            if ($request->segment(2) == 'blog') {
                $blog = BlogItem::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                $redirectUrl = url("/$slugLang/blog/{$blog->{'link_' . $slugLang}}");
                $url = urldecode($url);
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }
            
            if ($request->segment(2) == 'page') {
                $blog = Page::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                $redirectUrl = url("/$slugLang/page/{$blog->{'link_' . $slugLang}}");
                $url = urldecode($url);
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }
     
            if ($request->segment(2) == 'about-us') {
                $redirectUrl = url("/$slugLang/about-us");
                $url = urldecode($url);
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }
            
            if ($request->segment(2) == 'blogs') {
                if($request->segment(3)){
                    $blog = BlogItem::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                    // $category = BlogCategory::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                    $redirectUrl = url("/$slugLang/blogs/{$blog->{'link_' . $slugLang}}");
                    $url = urldecode($url);
                } else {
                    $redirectUrl = url("/$slugLang/blogs");
                    $url = urldecode($url);
                }
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }
            
             if ($request->segment(2) == 'courses') {
                if($request->segment(3)){
                    $field = TrainingField::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                    if(!$field){
                        return $next($request);
                    }
                    $redirectUrl = url("/$slugLang/courses/{$field->{'link_' . $slugLang}}");
                    $url = urldecode($url);
                } else {
                    $redirectUrl = url("/$slugLang/courses");
                    $url = urldecode($url);
                }
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }
                    
                
            
            if ($request->segment(2) == 'category') {
                $category = Category::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                $redirectUrl = url("/$slugLang/category/{$category->{'link_' . $slugLang}}");
                $url = urldecode($url);
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }
            
             if ($request->segment(2) == 'service') {
                $service = Service::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                $redirectUrl = url("/$slugLang/service/{$service->{'link_' . $slugLang}}");
                $url = urldecode($url);
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }
            if ($request->segment(2) == 'webinars') {
                if($request->segment(3)){
                    $webinar = Event::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                    $redirectUrl = url("/$slugLang/webinars/{$webinar->{'link_' . $slugLang}}");
                    $url = urldecode($url);
                } else {
                    $redirectUrl = url("/$slugLang/webinars");
                    $url = urldecode($url);
                }
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }
             
            
             if ($request->segment(2) == 'course') {
                $course = Training::where("link_en", $request->segment(3))->orWhere("link_ar", $request->segment(3))->first();
                $redirectUrl = url("/$slugLang/course/{$course->{'link_' . $slugLang}}");
                $url = urldecode($url);
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }  
                
             if ($request->segment(2) == 'sub-categories') {
                $subCategories = Category::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                if(!$subCategories){
                         return redirect('/');
                }
                $redirectUrl = url("/$slugLang/sub-categories/{$subCategories->{'link_' . $slugLang}}/$subCategories->id");
                $url = urldecode($url);
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }    
            
              if ($request->segment(2) == 'page') {
                $page = Page::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
              
                $redirectUrl = url("/$slugLang/page/{$page->{'link_' . $slugLang}}");
                $url = urldecode($url);
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }    
            return $next($request);
        }

        if ($slugLang != $test_lang) {
            
            $url = $request->url();
            
            if ($request->segment(2) == 'blog') {
                $blog = BlogItem::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                $redirectUrl = url("/$slugLang/blog/{$blog->{'link_' . $slugLang}}");
                if($redirectUrl != $url){
                    return redirect($redirectUrl);
                }   
            }
            
            if ($request->segment(2) == 'page') {
                $blog = BlogItem::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                $redirectUrl = url("/$slugLang/page/{$blog->{'link_' . $slugLang}}");
                if($redirectUrl != $url){
                    return redirect($redirectUrl);
                }   
            }

            if ($request->segment(2) == 'service') {
                $service = Service::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                $redirectUrl = url("/$slugLang/service/{$service->{'link_' . $slugLang}}");
                if($redirectUrl != $url){
                    return redirect($redirectUrl);
                }   
            }
            
            if ($request->segment(2) == 'product') {
                $product = Product::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                $redirectUrl = url("/$slugLang/product/{$product->{'link_' . $slugLang}}");
                $url = urldecode($url);
                if($redirectUrl != $url){
                    return redirect($redirectUrl);
                }
            }  
            
            if ($request->segment(2) == 'category') {
                $category = Category::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                $redirectUrl = url("/$slugLang/category/{$category->{'link_' . $slugLang}}");
                $url = urldecode($url);
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }
            if ($request->segment(2) == 'page') {
                $page = Page::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                $redirectUrl = url("/$slugLang/product/{$page->{'link_' . $slugLang}}");
                $url = urldecode($url);
                if($redirectUrl != $url){
                    return redirect($redirectUrl);
                }
            }  
            
            if ($request->segment(2) == 'about-us') {
                $redirectUrl = url("/$slugLang/about-us");
                $url = urldecode($url);
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }
            
            if ($request->segment(2) == 'webinars') {
                if($request->segment(3)){
                    $webinar = Event::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                    $redirectUrl = url("/$slugLang/webinars/{$webinar->{'link_' . $slugLang}}");
                    $url = urldecode($url);
                } else {
                    $redirectUrl = url("/$slugLang/webinars");
                    $url = urldecode($url);
                }
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }
            
            if ($request->segment(2) == 'blogs') {
                if($request->segment(3)){
                    $category = BlogCategory::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                    $redirectUrl = url("/$slugLang/blogs/{$category->{'link_' . $slugLang}}");
                    $url = urldecode($url);
                } else {
                    $redirectUrl = url("/$slugLang/blogs");
                    $url = urldecode($url);
                }
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }
            
            if ($request->segment(2) == 'courses') {
                if($request->segment(3)){
                    $field = TrainingField::where("link_en", $request->segment(3))->orwhere("link_ar", $request->segment(3))->first();
                    $redirectUrl = url("/$slugLang/courses/{$field->{'link_' . $slugLang}}");
                    $url = urldecode($url);
                } else {
                    $redirectUrl = url("/$slugLang/courses");
                    $url = urldecode($url);
                }
                if($redirectUrl == $url){
                    return $next($request);
                }else{
                    return redirect($redirectUrl);
                }
            }
            
            return $next($request);
      }
}
    
}
