<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\WhyChooseUsStruct;
use DB;
use File;
use Image;
use App\Helpers\Helper;

class WhyChooseUsStructController extends Controller
{
    
    public function __construct()
    {
        // $this->middleware('permission:aboutStruc');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $WhyChooseUsStructs = WhyChooseUsStruct::orderBy('id','DESC')->get();
        return view('admin.whyChooseUsStruct.WhyChooseUsStructs',compact('WhyChooseUsStructs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.whyChooseUsStruct.addWhyChooseUsStruct');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $add = new WhyChooseUsStruct();
        $add->title_en = $request->title_en;
        $add->text_en = $request->text_en;
        $add->title_ar = $request->title_ar;
        $add->text_ar = $request->text_ar;
        $add->status = $request->status;
        $add->alt_img = $request->alt_img;
        if($request->image){
            $add->image = Helper::uploadImage('whyChooseUsStruct',$request->image);
        } 
        $add->save();
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return redirect()->route('whyChooseUsStruct.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $WhyChooseUsStruct = WhyChooseUsStruct::find($id);
        if($WhyChooseUsStruct){
            return view('admin.whyChooseUsStruct.editWhyChooseUsStruct',compact('WhyChooseUsStruct'));
        }else{
            abort('404');
        }
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $add = WhyChooseUsStruct::find($id);
        $add->title_en = $request->title_en;
        $add->text_en = $request->text_en;
        $add->title_ar = $request->title_ar;
        $add->text_ar = $request->text_ar;
        $add->status = $request->status;
        $add->alt_img = $request->alt_img;
        if($add->image && $request->image){
            $add->image = Helper::updateUploadedImage('whyChooseUsStruct',$request->image ,$add->image);
        }elseif($request->image){
            $add->image = Helper::uploadImage('whyChooseUsStruct',$request->image);
        } 
        $add->save();
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return redirect()->route('whyChooseUsStruct.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        $allElements = ($ids[0] == 'on')? true:false;
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }

        $img_path = base_path() . '/uploads/whyChooseUsStruct/';
        if($allElements){
            foreach ($ids as $id) {
                $WhyChooseUsStruct = WhyChooseUsStruct::findOrFail($id);
                if ($WhyChooseUsStruct->image) {
                    (file_exists(sprintf($img_path . '%s', $WhyChooseUsStruct->image)))?unlink(sprintf($img_path . '%s', $WhyChooseUsStruct->image)):'';
                }
            }
            WhyChooseUsStruct::truncate();
            
        }else{
        
            foreach ($ids as $id) {
                $WhyChooseUsStruct = WhyChooseUsStruct::findOrFail($id);
                if ($WhyChooseUsStruct->image) {
                    (file_exists(sprintf($img_path . '%s', $WhyChooseUsStruct->image)))?unlink(sprintf($img_path . '%s', $WhyChooseUsStruct->image)):'';
                }
                $WhyChooseUsStruct->delete();
            }
        }
    }
}
