<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Models\Area;
use App\Models\Region;
use App\Models\Address;
use App\Models\CrmClient;
use App\Models\CrmClientStatus;
use App\Models\Cart;
use App\Models\Exame;
use App\Models\Course;
use App\Models\Event;
use App\Models\GuestCart;
use App\Models\NewsItem;
use App\Models\NewsCategory;
use App\Models\IntroSlider;
use App\Models\Level;
use App\Models\NewsLetter;
use App\Models\OrderCourse;
use App\Models\WhyChooseUsStruct;
use App\Models\WhyChooseUs;
use App\Models\PartnerFront;
use App\Models\PaymentMethod;
use App\Models\TrainingField;
use App\Models\Teacher;
use App\Models\Testimonial;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\HomeSlider;
use App\Models\Category;
use App\Models\HomeImage;
use App\Models\Training;
use DB;
use App\Models\MenuItem;
use Auth;
use App\Models\Service;
use App\Models\CompanyRequest;
use App\Models\Project;
use App\Models\Page;
use App\Models\AboutStruc;
use App\Models\About;
use App\Models\ContactUs;
use App\Models\Setting;
use App\Models\CourseSucscriberRequest;
use App\Models\WebinarSucscriberRequest;
use Mail;
use App\Models\BlogCategory;
use App\Models\ServiceCategory;
use App\Models\CourseReview;
use App\Models\BlogItem;
use App\Models\GalleryImage;
use App\Models\GalleryVideo;
use App\Models\SeoAssistant;
use App\Models\Configration;
use Melbahja\Seo\Schema;
use Melbahja\Seo\Schema\Thing;
use Melbahja\Seo\MetaTags;
use App\Models\Faq;
use App\Models\Comment;
use App\Models\Writer;
use App\Models\Brand;
use App\Traits\SeoTrait;
use App\Support\Collection;
use App\Models\Career;
use App\Models\CareerApplication;
use App\Models\Certificate;
use App\Models\TrainingApplication;
use App\Models\User;
use App\Models\CrmInvoice;
use App\Models\CrmCompanyTraining;
use \Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Symfony\Component\Translation\Catalogue\AbstractOperation;

class WebsiteController extends Controller
{
    use SeoTrait;
        public function checkUrl($slug){
            $checkMenu = MenuItem::where('type',$slug)->first();
            // $checkBlog = BlogItem::where('link_en', $slug)->orWhere('link_ar', $slug)->first();
            // $checkService = Service::where('link_en',$slug)->orWhere('link_ar',$slug)->first();
            // $checkProject = Project::where('link_en', $slug)->orWhere('link_ar', $slug)->first(); 

            if($checkMenu){
                return $this->menus($checkMenu->type);
            }else{
                abort('404'); 
            }
        } 

    //////// function retun dynamic menu//////////
    public function menus($menu){
        $menu = MenuItem::where('type',$menu)->first();
        $lang=\LaravelLocalization::getCurrentLocale();

        if(!$menu){
            abort(404);
        }
   
        elseif($menu->type == 'home'){
            return $this->home();
        }

        elseif($menu->type == 'about-us'){
            return $this->aboutUs();
        }

        elseif($menu->type == 'contact-us'){
            return $this->contactUs();
        }

        elseif($menu->type == 'projects'){
            return $this->getProjects();
        }

        elseif($menu->type == 'services'){
            return $this->getservices();
        }

        elseif($menu->type == 'galleryImages'){
             return $this->getGalleryImages();
        }


        elseif($menu->type == 'galleryVideos'){
             return $this->getGalleryVideos();
        }

        elseif($menu->type == 'blogs'){
             return $this->getBlogs();
        }

        elseif($menu->type == 'careers'){
            return $this->getCareersPage();
        }

        elseif($menu->type == 'training'){
            return $this->applyTrainingPage();
        }

        elseif($menu->type == 'developers'){
            return $this->developersPage();
        }
        elseif($menu->type == 'webinars'){
            return $this->webinarsPage();
        }
    }

    ////////////// function returnindex page///////////
    public function home(){
        $lang=\LaravelLocalization::getCurrentLocale();
        $blogs = BlogItem::where('status',1)->where('home',1)->take(3)->get();
        $categories = Category::where('status',1)->where('home',1)->get();
        $services = Service::where('status',1)->limit(6)->get();
        $about = About::first();
        $aboutStrucs = AboutStruc::where('status',1)->get();
        $whyChooseUs = WhyChooseUs::first();
        $whyChooseUsStructs = WhyChooseUsStruct::where('status',1)->get();
        $brands = Brand::where('status',1)->take(12)->get();
        $partners = PartnerFront::where('status',1)->take(12)->get();
        $testimonials = Testimonial::where('status',1)->where('lang',$lang)->orderBy('id')->get();
        $projects = Project::where('status',1)->where('recommended',1)->take(2)->get();
        $galleryImages = GalleryImage::where('status',1)->orderBy('order','asc')->take(7)->get();
        $home_slider = HomeSlider::where('status',1)->where('lang',$lang)->first();
        // $training_field = TrainingField::where('id',3)->where('status',1)->first();
        // if($training_field) {
        $professional_certificates = Category::where(function ($query) {
                $query->where('name_en', 'Professional Certificates')
                      ->orWhere('name_ar', 'الشهادات المهنية');
            })->first();
        $rondomCourses = Training::with('discount')->where('status',1)->where('category_id','!=',$professional_certificates->id)->limit(6)->get(); 
            // $featureCourses = Training::with('discount')->whereNotIn('training_field_id',[3,20])->where('status',1)->limit(4)->get();
        // } else {
        //     $rondomCourses = [];
        //     $featureCourses = Training::with('discount')->where('training_field_id','!=',20)->where('status',1)->limit(4)->get();
        // }
        $headerCourses = Training::with('discount')->where('status',1)->limit(6)->where('header',1)->limit(5)->get(); 
        $webinars = Event::where('status',1)->where('end_date','>=',Carbon::now())->limit(4)->get();
        $instructors = Teacher::get();
        $brands = Brand::where('status',1)->get();
        Helper::resetCart();

        ////// seo script//////
        list($schema, $metatags) = $this->homePageSeo();

        return view('website.home',compact('home_slider','brands','partners','headerCourses','whyChooseUs','whyChooseUsStructs','instructors','rondomCourses','services','webinars','aboutStrucs','galleryImages','about','testimonials','projects','blogs','schema','metatags','categories','brands'));
    }

    ////// Get courses of field //////
    public function get_field_trainings(Request $request,$link){
        $field = TrainingField::where('link_en',$link)->orWhere('link_ar',$link)->first();
        $courses_query = Training::where('training_field_id',$field->id)->where('status', 1);
        if($request->price && count($request->price)==1){

            foreach($request->price as $price_filter){
                if($price_filter=="free"){
                    $courses_query = $courses_query->where('price',0);
                }else{
                    $courses_query = $courses_query->where('price','!=',0);
                }
            }
        }
        if($request->search_input_courses){
            $courses_query = $courses_query->where('name_en','LIKE','%'.$request->search_input_courses . '%')->orwhere('name_ar','LIKE','%'.$request->search_input_courses . '%');
        }
        if($request->categories){
            $courses_query = $courses_query->whereIN('category_id',$request->categories);
        }
        if($request->levels){
            $courses_query = $courses_query->whereIN('level_id',$request->levels);
        }
        $courses = $courses_query->paginate(9);
        
        $totalCourses = count($courses);
        $categories = Category::where('status',1)->get();
        $levels = Level::get();
        list($metatags)= $this->coursesPageSeo($link);
        return view('website.courses',compact('courses','field','metatags','totalCourses','categories','levels'));
    }


    public function webinarsPage(){
        $next_webinars = Event::where('status',1)->where('end_date','>=',Carbon::now())->paginate(9);
        $previous_webinars = Event::where('status',1)->where('end_date','<=',Carbon::now())->paginate(9);
        return view('website.webinars',compact('next_webinars','previous_webinars'));
    }
    public function webinarDetails($link){
        $webinar = Event::where('link_en',$link)->orWhere('link_ar',$link)->first();
        return view('website.webinar_details',compact('webinar'));
    }


    public function getWriter($id){
        $writer = Writer::find($id);
        $blogss = BlogItem::where('status', 1)->where('writer_id', $id)->get();
        $news = NewsItem::where('status', 1)->where('writer_id', $id)->get();
        $lang=\LaravelLocalization::getCurrentLocale();
        $about = About::first();
        $configration = Configration::where('lang',$lang)->first();
        $setting = Setting::first();
        $seo = SeoAssistant::first();
        $schema1 = new Thing('LocalBusiness', [
            'name'          => $configration->app_name,
            'url'          => LaravelLocalization::localizeUrl('/'),
            'image'         => url("uploads/settings/source/$configration->app_logo"),
            'telephone' => $setting->mobile,
            'address' => $configration->address1,
        ]);


        $schema2= new Thing('Organization', [
            'url'          => LaravelLocalization::localizeUrl('/'),
            'logo'         => url("uploads/settings/source/$configration->app_logo"),
            'contactPoint' => new Thing('ContactPoint', [
                'telephone' => $setting->mobile,
                'contactType' => 'customer service'
            ]),
        ]);

        $schema = new Schema(
            $schema1,
            $schema2
        );

        $metatags = new MetaTags();
        $metatags
                ->title(($seo->home_meta_title)? $seo->home_meta_title:$configration->app_name)
                ->meta('title',($seo->home_meta_title)? $seo->home_meta_title:$configration->app_name)
                ->description(($seo->home_meta_desc)?$seo->home_meta_desc:strip_tags($configration->about_app))
                ->meta('author',$configration->app_name)
                ->image(url("uploads/settings/source/$configration->app_logo"))
                ->mobile(LaravelLocalization::localizeUrl('/'))
                ->canonical(LaravelLocalization::localizeUrl('/'))
                ->shortlink(LaravelLocalization::localizeUrl('/'))
                ->meta('robots',($seo->home_meta_robots)?'index':'noindex');


        return view('website.writer_details', compact('writer', 'metatags', 'blogss','news','schema', 'setting', 'lang', 'seo'));
    }

    ////////////FUNCTION RETURN VIEW ABOUT US//////
    public function aboutUs(){
        $lang=\LaravelLocalization::getCurrentLocale();
        $about = About::first();
        $blogCategories= BlogCategory::orderBy('id','desc')->get();
        $aboutStrucs = AboutStruc::where('status',1)->get();
        $statments = Career::where('status',1)->where('type','statistics')->get();
        ////// seo script//////
        list($schema, $metatags) = $this->aboutUsPageSeo();
        return view('website.about-us',compact('lang','about','statments','aboutStrucs','metatags','schema','blogCategories'));
    }

    ////////////FUNCTION RETURN VIEW CONTACT US//////
    public function contactUs(){
        $lang=\LaravelLocalization::getCurrentLocale();
        $blogCategories= BlogCategory::orderBy('id','desc')->get();
        $addresses = Address::where('status',1)->get();
        $contact_messagges= Page::where('status',1)->orderBy('id')->get();
        ////// seo script//////
        list($schema, $metatags) = $this->contactUsPageSeo();
        return view('website.contact-us',compact('lang','addresses','schema','contact_messagges','metatags','blogCategories'));
    }
    
    public function saveCourseSubscriberRequest(Request $request){
        $request->validate([
        'full_name'=>'required|max:150',
        'training_id'=>'exists:trainings,id',
        'email'=>'required|email',
        'qualification'=>'required',
        'job'=>'required',
        'phone' => 'required', 
        ]);
        
        //check if student is registered before
        $checkRegisterdBefore = CourseSucscriberRequest::where('email',$request->email)
            ->where('training_id',$request->training_id)->first();
        if($checkRegisterdBefore){
             return response()->json([
                'status' => 'error',
                'message' => trans('home.You have previously registered')
            ]);
        }
        
        //store the request
        $add = new CourseSucscriberRequest();
        $add->training_id = $request->training_id;
        $add->full_name = $request->full_name;
        $add->email = $request->email;
        $add->phone = $request->phone;
        $add->qualification = $request->qualification;
        $add->job = $request->job;
        $add->save();
        
        $crm_client = CrmClient::updateOrCreate(
            [   "email"=>$request->email],
            [
            "name"=>$request->full_name,
            "phone"=>$request->phone,
            "type"=>"client",
            "status_id"=>19,
            ]);
        $training_company = CrmCompanyTraining::create([
            'company_id'=> $crm_client->id,
            'training_id'=> $request->training_id,
                ]);
        $training = Training::findOrFail($request->training_id);
        CrmInvoice::create([
            'client_id'=>$crm_client->id,
            'invoice_number'=>random_int(100000000, 999999999),
            'crm_company_tranining_id'=> $training_company->id,
            'invoice_value'=>$training->price,
            'training_cost'=>$training->price,
            'duration_days'=>$training->overall_days,
            'invoice_status'=>'in_training'
        ]);
            
        CrmClientStatus::create([
            'crm_client_id'=> $crm_client->id,
            'status_id'=> 19,
            ]);
        
        //send Email
//         Mail::send('emails/marketingProgramEmail', $add->toArray(), function($msg) {
//   			$msg->to('mohamed25369921@gmail.com', 'default')->subject('مهارات المبدعون');
//   			$msg->from(config('mail.from.address'),config('mail.from.name'));
// 		});


        return redirect()->back()->with('success', trans('home.Thank you for requesting us. A customer service officer will request you soon'));

    }
    
    public function saveWebinarSubscriberRequest(Request $request){
        $request->validate([
        'full_name'=>'required|max:150',
        'webinar_id'=>'exists:events,id',
        'email'=>'required|email',
        'qualification'=>'required',
        'job'=>'required',
        'phone' => 'required', 
        ]);
        
        //check if student is registered before
        $checkRegisterdBefore = WebinarSucscriberRequest::where('email',$request->email)->first();
        if($checkRegisterdBefore){
             return response()->json([
                'status' => 'error',
                'message' => trans('home.You have previously registered')
            ]);
        }
        
        //store the request
        $add = new WebinarSucscriberRequest();
        $add->webinar_id = $request->webinar_id;
        $add->full_name = $request->full_name;
        $add->email = $request->email;
        $add->phone = $request->phone;
        $add->qualification = $request->qualification;
        $add->job = $request->job;
        $add->save();
        
        // $crm_client = CrmClient::create([
        //     "name"=>$request->full_name,
        //     "email"=>$request->email,
        //     "phone"=>$request->phone,
        //     "training_id"=>$request->training_id,
        //     "type"=>"client",
        //     "status_id"=>19,
        //  ]);
        // CrmClientStatus::create([
        //     'crm_client_id'=> $crm_client->id,
        //     'status_id'=> 19,
        //     ]);
        
        //  send Email
        //  Mail::send('emails/marketingProgramEmail', $add->toArray(), function($msg) {
        //  $msg->to('mohamed25369921@gmail.com', 'default')->subject('مهارات المبدعون');
        //  $msg->from(config('mail.from.address'),config('mail.from.name'));
        //});


        return response()->json([
            'status' => 'success',
            'message' => trans('home.Thank you for requesting us. A customer service officer will request you soon')
        ]);
    }
    
    public function saveCompanyRequest(Request $request){
        $request->validate([
        'name'=>'required|max:150',
        'responsible_name'=>'required|max:150',
        'responsible_job'=>'required|max:150',
        'email'=>'required|email',
        'activity'=>'required',
        'message'=>'required',
        'phone' => 'required', 
        ]);
        
        //check if student is registered before
        $checkRegisterdBefore = CompanyRequest::where('email',$request->email)->first();
        if($checkRegisterdBefore){
             return response()->json([
                'status' => 'error',
                'message' => trans('home.You have previously registered')
            ]);
        }
        
        //store the request
        $add = new CompanyRequest();
        $add->name = $request->name;
        $add->responsible_name = $request->responsible_name;
        $add->responsible_job = $request->responsible_job;
        $add->email = $request->email;
        $add->phone = $request->phone;
        $add->activity = $request->activity;
        $add->message = $request->message;
        $add->save();
        
        //send Email
//         Mail::send('emails/marketingProgramEmail', $add->toArray(), function($msg) {
//   			$msg->to('mohamed25369921@gmail.com', 'default')->subject('مهارات المبدعون');
//   			$msg->from(config('mail.from.address'),config('mail.from.name'));
// 		});

        return response()->json([
            'status' => 'success',
            'message' => trans('home.Thank you for requesting us. A customer service officer will request you soon')
        ]);
    }

    ////////////// function saveContact//////////
    // public function saveContactUs(Request $request){
    //     $lang = LaravelLocalization::getCurrentLocale();
    //     app()->setLocale($lang);
    //     $request->validate([
    //       'name'=>'required|max:150',
    //       'email'=>'required|email',
    //       'message'=>'required',
    //       'phone'=>'required|regex:/(01)[0-9]{9}/',
    //     ]);

    //     $contact = new ContactUs();
    //     $contact->name = $request->name;
    //     $contact->email = $request->email;
    //     $contact->phone = $request->phone;
    //     $contact->message = $request->message;
    //     $contact->title = $request->title;
    //     $contact->save();

    //   return back()->with(['success'=>trans('home.Thank you for contacting us. A customer service officer will contact you soon')]);

    // }
    public function saveContactUs(Request $request)
    {
      $lang = LaravelLocalization::getCurrentLocale();
        app()->setLocale($lang);
        $request->validate([
          'name'=>'required|max:150',
          'email'=>'required|email',
          'message'=>'required',
          'phone'=>'required|regex:/(01)[0-9]{9}/',
        ]);

        $contact = new ContactUs();
        $contact->name = $request->name;
        $contact->email = $request->email;
        $contact->phone = $request->phone;
        $contact->message = $request->message;
        $contact->title = $request->title;
        $contact->save();
        
        $data = [
            'contact' => $contact,
            'name' => $request->name,
            'phone' => $request->phone,
            'email' => $request->email,
            'message' => $request->message
        ];
        
        $setting = Setting::first();
        Mail::send('emails/contact_email', $data, function ($msg) use ($setting, $request) {
            $subject = 'Bader - New Contact';
            $msg->to([$setting->contact_email], 'Booking Appointment')->subject($subject);
            $msg->cc(['begroup.seo@gmail.com']);
            $msg->cc(['begroup.seo1@gmail.com']);
            $msg->cc(['marwabegroup@gmail.com']);
            $msg->cc(['Yasmin.mostafa@begroup.com.sa']);
            $msg->from(config('mail.from.address'), config('mail.from.name'));
        });
    

       return back()->with(['success'=>trans('home.Thank you for contacting us. A customer service officer will contact you soon')]);
    }

    ////////// FUNCTION RETURN PAGE INFORMATION /////////
    public function getPage($link){
        $lang=\LaravelLocalization::getCurrentLocale();
        $page =Page::where('link_en',$link)->orwhere('link_ar',$link)->first();
        return view('website.page',compact('lang','page'));
    }

    /////////////////////FUNCTION RETURN VIEW BLOGS ///////////
    public function getBlogs(Request $request,$link = null){
        $lang=\LaravelLocalization::getCurrentLocale();
        if($link){
            $blogCategory = BlogCategory::where('link_en',$link)->orwhere('link_ar',$link)->first();
            $blogs = BlogItem::where('blogcategory_id',$blogCategory->id)->where('status',1)->paginate(9);
            $blogCategories= BlogCategory::orderBy('id','desc')->get();
            ////// seo script//////
            list($metatags) = $this->CategoryBlogsPageSeo($link);
            return view('website.blogs',compact('lang','blogCategory','blogs','metatags','blogCategories'));
        }else{
            $blogs = BlogItem::where('status',1)->paginate(9);
            ////// seo script//////
            list($metatags) = $this->blogsPageSeo();
            return view('website.blogs',compact('lang','blogs','metatags'));
        }
    }
    /////////////////////FUNCTION RETURN VIEW NEWS ///////////
    public function getNews($link = null){
        $lang=\LaravelLocalization::getCurrentLocale();
        if($link){
            $newsCategory = NewsCategory::where('link_en',$link)->orwhere('link_ar',$link)->first();
            $news = NewsItem::where('newscategory_id',$newsCategory->id)->where('status',1)->paginate(9);
            $newsCategories= NewsCategory::orderBy('id','desc')->get();
            ////// seo script//////
            list($metatags) = $this->newsPageSeo($link);
            return view('website.category-news',compact('lang','newsCategory','news','metatags','newsCategories'));
        }else{
            $news = NewsItem::where('status',1)->paginate(9);
            ////// seo script//////
            list($metatags) = $this->newsPageSeo();
            return view('website.news',compact('lang','news','metatags'));
        }
    }

    public function getCategoryBlogs($link ){
        $lang=\LaravelLocalization::getCurrentLocale();
        $blogCategory = BlogCategory::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $blogs = BlogItem::where('blogcategory_id',$blogCategory->id)->where('status',1)->paginate(9);


        $blogCategories= BlogCategory::orderBy('id','desc')->get();
        ////// seo script//////
        list($metatags) = $this->CategoryBlogsPageSeo($link);
        return view('website.blogs',compact('lang','blogCategory','blogs','metatags','blogCategories'));
      
        // $blogs = BlogItem::where('status',1)->paginate(9);
        // ////// seo script//////
        // list($metatags) = $this->blogsPageSeo();
        // return view('website.blogs',compact('lang','blogs','metatags'));
    }
    
    public function getCategoryNews($link ){
        $lang=\LaravelLocalization::getCurrentLocale();
        $newsCategory = NewsCategory::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $news = NewsItem::where('newscategory_id',$newsCategory->id)->where('status',1)->paginate(9);


        $newsCategories= NewsCategory::orderBy('id','desc')->get();
        ////// seo script//////
        list($metatags) = $this->CategoryNewsPageSeo($link);
        return view('website.news',compact('lang','newsCategory','news','metatags','newsCategories'));
      
        // $blogs = BlogItem::where('status',1)->paginate(9);
        // ////// seo script//////
        // list($metatags) = $this->blogsPageSeo();
        // return view('website.blogs',compact('lang','blogs','metatags'));
    }
    
    public function getCategoryServices($link){
        $lang=\LaravelLocalization::getCurrentLocale();
        $serviceCategory = ServiceCategory::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $services = Service::where('servicecategory_id',$serviceCategory->id)->where('status',1)->paginate(9);


        $serviceCategories= ServiceCategory::orderBy('id','desc')->get();
        ////// seo script//////
        list($metatags) = $this->CategoryBlogsPageSeo($link);
        return view('website.services',compact('lang','serviceCategory','services','metatags','serviceCategories'));
      
        // $blogs = BlogItem::where('status',1)->paginate(9);
        // ////// seo script//////
        // list($metatags) = $this->blogsPageSeo();
        // return view('website.blogs',compact('lang','blogs','metatags'));
    }

    /////////////////////FUNCTION RETURN VIEW BLOG ///////////
    public function getBlogPage($link){
        $blog = BlogItem::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $blog->update(['n_seen'=>$blog->n_seen+1]);
        $blogCategories= BlogCategory::orderBy('id','desc')->get();
        $faqs = Faq::where('type','blog_item')->where('blog_item_id',$blog->id)->get();
        $blogs = BlogItem::where('status',1)->where('blogcategory_id',$blog->blogcategory_id)->where('id','!=',$blog->id)->take(5)->get();
        $comments = Comment::where('type','blog')->where('type_id',$blog->id)->where('admin_approve',1)->get();
        $courses = Training::where('category_id',$blog->course_category_id)->limit(4)->get();
        ////// seo script//////
        list($schema, $metatags)= $this->blogSeo($link);

        return view('website.blog_details',compact('blog','schema','metatags','courses','faqs','comments','blogs','blogCategories'));
    }
    /////////////////////FUNCTION RETURN VIEW News ///////////
    public function getNewsPage($link){
        $news = NewsItem::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $news->update(['n_seen'=>$news->n_seen+1]);
        $newsCategories= NewsCategory::orderBy('id','desc')->get();
        $faqs = Faq::where('type','news_item')->where('news_item_id',$news->id)->get();
        $newss = NewsItem::where('status',1)->where('newscategory_id',$news->newscategory_id)->where('id','!=',$news->id)->take(5)->get();
        $comments = Comment::where('type','news')->where('type_id',$news->id)->where('admin_approve',1)->get();
        $courses = Training::where('category_id',$news->course_category_id)->get();
        ////// seo script//////
        list($metatags)= $this->newsSeo($link);

        return view('website.news_details',compact('news','metatags','courses','faqs','comments','newss','newsCategories'));
    }
    /////////////////////FUNCTION RETURN VIEW SERVICE  ///////////
    public function getServiceItem($link){
        $service = Service::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $serviceCategories= ServiceCategory::orderBy('id','desc')->get();
        $services = Service::where('status',1)->where('servicecategory_id',$service->servicecategory_id)->where('id','!=',$service->id)->take(5)->get();
        list($schema,$metatags)= $this->serviceSeo($link);

        return view('website.service-details',compact('service','schema','metatags','services','serviceCategories'));
    }
    /////////////////////FUNCTION RETURN VIEW Brad ///////////
    public function getBrandPage($link){
        $brand = Brand::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $products = Project::where('status',1)->where('brand_id',$brand->id)->get();
        $brands = Brand::where('status',1)->take(6)->get();
        ////// seo script//////
        list($schema, $metatags)= $this->brandSeo($link);
        return view('website.brandPage',compact('brand','products','schema','metatags','brands'));
    }

    ////////// function return list of published Brands/////
    public function getBrands(){
        $brands =Brand::where('status',1)->get();
        ////// seo script//////
        list($metatags)= $this->brandsPageSeo();
        return view('website.brands',compact('brands','metatags'));
    }
    ////////// function return list of published products/////
    public function getProjects(){
        // $projects =Project::where('status',1)->get();
        $categories =Category::where('status',1)->get();

        ////// seo script//////
        list($metatags)= $this->projectsPageSeo();
        return view('website.categories',compact('categories','metatags'));
        // return view('website.products',compact('projects','metatags'));
    }

    ////////// function return project Details /////
    public function getProductDetails($link){
        $product =Project::where('link_en',$link)->orwhere('link_ar',$link)->first();
        if($product){
            $new_products = Project::where('updated_at', '>', Carbon::now()->subDays(30))->where('category_id',$product->category_id)->orderBy('id')->take(6)->get();

            list($schema, $metatags)= $this->projectPageSeo($link);
            return view('website.product-details',compact('product','new_products','schema','metatags'));
        }else{
            abort('404');
        }
    }

    ////////// function return list of published services/////
    public function getservices($category =null){
        if($category) {
            $services = Service::where('servicecategory_id',$category)->where('status',1)->orderBy('order')->orderBy('name_ar')->paginate(9);
        } else {
            $services = Service::where('status',1)->orderBy('order')->orderBy('name_ar')->paginate(9);
        }
        ////// seo script//////
        list($metatags)= $this->servicesPageSeo(request()->segment(2));
        return view('website.services',compact('services','metatags'));
    }

    ////////// function return project service /////
    public function getServiceDetails($link){
        $service =Service::where('link_en',$link)->orwhere('link_ar',$link)->first();
        if($service){
            $services = Service::where('parent_id',0)->where('status',1)->orderBy('order')->orderBy('name_ar')->get();
            ////// seo script//////
            list($schema, $metatags)= $this->serviceSeo($link);
            return view('website.service-details',compact('service','services','metatags','schema'));
        }else{
            abort('404');
        }
    }

    public function getGalleryImages(){
        $images =GalleryImage::where('status',1)->orderBy('order','asc')->paginate(9);
        ////// seo script//////
        list($schema, $metatags)= $this->galleryImagesPageSeo();
        return view('website.gallery-images',compact('images','metatags','schema'));
    }

    public function getGalleryVideos(){
        $videos =GalleryVideo::where('status',1)->orderBy('order','asc')->get();
        $blogCategories= BlogCategory::orderBy('id','desc')->get();
        ////// seo script//////
        list($schema, $metatags)= $this->galleryVideosPageSeo();
        return view('website.gallery-videos',compact('videos','metatags','schema','blogCategories'));
    }

    public function saveComment(Request $request){
        $add = new Comment();
        $add->name=$request->name;
        $add->email=$request->email;
        $add->comment=$request->comment;
        $add->type=$request->type;
        $add->type_id=$request->type_id;
        $add->save();
        return back()->with(['success'=>trans('home.Thank you for your Comment , your commnet under review')]);

    }




    public function getDeveloperProjects($link){
        $developer = Brand::where('link_en',$link)->orwhere('link_ar',$link)->first();

        $projects =Project::where('brand_id',$developer->id)->where('status',1)->get();
        $projects = (new Collection($projects))->paginate(18);
        ////// seo script//////
        list($metatags)= $this->projectsPageSeo();
        return view('website.developer-project',compact('projects','metatags','developer'));
    }


    public function projectsSearchResults(Request $request){

        $projects =Project::where('status',1)->whereBetween('price', [intval($request->from)-1,intval($request->to)+1])->get();

        if($request->project_name){
            $projects =Project::where('status',1)->whereBetween('price', [intval($request->from)-1,intval($request->to)+1]);
            $projects =  $projects->where('name_en', 'like', '%' . $request->project_name . '%')->orwhere('name_ar', 'like', '%' . $request->project_name . '%')->get();
        }

        if($request->region_id){
            $projects =Project::where('status',1)->whereBetween('price', [intval($request->from)-1,intval($request->to)+1]);
            $projects =  $projects->where('name_en', $request->region_id)->get();
        }

        if($request->developer_id){
            $projects =Project::where('status',1)->whereBetween('price', [intval($request->from)-1,intval($request->to)+1]);
            $projects =  $projects->where('brand_id', $request->developer_id)->get();
        }

        if($request->project_area){
            $projects =Project::where('status',1)->whereBetween('price', [intval($request->from)-1,intval($request->to)+1]);
            $projects =  $projects->where('project_area', $request->project_area)->get();
        }
        $projects = (new Collection($projects))->paginate(18);

        return view('website.search-results',compact('projects'));
    }

    public function getRecommendedProjects(){
        $projects =Project::where('status',1)->where('recommended',1)->get();
        $recommendedProjects  = (new Collection($projects))->paginate(18);
        ////// seo script//////
        list($metatags)= $this->projectsPageSeo();
        return view('website.all-recommended-projects',compact('recommendedProjects','metatags'));
    }


    public function getCategoryProjects($link){
        $category = Category::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $projects =Project::where('status',1)->where('category_id',$category->id)->get();
        ////// seo script//////
        list($metatags)= $this->projectsPageSeo();
        return view('website.products',compact('projects','metatags','category'));
    }


    public function getCareersPage(){
        $careers = Career::where('status',1)->get();
        ////// seo script//////
        list($metatags)= $this->projectsPageSeo();
        return view('website.careers',compact('careers','metatags'));
    }

    public function applyTrainingPage(){
        ////// seo script//////
        list($metatags)= $this->projectsPageSeo();
        return view('website.apply-training',compact('metatags'));
    }

    public function developersPage(){
        ////// seo script//////
        list($metatags)= $this->projectsPageSeo();
        return view('website.developers',compact('metatags'));
    }

    public function saveCareerApplication(Request $request){
        $request->validate([
            'name'=>'required|max:150',
            'email'=>'required|email',
            'phone'=>'required|regex:/(01)[0-9]{9}/',
            'cv_file'=>'mimes:pdf,docx',
            'position'=>'required',
        ]);

        $add = new CareerApplication();
        $add->name = $request->name;
        $add->email = $request->email;
        $add->phone = $request->phone;
        $add->notes = $request->notes;
        $add->gender = $request->gender;
        $add->career_id = $request->career_id;
        $add->position = $request->position;

        //upload cv pdf file
        if($request->hasFile("cv_file")){
            $extension = $request->file('cv_file')->getClientOriginalExtension();
            $filename = rand(11111111, 99999999). '.' . $extension;
            $request->file('cv_file')->move( base_path() . '/uploads/careers/cvs', $filename );
            $add->cv_file = $filename;
        }

        $add->save();

        return back()->with(['success'=>trans('home.Thank you for contacting us. A customer service officer will contact you soon')]);
    }

    public function saveTrainingApplications(Request $request){
        $request->validate([
            'name'=>'required|max:150',
            'email'=>'required|email',
            'notes'=>'required',
            'phone'=>'required|regex:/(01)[0-9]{9}/',
        ]);

        $add = new TrainingApplication();
        $add->name = $request->name;
        $add->email = $request->email;
        $add->phone = $request->phone;
        $add->notes = $request->notes;
        $add->training = $request->training;
        $add->save();

        return back()->with(['success'=>trans('home.Thank you for contacting us. A customer service officer will contact you soon')]);

    }


    public function save_NewsLetter(Request $request){
        dd($request->all());
        $old_subscriber = NewsLetter::where('email',$request->email)->first();
        if(!$old_subscriber){
            NewsLetter::create(['email'=>$request->email]);
        }
return redirect()->to('https://bader.betraining.com.sa/en')->with('success', 'Thank you for subscribing!');

    }

    public function getCourses(Request $request){
        $courses_query = Training::where('status', 1);
        if($request->price && count($request->price)==1){

            foreach($request->price as $price_filter){
                if($price_filter=="free"){
                    $courses_query = $courses_query->where('price',0);
                }else{
                    $courses_query = $courses_query->where('price','!=',0);
                }
            }
        }
        if($request->search_input_courses){
            $courses_query = $courses_query->where('name_en','LIKE','%'.$request->search_input_courses . '%')->orwhere('name_ar','LIKE','%'.$request->search_input_courses . '%');
        }
        if($request->categories){
            $courses_query = $courses_query->whereIN('category_id',$request->categories);
        }
        if($request->levels){
            $courses_query = $courses_query->whereIN('level_id',$request->levels);
        }
        $courses = $courses_query->where('training_field_id','!=',20)->paginate(9);

        $totalCourses = count($courses);
        $categories = Category::where('status',1)->get();
        $levels = Level::get();
        list($metatags)= $this->coursesPageSeo();
        return view('website.courses',compact('courses','metatags','totalCourses','categories','levels'));
    }


    
    public function autoCompletesearch()
    {
        $lang = \LaravelLocalization::getCurrentLocale();
        $text = $_GET['phrase'];
        $courses = Course::where('name_en', 'like', '%' . $text . '%')->orwhere('name_ar', 'like', '%' . $text . '%')->where('status', 1)->get();
        $results = [];
        foreach ($courses as $query) {
            if ($lang == 'en') {
                $results[] = ['name' => $query->name_en];
            } else {
                $results[] = ['name' => $query->name_ar];
            }
        }
        return response()->json($results);
    }

     public function autoCompletesearch2()
    {
        $lang = \LaravelLocalization::getCurrentLocale();
        $text = $_GET['phrase'];
    
        // Fetch categories and trainings
        $categories = Category::where('name_en', 'like', '%' . $text . '%')
            ->orWhere('name_ar', 'like', '%' . $text . '%')
            ->where('status', 1)
            ->get();
    
        $trainings = Training::where('name_en', 'like', '%' . $text . '%')
            ->orWhere('name_ar', 'like', '%' . $text . '%')
            ->where('status', 1)
            ->get();
    
        // Prepare results for JSON response
        $categories_results = [];
        foreach ($categories as $query) {
            $categories_results[] = [
                'id' => $query->id,
                'name' => $lang === 'en' ? $query->name_en : $query->name_ar,
            ];
        }
    
        $trainings_results = [];
        foreach ($trainings as $query) {
            $trainings_results[] = [
                'id' => $query->id,
                'name' => $lang === 'en' ? $query->name_en : $query->name_ar,
                'link' => $lang === 'en' ? $query->link_en : $query->link_ar,
            ];
        }
    
        // Combine results into a single JSON response
        return response()->json([
            'categories' => $categories_results,
            'trainings' => $trainings_results,
        ]);
    }
      /////////////////// searchResult function //////////////
      public function searchResult(Request $request)
      {
        $search_input_courses = $request->input('search_input') ?? '';
        $courses_query = Training::where('status', 1);
        if($request->price && count($request->price)==1){

            foreach($request->price as $price_filter){
                if($price_filter=="free"){
                    $courses_query = $courses_query->where('price',0);
                }else{
                    $courses_query = $courses_query->where('price','!=',0);
                }
            }
        }
        if($search_input_courses){
            $courses_query = $courses_query->where('name_en','LIKE','%'.$search_input_courses.'%')->orwhere('name_ar','LIKE','%'.$search_input_courses.'%');
        }
        
        if($request->categories){
            $courses_query = $courses_query->whereIN('category_id',$request->categories);
        }
        if($request->levels){
            $courses_query = $courses_query->whereIN('level_id',$request->levels);
        }
        $courses = $courses_query->paginate(9);
        
        $totalCourses = count($courses);
        $categories = Category::where('status',1)->get();
        $levels = Level::get();
        list($metatags)= $this->coursesPageSeo();
        return view('website.searchResults',compact('courses','metatags','totalCourses','categories','levels','search_input_courses'));
         
      }

    public function getCategoryCourses($link,Request $request){
        $category = Category::orwhere('link_en',$link)->orwhere('link_ar',$link)->first();
        $courses_query = Training::where('category_id',$category->id)->where('status', 1);
        if($request->price && count($request->price)==1){

            foreach($request->price as $price_filter){
                if($price_filter=="free"){
                    $courses_query = $courses_query->where('price',0);
                }else{
                    $courses_query = $courses_query->where('price','!=',0);
                }
            }
        }
        if($request->search_input_courses){
            $courses_query = $courses_query->where('name_en','LIKE','%'.$request->search_input_courses . '%')->orwhere('name_ar','LIKE','%'.$request->search_input_courses . '%');
        }
        if($request->categories){
            $courses_query = $courses_query->whereIN('category_id',$request->categories);
        }
        if($request->levels){
            $courses_query = $courses_query->whereIN('level_id',$request->levels);
        }
        $courses = $courses_query->paginate(9);
        
        $totalCourses = count($courses);
        $categories = Category::where('status',1)->get();
        $levels = Level::get();
        list($metatags)= $this->categoryCoursesPageSeo($link);
        return view('website.category',compact('courses','category','metatags','totalCourses','categories','levels'));

    }

  public function getCourse($link){
        $course = Training::with(['course.chapters','course.chapters.lessons','level'])->where('link_ar',$link)->orWhere('link_en',$link)->first();

        if(!$course){
            abort('404');
        }
        /* redirect if ther is a redirect url found*/
        // if($course && $course->redirect_url){
        //     return redirect($course->redirect_url);
        // }
        $num_of_exam = Exame::where('course_id',$course->course->id)->count();
        $user = false ;
        if(auth()->check())
        {
           $check=  OrderCourse::where('user_id',auth()->user()->id)->where('course_id',$course->id)->first();
           if($check)
           {
               $user = true;
           }
        }
        $first_lesson = $course->course->chapters[0]->lessons[0] ?? null;
        $related_courses = Training::with('course.chapters.lessons')->where('status',1)->where('category_id',$course->category_id)->where('id','!=',$course->id)->take(3)->get();
        $reviews = CourseReview::with('user')->where('course_id',$course->id)->get();
        $averageRate = $reviews->avg('rate'); 
        $roundedRate = round($averageRate, 1);
        $student_num = OrderCourse::where('course_id',$course->id)->count();
        list($metatags,$schema)= $this->courseSeo($link);
        return view('website.course_details',compact('first_lesson','course','metatags','related_courses','roundedRate','schema','student_num','user','num_of_exam'));
    }
    
    public function getCategories(){
        $categories = Category::where('status',1)->get();
        return view('website.categories',compact('categories'));
    }





    public function validateCertificate(){
        return view('website.validateCertificate');
    }
    public function checkCertificate(Request $request){
        $request->validate([
            'certificateCode' => 'required|string|max:255',
        ]);
        $certificate = Certificate::where('certificate_code',$request->certificateCode)->where('status',1)->first();
        
        if($certificate){
            return redirect('validate-certificate')->with([
                'certificate' => $certificate->certificate_code,
                'success' => trans('home.Certificate is exist.')
            ]);
        }else{
            return redirect('validate-certificate')->with('error', trans('home.Certificate is not exist.'))->withInput();
        }
    }

    public function viewCertificate($certificateCode){
        $certificate_course = Certificate::where('certificate_code',$certificateCode)->where('status',1)->first();
        if(!$certificate_course){
            abort('404');
        }
        $course = Course::findOrFail($certificate_course->course_id);
        $user = User::findOrFail($certificate_course->user_id);

        $options = new \Dompdf\Options();
        $options->setIsRemoteEnabled(true);

        $dompdf =new \Dompdf\Dompdf($options);
        $dompdf->set_paper('A4', 'landscape');

        $view = view('userboard.certificate_form_pdf', compact('course', 'user','certificate_course'))->render();
        $dompdf->loadHtml($view);
        $dompdf->render();
        return $dompdf->stream('certificate.pdf', ['Attachment' => false]);
    }

    public function webinarCheckout($link){
        $webinar = Event::orWhere('link_en',$link)->orWhere('link_ar',$link)->first();
        $payment_methods = PaymentMethod::where('status',1)->get();
        if(Auth::check()){ 
            return view('userboard.webinarCheckout',compact('webinar','payment_methods'));
        }else{
            return view('userboard.guestwebinarCheckout',compact('webinar','payment_methods'));
        }

    }
    
    public function companiesRequests(){
        return view('website.companies-requests');

    }
    
    public function TermsAndConditions(){
        return view('website.terms-and-conditions');

    }
    
    public function ElearningAttendancePolicy(){
        return view('website.e-learning-attendance-policy');

    }
    
    public function ELearningIntegrityPolicy(){
        return view('website.e-learning-integrity-policy');

    }
    
    public function ETrainingPolicy(){
        return view('website.e-training-policy');

    }
    
     ////////// function return country regions/////
    public function getRegions()
    {
        $id = $_POST['id'];
        $regions = Region::where('area_id', $id)->where('status', 1)->select('name_en', 'id', 'name_ar')->get();
        return response()->json($regions);
    }
    
    ////////// function return region areas/////
    public function getAreas()
    {
        $id = $_POST['id'];
        $areas = Area::where('Country_id', $id)->where('status', 1)->select('name_en', 'id', 'name_ar')->get();
        return response()->json($areas);
    }
    
}
