<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Chapter;
use App\Models\Course;
use App\Models\CourseDiscount;
use App\Models\TrainingField;
use App\Models\CoursePoint;
use App\Models\CourseMaterial;
use App\Models\CourseRequirment;
use App\Models\Level;
use App\Models\Teacher;
use Illuminate\Http\Request;
use App\Models\Training;
use App\Models\Type;
use File;
use Image;
class TrainingController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:trainings');
    }

    public function index()
    {
        $trainings =Training::get();
        return view('admin.trainings.trainings',compact('trainings'));
    }
    
    public function show($id)
    {
    }
        public function create()
    {
        $fields = TrainingField::where('status',1)->get();
        $courses = Course::get();
        $levels = Level::get();
        $categories = Category::get();
        $types = Type::get();
        $teachers = Teacher::get();
        $points = CoursePoint::get();
        $materials = CourseMaterial::get();
        $requirments = CourseRequirment::get();

        return view('admin.trainings.addTraining',compact('levels','courses','fields','categories','types','teachers','points','materials','requirments'));
    }
    public function store(Request $request){
        $request->validate([
          'image' => 'image|mimes:jpeg,png,jpg,gif,svg,webp'
        ]);
        $training = new Training();
        $training->course_id = $request->course_id;
        $training->name_en = $request->name_en;
        $training->name_ar = $request->name_ar;
        $training->text_en = $request->text_en;
        $training->text_ar = $request->text_ar;
        $training->level_id = $request->level_id;
        $training->price = $request->price;
        $training->category_id = $request->category_id;
        $training->type_id = $request->type_id;
        $training->overall_days = $request->overall_days;
        $training->mobile = $request->mobile;
        $training->whatsapp = $request->whatsapp;
        $training->start_date = $request->start_date;
        $training->end_date = $request->end_date;
        $training->duration = $request->duration;
        $training->period = $request->period;
        $training->teacher_id = json_encode($request->teacher_id) ;
        $training->course_point_id = json_encode($request->point_id) ;
        $training->course_requirment_id = json_encode($request->requirment_id) ;
        $training->course_material_id = json_encode($request->material_id) ;
        $training->training_field_id = $request->training_field_id;
        $training->status = $request->status??0;
        $training->publish = $request->publish??0;
        $training->header = $request->header??0;
        $training->redirect_url = $request->redirect_url;
        $training->meta_title_en = $request->meta_title_en;
        $training->meta_title_ar = $request->meta_title_ar;
        $training->meta_desc_en =$request->meta_desc_en;
        $training->meta_desc_ar =$request->meta_desc_ar;
        $training->meta_robots =$request->meta_robots ?? 0;
        
        $training->intro_link=$request->intro_link?1:0;
        $training->intro_link_video=$request->intro_link_video?$this->convertToEmbedUrl($request->intro_link_video):null;

        $training->link_en = $request->link_en?preg_replace("/[ \/]/", "-", $request->link_en):preg_replace("/[ \/]/", "-", $request->name_en);
        $training->link_ar = $request->link_ar?preg_replace("/[ \/]/", "-", $request->link_ar):preg_replace("/[ \/]/", "-", $request->name_ar);
        if ($request->hasFile("video")) {

            $file = $request->file("video");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            $img_path = base_path() . '/uploads/courses/source/';
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/courses/source/' );                        
            $file->move($path, $fileName);

            $training->video = $fileName;
        }

        if ($request->hasFile("image")) {

            $file = $request->file("image");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/courses/source/' . $fileName);

            Image::make($file->getRealPath())->save($path);

            $training->image = $fileName;
        }

        if ($request->hasFile("certificate")) {

            $file = $request->file("certificate");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/courses/source/' . $fileName);
            Image::make($file->getRealPath())->save($path);
            $training->certificate = $fileName;
        }
        if ($request->hasFile("course_file")) {

            $file = $request->file("course_file");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/courses/source/' . $fileName);
            Image::make($file->getRealPath())->save($path);
            $training->course_file = $fileName;
        }
        $training->save();
        return redirect('admin/trainings')->with('success',trans('home.your_item_added_successfully'));

    }
    public function edit($id){
        $training = Training::find($id);
        if($training){
            $levels = Level::get();
            $fields = TrainingField::where('status',1)->get();
            $categories = Category::get();
            $types = Type::get();
            $teachers = Teacher::get();
            $points = CoursePoint::get();
            $materials = CourseMaterial::get();
            $requirments = CourseRequirment::get();
            $discount = $training->discount;
            $courses = Course::get();
            $intro_link = $training->intro_link;
            return view('admin.trainings.editTraining',compact('training','courses','fields','intro_link','levels','categories','types','teachers','points','materials','requirments','discount'));
        }
        else{
            abort('404');
        }
    }

    public function update(Request $request, $id){

        $request->validate([
          'image' => 'image|mimes:jpeg,png,jpg,gif,svg,webp'
        ]);
        $training = Training::find($id);
        $training->course_id = $request->course_id;
        $training->name_en = $request->name_en;
        $training->name_ar = $request->name_ar;
        $training->text_en = $request->text_en;
        $training->text_ar = $request->text_ar;
        $training->level_id = $request->level_id;
        $training->price = $request->price;
        $training->category_id = $request->category_id;
        $training->type_id = $request->type_id;
        $training->duration = $request->duration;
        $training->overall_days = $request->overall_days;
        $training->mobile = $request->mobile;
        $training->whatsapp = $request->whatsapp;
        $training->start_date = $request->start_date;
        $training->end_date = $request->end_date;
        $training->period = $request->period;
        $training->teacher_id = json_encode($request->teacher_id) ;
        $training->course_point_id = json_encode($request->course_point_id) ;
        $training->training_field_id = $request->training_field_id;
        $training->course_requirment_id = json_encode($request->requirment_id) ;
        $training->course_material_id = json_encode($request->material_id) ;
        $training->status = $request->status??0;
        $training->publish = $request->publish??0;
        $training->header = $request->header??0;
        $training->redirect_url = $request->redirect_url;
        $training->meta_title_en = $request->meta_title_en;
        $training->meta_title_ar = $request->meta_title_ar;
        $training->meta_desc_en =$request->meta_desc_en;
        $training->meta_desc_ar =$request->meta_desc_ar;
        $training->meta_robots =$request->meta_robots ?? 0;

        $training->link_en = $request->link_en?preg_replace("/[ \/]/", "-", $request->link_en):preg_replace("/[ \/]/", "-", $training->title_en);
        $training->link_ar = $request->link_ar?preg_replace("/[ \/]/", "-", $request->link_ar):preg_replace("/[ \/]/", "-", $training->title_ar);


        $training->intro_link=$request->intro_link?1:0;
        $training->intro_link_video=$request->intro_link_video?$this->convertToEmbedUrl($request->intro_link_video):null;

        if ($request->hasFile("image")) {

            $file = $request->file("image");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            $img_path = base_path() . '/uploads/courses/source/';
            if ($training->image != null) {
                file_exists($img_path.$training->image) ? unlink($img_path . $training->image):'';
            }
           // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/courses/source/' . $fileName);

            Image::make($file->getRealPath())->save($path);

            $training->image = $fileName;
        }
        if ($request->hasFile("video")) {

            $file = $request->file("video");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            $img_path = base_path() . '/uploads/courses/source/';
            if ($training->video != null) {
                file_exists($img_path.$training->video) ? unlink($img_path . $training->video):'';
            }
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/courses/source/' );                        
            $file->move($path, $fileName);

            $training->video = $fileName;
        }

        if ($request->hasFile("certificate")) {

            $file = $request->file("certificate");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            $img_path = base_path() . '/uploads/courses/source/';
            if ($training->certificate != null) {
                file_exists($img_path.$training->certificate) ? unlink($img_path . $training->certificate):'';
            }
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/courses/source/' );                        
            $file->move($path, $fileName);
            $training->certificate = $fileName;
        }
        if ($request->hasFile("course_file")) {

            $file = $request->file("course_file");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            $img_path = base_path() . '/uploads/courses/source/';
            if ($training->course_file != null) {
                file_exists($img_path.$training->course_file) ? unlink($img_path . $training->course_file):'';
            }
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/courses/source/' );                        
            $file->move($path, $fileName);
            $training->course_file = $fileName;
        }

        $training->save();

        if($request->do_discount){
            $training_discount = CourseDiscount::where('course_id',$id)->first();
            if($training_discount){
                return '11';
                $training_discount->value = $request->discount_value;
                $training_discount->end_date = $request->end_date;
                $training_discount->save();
            }else{
                $training_discount = new CourseDiscount();
                $training_discount->course_id = $id;
                $training_discount->value = $request->discount_value;
                $training_discount->end_date = $request->end_date;
                $training_discount->save();
            }

        }else{
            CourseDiscount::where('course_id',$id)->delete();
        }

        return redirect('admin/trainings')->with('success',trans('home.your_item_updated_successfully'));
    }
    public function training_chapters($training_id){
        $chapters =Chapter::where('training_id',$training_id)->get();
        return view('admin.chapters.chapters',compact('chapters'));
    }

    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        $img_path = base_path() . '/uploads/courses/source/';

        foreach ($ids as $id) {
            $m = Training::findOrFail($id);
            if ($m->image != null) {
                file_exists($img_path.$m->image) ? unlink($img_path . $m->image):'';
            }
            $m->delete();
        }
    }

    public function getChapters(Request $request){
        $training=Training::with('type')->where('id',$request->training_id)->first();
        $chapters = Chapter::where('training_id',$request->training_id)->get();
        return response()->json(['type_id'=>$training->type_id,'type'=>$training->type,'chapters'=>$chapters]);
    }

    public static function convertToEmbedUrl($url)
    {
        $urlParts = parse_url($url);
        if(!isset($urlParts['query'])) return null;
        parse_str($urlParts['query'], $queryParams);
        
        $videoId = $queryParams['v'] ?? null;
        $abChannel = $queryParams['ab_channel'] ?? null;

        if ($videoId) {
            $embedUrl = "https://www.youtube.com/embed/{$videoId}";
            if ($abChannel) {
                $embedUrl .= "?&ab_channel={$abChannel}";
            }
            return $embedUrl;
        }

        return $url; // Return original URL if conversion fails
    }


}
