<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Team;
use DB;
use File;
use Image;
use App\Helpers\Helper;

class TeamController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:teams');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $teams = Team::get();
        return view('admin.teams.teams',compact('teams'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.teams.addTeam');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $add = new Team();
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->position_en = $request->position_en;
        $add->position_ar = $request->position_ar;
        $add->text_en = $request->text_en;
        $add->text_ar = $request->text_ar;
        $add->status = $request->status;
        if($request->img){
            $add->img = Helper::uploadImage('teams',$request->img);
        } 
        $add->alt_img = $request->alt_img;
        $add->save();
        
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return redirect()->route('teams.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $team = Team::find($id);
        if($team){
            return view('admin.teams.editTeam',compact('team'));
        }else{
            abort('404');
        }
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $add = Team::find($id);
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->position_en = $request->position_en;
        $add->position_ar = $request->position_ar;
        $add->text_en = $request->text_en;
        $add->text_ar = $request->text_ar;
        $add->status = $request->status;
        if($add->img && $request->img){
            $add->img = Helper::updateUploadedImage('teams',$request->img ,$add->img);
        }elseif($request->img){
            $add->img = Helper::uploadImage('teams',$request->img);
        } 
        $add->alt_img = $request->alt_img;
        $add->save();
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return redirect()->route('teams.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        $allElements = ($ids[0] == 'on')? true:false;
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }

        $img_path = base_path() . '/uploads/teams/';
        if($allElements){
            
            foreach ($ids as $id) {
                $team = Team::findOrFail($id);
                if ($team->img) {
                    (file_exists(sprintf($img_path . '%s', $team->img)))?unlink(sprintf($img_path . '%s', $team->img)):'';
                }
            }
            Team::truncate();
            
        }else{
        
            foreach ($ids as $id) {
                $team = Team::findOrFail($id);
                if ($team->img) {
                    (file_exists(sprintf($img_path . '%s', $team->img)))?unlink(sprintf($img_path . '%s', $team->img)):'';
                }
                $team->delete();
            }
        }
    }
}
