<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Imports\StudentImport;
use Illuminate\Http\Request;
use Symfony\Component\Intl\Countries;

use App\Models\Training;
use App\Models\Student;
use App\Models\User;
use App\Models\StudentRequest;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\DB;
use Image;

class StudentRequestController extends Controller
{

    public function __construct()
    {
        // $this->middleware('permission:student_requests');
    }
 
    public function index()
    {
        $student_requests = StudentRequest::with(['user','student_info','course'])->get();
        $trainings = Training::all();
        return view('admin.studentRequests.index',compact('student_requests','trainings'));
    }


    public function edit($id)
    {
        $student_request = StudentRequest::with(['user','student_info','course'])->where('id',$id)->first();
        if ($student_request) {
            $student_request->update(['seen'=>1]);
            return response()->json(['view' => view('admin.studentRequests.edit', compact('student_request'))->render()]);
        } else {
            abort('views.404');
        }
    }


    public function update(Request $request, $id)
    {
        $user = User::find($id);
          $request->validate([
            'f_name' => 'required|string',
            'l_name' => 'required|string',
            'email' => 'required|string|email|max:255|unique:users,email,'.$id,
            'trainings' => 'required|exists:trainings,id',
            'mobile' => 'required',
            'image' => 'image|mimes:jpg,png,jpeg,gif,svg',
        ]);
        // new user
        $user->f_name = $request->f_name;
        $user->l_name = $request->l_name;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->verification_code = rand(111111, 999999);
        $user->type = 'partner';
        $user->device_type = 'web';
        $user->status =$request->status?? 0;
        $user->updated_by = auth()->user()->id;
        
        if ($request->hasFile("image")) {

            $file = $request->file("image");
            $mime = $request->file('image')->getMimeType();
            $mimearr = explode('/', $mime);
            
            $img_path = base_path() . '/uploads/users/source/';
            if ($user->image) {
                    (file_exists($img_path .  $user->image))?unlink($img_path . $user->image):'';
            }

            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path() . '/uploads/users/source/' . $fileName;

            Image::make($file->getRealPath())->save($path);

            $user->image = $fileName;
        }
        $user->save();
        
        // user_information
        $student_info = StudentInfo::where('user_id',$user->id)->first();
        $student_info->ssn = $request->ssn;
        $student_info->mobile = $request->mobile;
        $student_info->whatsapp = $request->whatsapp;
        $student_info->specialization = $request->specialization;
        $student_info->sub_specialization = $request->sub_specialization;
        $student_info->job_title = $request->job_title;
        $student_info->registration_date = $request->registration_date;
        $student_info->updated_by = auth()->user()->id;
        $student_info->save();
        
        // user_address
        $student_address = StudentAddress::where('student_id',$student_info->id)->first();
        $student_address->student_id = $student_info->id;
        $student_address->country_id = $request->country_id;
        $student_address->region_id = $request->region_id;
        $student_address->area_id = $request->area_id;
        $student_address->address = $request->address;
        $student_address->building_num = $request->building_num;
        $student_address->flat_num = $request->flat_num;
        $student_address->land_mark = $request->land_mark;
        $student_address->updated_by = auth()->user()->id;
        $student_address->save();
        
        
        $student = Student::where('user_id', $user->id)
                  ->whereNotIn('training_id', $request->trainings)
                  ->delete();
        
        foreach ($request->trainings as $training_id) {
            $existingStudent = Student::where('user_id', $user->id)
                                      ->where('training_id', $training_id)
                                      ->first();
            if (!$existingStudent) {
                $student = new Student();
                $student->user_id = $user->id;
                $student->training_id = $training_id;
                $student->created_by = auth()->user()->id;
                $student->save();
            }
        }
        toastr()->success(trans('home.item_updated_successfully'), trans('home.saved'));
        return redirect()->route('students.index');
    }
    
    public function student_requests_accept(Request $request){
        $ids = $request->id;
        if ($ids[0]=='on' ) {
            $student_requests = StudentRequest::with(['student_info'])->get();
        }
        else{
            $student_requests = StudentRequest::with('student_info')->whereIn('id',$request->id)->get();
        }
        foreach($student_requests as $student_request){
            Student::create(['user_id'=>$student_request->user_id,'training_id'=>$request->training_id,'created_by' => auth()->user()->id]);
            $student_request->delete();
        }
    }
    
    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            $user = StudentRequest::findOrFail($id);
            $user->delete();
        }
    }
    
}
