<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Imports\StudentImport;
use Illuminate\Http\Request;
use Symfony\Component\Intl\Countries;

use App\Models\Training;
use App\Models\InstructorInfo;
use App\Models\TrainingSurvey;
use App\Models\TrainingAttendance;
use App\Models\Student;
use App\Models\TrainingCourse;
use App\Models\TrainingSchadual;
use App\DataTables\StudentsDataTable;
use App\DataTables\StudentSchedualDataTable;
use App\Models\User;
use App\Models\Country;
use App\Models\TrainingExam;
use App\Models\StudentInfo;
use App\Models\StudentAddress;
use App\Models\Partner;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\DB;
use Image;
use DataTables;

use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Writer\ValidationException;
use App\DataTables\TrainingDataTable;
use Dompdf\Dompdf;
use Dompdf\Options;
use ZipArchive;
use Illuminate\Support\Facades\Response;

class StudentController extends Controller
{

    public function __construct()
    {
        // $this->middleware('permission:student');
    }
    public function index(StudentsDataTable $dataTable)
    {
        // $users = User::with(['student_info','trainings'])->where('type','student')->get();
        // return view('admin.students.index', compact('users'));
        return $dataTable->render('admin.students.index_copy');
    
    }



    public function schedule_students(StudentSchedualDataTable $dataTable)
    {
        // return User::find(2666)->trainings;
        // $trainings_selector = Training::where('status',1)->get();
        // if(auth()->user()->type=="partner"){
        //     // $center_ids = auth()->user()->partner->centers->pluck('id')->toArray();
        //     $center_ids =Partner::where('user_id',auth()->user()->id)->pluck('center_id')->toArray();
        //     $training_ids = TrainingSchadual::whereIn('center_id',$center_ids)->pluck('training_id')->toArray();
        //     $trainings = Training::with(['students','trainings_schaduals'])->whereIn('id',$training_ids)->where('status',1)->get();
        //     $trainings_selector= $trainings_selector->whereIn('id',$training_ids);
        // }
        // elseif(auth()->user()->type=="instructor"){
        //     // $instructor_id = InstructorInfo::where('user_id',auth()->user()->id)->first()->id;
        //     $training_ids = TrainingCourse::where('instructor_id',auth()->user()->id)->pluck('training_id')->toArray();
        //     $trainings = Training::with(['students','trainings_schaduals'])->whereIn('id',$training_ids)->orderBy('id','DESC')->where('status',1)->get();
        // }
        // else{
        //     $trainings = Training::with(['students','trainings_schaduals'])->where('status',1)->get();
        // }
        // if($training_id && $training_id!="all"){
        //     $trainings = $trainings->where('id',$training_id);
        // }

        // return view('admin.students.schedule_students', compact('trainings','trainings_selector'));
        return $dataTable->render('admin.students.schedule_students_copy');
    }
    
    public function viewTrainings(Request $request){
        $std_id = $request->std_id;
        $trainings = User::find($std_id)->trainings;
        return response()->json(['view' => view('admin.students.view_trainings_modal', compact('trainings','std_id'))->render()]);
    }
    
    public function viewTrainings2(Request $request){
        $std_id = $request->std_id;
        $trainings = User::find($std_id)->trainings;
        return response()->json(['view' => view('admin.students.view_trainings_modal2', compact('trainings','std_id'))->render()]);
    }


    public function create()
    {
        $trainings = Training::all();
        $countries = Country::all();
        return view('admin.students.create',compact('trainings','countries'));
    }
    
    // form to assign students to training
    public function assign_student()
    {
        $trainings = Training::all();
        $users = User::with('student_info')
            ->where('type', 'student')
            ->whereHas('student_info', function ($query) {
                $query->whereNotNull('ssn');
            })
            ->get();

        return view('admin.students.assign_student',compact('trainings','users'));
    }
    
    // store students to trainig action
    public function assign_student_store(Request $request)
    {
        $request->validate([
            'training' => 'required|string',
            'students' => 'required',
        ]);
        
        foreach($request->students as $stud){
            
            $student_check = Student::where('user_id',$stud)->where('training_id',$request->training)->first();
            if(!$student_check){
                $student_info = StudentInfo::where('user_id',$stud)->first();
                $training = Training::where('id',$request->training)->first();
                $student= new Student();
                $student->user_id = $stud;
                $student->training_id = $request->training;
                $student->certificate_serial = "SN-".$training->code.'-'.$stud;
                $student->certificate_qrcode = $this->createQRCode($student->certificate_serial);
                $student->created_by = auth()->user()->id;
                
                $student->save();
         
            }
        }
        toastr()->success(trans('home.your_item_added_successfully'), trans('home.saved'));
        return redirect()->route('students.index');
    }
    
    // Form Un_Assign students to trainig
    public function un_assign_student()
    {
        $trainings = Training::all();
        $users = User::with('student_info')
            ->where('type', 'partner')
            ->whereHas('student_info', function ($query) {
                $query->whereNotNull('ssn');
            })
            ->get();

        return view('admin.students.un_assign_student',compact('trainings','users'));
    }
    
    //  Un_Assign students to trainig action
    public function un_assign_student_remove(Request $request)
    {
        $request->validate([
            'training' => 'required',
            'students' => 'required',
        ]);
        Student::whereIn('user_id',$request->students)->whereIn('training_id',$request->training)->delete();
        TrainingAttendance::whereIn('user_id',$request->students)->whereIn('training_id',$request->training)->delete();
   
        toastr()->success(trans('home.item_deleted_successfully'), trans('home.saved'));
        return redirect()->route('students.index');
    }
    
    
    // store students data and its training

    public function store(Request $request)
    {
        $request->validate([
            'ssn' => 'required|string',
            'f_name' => 'required|string',
            'email' => ['required', 'string','max:255', 'unique:users,email'],
            'password' => ['string', 'min:8'],
            'trainings' => 'exists:trainings,id',
            'mobile' => 'required',
            'whatsapp' => 'required',
            'status' => 'required',
            'image' => 'sometimes|image|mimes:jpg,png,jpeg,gif,svg',
        ]);
        // new user
        $user =new User();
        $user->f_name = $request->f_name;
        $user->l_name = $request->l_name;
        $user->email = $request->email;
        $user->phone = $request->mobile;
        $user->password = Hash::make($request->password);
        $user->verification_code = rand(111111, 999999);
        $user->type = 'student';
        $user->device_type = 'web';
        $user->status = 1;
        $user->created_by = auth()->user()->id;
        $user->assignRole('متدرب / Trainee');
        
        if ($request->hasFile("image")) {

            $file = $request->file("image");
            // $mime = FacadesFile::mimeType($file);
            $mime = $request->file('image')->getMimeType();
            $mimearr = explode('/', $mime);

            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path() . '/uploads/users/source/' . $fileName;

            Image::make($file->getRealPath())->save($path);

            $user->image = $fileName;
        }
        $user->save();
        // user_information
        $student_info = new StudentInfo();
        $student_info->user_id = $user->id;
        $student_info->ssn = $request->ssn;
        $student_info->mobile = $request->mobile;
        $student_info->whatsapp = $request->whatsapp;
        $student_info->general_specialization = $request->general_specialization;
        $student_info->accurate_specialization = $request->accurate_specialization;
        $student_info->job_title_ksa_classification = $request->job_title_ksa_classification;
        $student_info->job_title_Insurances = $request->job_title_Insurances;
        $student_info->qualification = $request->qualification;
        $student_info->company = $request->company;
        $student_info->student_status = $request->student_status;
        $student_info->registration_date = $request->registration_date;
        $student_info->created_by = auth()->user()->id;
        $student_info->save();
        
        // user_address
        $student_address = new StudentAddress();
        $student_address->student_id = $student_info->id;
        $student_address->country_id = $request->country_id;
        $student_address->region_id = $request->region_id;
        $student_address->area_id = $request->area_id;
        $student_address->address = $request->address;
        $student_address->building_num = $request->building_num;
        $student_address->flat_num = $request->flat_num;
        $student_address->land_mark = $request->land_mark;
        $student_address->created_by = auth()->user()->id;
        $student_address->save();
        
        foreach($request->trainings as $training_id){
            $training = Training::find($training_id);
            $student= new Student();
            $student->user_id = $user->id;
            $student->training_id = $training_id;
            $student->certificate_serial = "SN-".$training->code.'-'.$user->id;
            $student->certificate_qrcode = $this->createQRCode($student->certificate_serial);
            $student->created_by = auth()->user()->id;
            $student->save();

        }
        toastr()->success(trans('home.item_added_successfully'), trans('home.saved'));
        return redirect()->route('students.index');
        
    }
        

    public function edit($id)
    {
        $trainings = Training::all();
        $countries = Country::all();
        // $user_data= Student::find($id);
        $user = User::with(['student_info','trainings'])
                ->where('id', $id)
                ->whereHas('student_info', function ($query) {
                    $query->whereNotNull('ssn');
                })
            ->first();
        if($user){
            return view('admin.students.edit', compact('user','trainings','countries'));
        } else {
            abort('views.404');
        }
    }


    public function update(Request $request, $id)
    {

        $request->validate([
            'ssn' => 'required|string',
            'f_name' => 'required|string',
            'email' => ['required', 'string', 'max:255', 'unique:users,email,'.$id],
            'trainings' => 'exists:trainings,id',
            'mobile' => 'required',
            'whatsapp' => 'required',
            'status' => 'required',
            'image' => 'image|mimes:jpg,png,jpeg,gif,svg',
        ]);
        $user = User::findOrFail($id);
        // new user
        $user->f_name = $request->f_name;
        $user->l_name = $request->l_name;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->verification_code = rand(111111, 999999);
        $user->type = 'student';
        $user->device_type = 'web';
        $user->status =$request->status?? 0;
        $user->updated_by = auth()->user()->id;
        
        if ($request->hasFile("image")) {

            $file = $request->file("image");
            $mime = $request->file('image')->getMimeType();
            $mimearr = explode('/', $mime);
            
            $img_path = base_path() . '/uploads/users/source/';
            if ($user->image) {
                    (file_exists($img_path .  $user->image))?unlink($img_path . $user->image):'';
            }

            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path() . '/uploads/users/source/' . $fileName;

            Image::make($file->getRealPath())->save($path);

            $user->image = $fileName;
        }
        $user->save();
        // user_information
        $student_info = StudentInfo::where('user_id',$user->id)->first();
        $student_info->ssn = $request->ssn;
        $student_info->mobile = $request->mobile;
        $student_info->whatsapp = $request->whatsapp;
        $student_info->general_specialization = $request->general_specialization;
        $student_info->accurate_specialization = $request->accurate_specialization;
        $student_info->job_title_ksa_classification = $request->job_title_ksa_classification;
        $student_info->job_title_Insurances = $request->job_title_Insurances;
        $student_info->qualification = $request->qualification;
        $student_info->company = $request->company;
        $student_info->student_status = $request->student_status;
        $student_info->registration_date = $request->registration_date;
        $student_info->updated_by = auth()->user()->id;
        $student_info->save();
        
        // user_address
        $student_address = StudentAddress::where('student_id',$student_info->id)->first() ?? new StudentAddress();
        $student_address->student_id = $student_info->id;
        $student_address->country_id = $request->country_id;
        $student_address->region_id = $request->region_id;
        $student_address->area_id = $request->area_id;
        $student_address->address = $request->address;
        $student_address->building_num = $request->building_num;
        $student_address->flat_num = $request->flat_num;
        $student_address->land_mark = $request->land_mark;
        $student_address->updated_by = auth()->user()->id;
        $student_address->save();
        

        $student = Student::where('user_id', $user->id)
                  ->whereNotIn('training_id', $request->trainings)
                  ->delete();
        
        foreach ($request->trainings as $training_id) {
            $existingStudent = Student::where('user_id', $user->id)
                                ->where('training_id', $training_id)
                                ->first();
            if (!$existingStudent) {
                $training = Training::find($training_id);
                $student = new Student();
                $student->user_id = $user->id;
                $student->training_id = $training_id;
                $student->certificate_serial = "SN-".$training->code.'-'.$user->id;
                $student->certificate_qrcode = $this->createQRCode($student->certificate_serial);
                $student->created_by = auth()->user()->id;
                $student->save();
            }
        }
        toastr()->success(trans('home.item_updated_successfully'), trans('home.saved'));
        return redirect()->route('students.index');
    }
    
    
    public function students_per_training(Request $request){
        $training = Training::find($request->training_id);
        $students = Student::with('user')->where('training_id',$request->training_id)->get();
        return view('admin.students.students_per_training', compact('training','students'));
        
    }
    
    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            $user = User::findOrFail($id);
            $img_path = base_path() . '/uploads/users/source/';
            if ($user->image) {
                    (file_exists($img_path .  $user->image))?unlink($img_path . $user->image):'';
            }
             $user->delete();
           
        }
    }
    
    public function change_view_certificate(Request $request){
        $student = Student::where('user_id',$request->user_id)->first();
        if($request->type == 'student') {
            $student->student_view_certificate = $request->view_certificate;
            $student->save();
        } else {
            $student->center_view_certificate = $request->view_certificate;
            $student->save();
        }
        return response()->json(['success' => true, 'message' => __('home.your_data_have_been_updated_successfully')]);
    }
    
   public function generate_certificates(Request $request) {
        $lang = \LaravelLocalization::getCurrentLocale();
        $ids = $request->ids;
        $training = Training::with('trainings_schaduals')->findOrFail($request->training_id);
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        if(auth()->user()->type != 'super_admin') {
            foreach($ids as $i=>$id) {
                $s = Student::where('user_id',$id)->where('training_id',$request->training_id)->first();
                
                if($s->student_view_certificate == 0 || now() < \Carbon\Carbon::parse($training->trainings_schaduals->end_date)) {
                    unset($ids[$i]);
                }
                
                if(auth()->user()->type == 'partner') {
                    if($s->center_view_certificate == 0) {
                        unset($ids[$i]);
                    }
                }
                
                if($training->exame || $training->trainingSurvey) {
                    $exam_results = TrainingExam::join('exame_results','exame_results.exame_id','training_exams.exam_id')
                                    ->where('training_exams.training_id',$request->training_id)
                                    ->where('exame_results.user_id',$s->user_id)
                                    ->get();
                    
                    $attendances_count = TrainingAttendance::where('training_id',$request->training_id)
                                    ->where('user_id',$s->user_id)
                                    ->count();
                    
                    $survey_results = TrainingSurvey::join('survay_results','survay_results.survay_id','trainings_surveys.survey_id')
                                    ->where('survay_results.training_id',$request->training_id)
                                    ->where('survay_results.user_id',$s->user_id)
                                    ->count();
                                    
                    if( ((($attendances_count / $training->overall_days) * 100 ) < 60) || ($survey_results < 0) || (count($exam_results) == 0  && isset($exam_results->first()->success_rate) && $exam_results->pluck('result')->max() < $exam_results->first()->success_rate) ){
                        unset($ids[$i]);
                    }
                    
                }
            }
        }
        
        if(count($ids) == 0) {
            return redirect()->back()->with('error',trans('home.students_not_deserved_certificate'));
        }
        

        $students = Student::with('studentinfo','user')
            ->whereIn('user_id', $ids)
            ->where('training_id', $request->training_id)
            ->get();
    
        $zip = new ZipArchive();
        $zipFileName = $training->code . ' - ' . $training->{'name_'.$lang} . '.zip';
        $zipFilePath = public_path('generated_certificates_pdf/' . $zipFileName);

        // Ensure the directory exists
        if (!file_exists(public_path('generated_certificates_pdf'))) {
            mkdir(public_path('generated_certificates_pdf'), 0755, true);
        }
    
        if ($zip->open($zipFilePath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === true) {
            foreach ($students as $student) {
                $options = new \Dompdf\Options();
                $options->set('fontDir', public_path('fonts'));
                $options->set('defaultFont', 'Cairo');
        
                $dompdf = new \Dompdf\Dompdf($options);
                $dompdf->set_paper('A4', 'landscape');
                $dompdf->set_option('isRemoteEnabled', true);
        
                $view = view('admin.certificate_form_pdf', compact('student', 'training'))->render();
                $dompdf->loadHtml($view);
                $dompdf->render();
        
                $pdfFileName = tempnam(sys_get_temp_dir(), 'pdf');
                file_put_contents($pdfFileName, $dompdf->output());
        
                $zip->addFile($pdfFileName, $student->user->f_name . '.pdf');
            }
            $zip->close();
    
            // Clean up temporary files
            foreach ($students as $student) {
                $pdfFileName = sys_get_temp_dir() . '/' . $student->user->f_name . '.pdf';
                @unlink($pdfFileName);
            }
    
            if (file_exists($zipFilePath)) {
                return response()->download($zipFilePath)->deleteFileAfterSend(true);
            } else {
                return response()->json(['error' => 'Zip file does not exist after creation'], 500);
            }
        } else {
            return response()->json(['error' => 'Failed to create zip file'], 500);
        }
    }
    
   public function generate_certificates_for_students_monitor(Request $request) {
        $lang = \LaravelLocalization::getCurrentLocale();
        $ids = explode(',', $request->ids);
        $training = Training::with('trainings_schaduals')->findOrFail($request->training_id);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        
        if(auth()->user()->type != 'super_admin') {
            foreach($ids as $i=>$id) {
                $s = Student::where('user_id',$id)->where('training_id',$request->training_id)->first();
                
                if($s->student_view_certificate == 0 || now() < \Carbon\Carbon::parse($training->trainings_schaduals->end_date)) {
                    unset($ids[$i]);
                }
                
                if(auth()->user()->type == 'partner') {
                    if($s->center_view_certificate == 0) {
                        unset($ids[$i]);
                    }
                }
                
                if($training->exame || $training->trainingSurvey) {
                    $exam_results = TrainingExam::join('exame_results','exame_results.exame_id','training_exams.exam_id')
                                    ->where('training_exams.training_id',$request->training_id)
                                    ->where('exame_results.user_id',$id)
                                    ->get();
                    
                    $attendances_count = TrainingAttendance::where('training_id',$request->training_id)
                                    ->where('user_id',$id)
                                    ->count();
                    
                    $survey_results = TrainingSurvey::join('survay_results','survay_results.survay_id','trainings_surveys.survey_id')
                                    ->where('survay_results.training_id',$request->training_id)
                                    ->where('survay_results.user_id',$id)
                                    ->count();
                                    
                    if( ((($attendances_count / $training->overall_days) * 100 ) < 60) || ($survey_results < 0) || (count($exam_results) == 0  && isset($exam_results->first()->success_rate) && $exam_results->pluck('result')->max() < $exam_results->first()->success_rate) ){
                        unset($ids[$i]);
                    }
                    
                }
            }
        }
        
        if(count($ids) == 0) {
            return redirect()->back()->with('error',trans('home.students_not_deserved_certificate'));
        }
        
    
        $students = Student::with('studentinfo', 'user')
            ->whereIn('user_id', $ids)
            ->where('training_id', $request->training_id)
            ->get();
    
        $zip = new ZipArchive();
        $zipFileName = $training->code . ' - ' . $training->{'name_' . $lang} . '.zip';
        $zipFilePath = public_path('generated_certificates_pdf/' . $zipFileName);
    
        // Ensure the directory exists
        if (!file_exists(public_path('generated_certificates_pdf'))) {
            mkdir(public_path('generated_certificates_pdf'), 0755, true);
        }
    
        if ($zip->open($zipFilePath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === true) {
            foreach ($students as $student) {
                $options = new \Dompdf\Options();
                $options->set('fontDir', public_path('fonts'));
                $options->set('defaultFont', 'Cairo');
    
                $dompdf = new \Dompdf\Dompdf($options);
                $dompdf->set_paper('A4', 'landscape');
                $dompdf->set_option('isRemoteEnabled', true);
    
                $view = view('admin.certificate_form_pdf', compact('student', 'training'))->render();
                $dompdf->loadHtml($view);
                $dompdf->render();
    
                $pdfFileName = tempnam(sys_get_temp_dir(), 'pdf');
                file_put_contents($pdfFileName, $dompdf->output());
    
                $zip->addFile($pdfFileName, $student->user->f_name . '.pdf');
            }
            $zip->close();
    
            // Clean up temporary files
            foreach ($students as $student) {
                $pdfFileName = sys_get_temp_dir() . '/' . $student->user->f_name . '.pdf';
                @unlink($pdfFileName);
            }
    
            if (file_exists($zipFilePath)) {
                return response()->json(['file_url' => asset('public/generated_certificates_pdf/' . $zipFileName)]);
            } else {
                return response()->json(['error' => 'Zip file does not exist after creation'], 500);
            }
        } else {
            return response()->json(['error' => 'Failed to create zip file'], 500);
        }
    }

   

    public function importExcel(Request $request)
    {
        if (empty($request->file('excelFile'))) {
            toastr()->error(trans('home.file_not_found'), trans('home.not_found'));
            return redirect()->back();
        }else{
            $students = Excel::import(new StudentImport,$request->file('excelFile'));
            toastr()->success(trans('home.your_item_added_successfully'), trans('home.saved'));
            return redirect()->back();
        }
        
    }

    public function certificate_serial()
    {
        $start = 16400;
        $end = 16446;
        $limit = $end - $start +1;
        $students = Student::skip($start-1)->take($limit)->get();
        foreach($students as $student){
            $training = Training::find($student->training_id);
            
            
            $writer = new PngWriter();
            $qrCode = QrCode::create(url('certificate/'.$student->certificate_serial))
                    ->setEncoding(new Encoding('UTF-8'))
                    ->setErrorCorrectionLevel(ErrorCorrectionLevel::Low)
                    ->setSize(100)
                    ->setMargin(10)
                    ->setRoundBlockSizeMode(RoundBlockSizeMode::Margin)
                    ->setForegroundColor(new Color(0, 0, 0))
                    ->setBackgroundColor(new Color(255, 255, 255));
                    
            $result = $writer->write($qrCode);
            $result->saveToFile(base_path("uploads/students/trainingCertificatesQRCodes/$student->certificate_serial-qrCode.png"));
            $serial = "SN-".$training->code.'-'.$student->user_id;
            $qr = $serial.'-qrCode.png'; 
        

            
            $student->update([
                'certificate_serial' => $serial,
                'certificate_qrcode' => $qr,
            ]);
        }
        return 'success';
    }
    
    
  // Create Training  QR code
   public function createQRCode($serial){
        $writer = new PngWriter();
        $qrCode = QrCode::create(url('certificate/'.$serial))
                ->setEncoding(new Encoding('UTF-8'))
                ->setErrorCorrectionLevel(ErrorCorrectionLevel::Low)
                ->setSize(100)
                ->setMargin(10)
                ->setRoundBlockSizeMode(RoundBlockSizeMode::Margin)
                ->setForegroundColor(new Color(0, 0, 0))
                ->setBackgroundColor(new Color(255, 255, 255));
                
        $result = $writer->write($qrCode);
        $result->saveToFile(base_path("uploads/students/trainingCertificatesQRCodes/$serial-qrCode.png"));
        return $serial.'-qrCode.png'; 
             
    }
}
