<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ServiceCategory;
use App\Helpers\Helper;

class ServiceCategoryController extends Controller
{


    public function __construct()
    {
        $this->middleware('permission:ServiceCategory');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $serviceCategories= ServiceCategory::orderBy('id','desc')->get();
        return view('admin.serviceCategories.serviceCategories',compact('serviceCategories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.serviceCategories.addserviceCategory');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $ServiceCategory = new ServiceCategory();
        $ServiceCategory->name_en = $request->name_en;
        $ServiceCategory->name_ar = $request->name_ar;
        $ServiceCategory->link_en = str_replace(" ","-",$request->link_en);
        $ServiceCategory->link_ar = str_replace(" ","-",$request->link_ar);
        $ServiceCategory->text_en = $request->text_en;
        $ServiceCategory->text_ar = $request->text_ar;
        $ServiceCategory->status = $request->status;
        $ServiceCategory->meta_title_en = $request->meta_title_en;
        $ServiceCategory->meta_title_ar = $request->meta_title_ar;
        $ServiceCategory->meta_desc_en =$request->meta_desc_en;
        $ServiceCategory->meta_desc_ar =$request->meta_desc_ar;
        $ServiceCategory->meta_robots =$request->meta_robots;
        $ServiceCategory->save();
        
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return redirect()->route('service-categories.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $serviceCategory = ServiceCategory::find($id);
        if($serviceCategory){
            return view('admin.serviceCategories.editServiceCategory',compact('serviceCategory'));
        }else{
            abort('404');
        }
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        //
        $ServiceCategory = ServiceCategory::find($id);
        $ServiceCategory->name_en = $request->name_en;
        $ServiceCategory->name_ar = $request->name_ar;
        $ServiceCategory->link_en = str_replace(" ","-",$request->link_en);
        $ServiceCategory->link_ar = str_replace(" ","-",$request->link_ar);
        $ServiceCategory->text_en = $request->text_en;
        $ServiceCategory->text_ar = $request->text_ar;
        $ServiceCategory->status = $request->status;
        
        $ServiceCategory->meta_title_en = $request->meta_title_en;
        $ServiceCategory->meta_title_ar = $request->meta_title_ar;
        $ServiceCategory->meta_desc_en =$request->meta_desc_en;
        $ServiceCategory->meta_desc_ar =$request->meta_desc_ar;
        $ServiceCategory->meta_robots =$request->meta_robots;
        $ServiceCategory->save();
        
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return redirect()->route('blog-categories.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        $allElements = ($ids[0] == 'on')? true:false;
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }

        if($allElements){
            ServiceCategory::truncate();
        }else{
        
            foreach ($ids as $id) {
                $ServiceCategory = ServiceCategory::findOrFail($id);
                $ServiceCategory->delete();
            }
        }
    }
}
