<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Imports\RoundImport;
use Illuminate\Http\Request;
use Symfony\Component\Intl\Countries;

use App\Models\Branch;
use App\Models\Field;
use App\Models\Round;
use Maatwebsite\Excel\Facades\Excel;

class RoundController extends Controller
{

    public function __construct()
    {
        // $this->middleware('permission:round');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $rounds = Round::all();
        return view('admin.rounds.rounds', compact('rounds'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // dd(app()->getLocale());
        $lang = \LaravelLocalization::getCurrentLocale();
        $nationalities = Countries::getNames($lang);
        $fields = Field::all();
        $branches = Branch::all();
        return view('admin.rounds.addRound',compact('nationalities','fields','branches'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // return $request;
        // dd($request->all());
        $request->validate([
            'std_name_en' => 'required|string',
            'std_name_ar' => 'required|string',
            'email' => 'required|email',
            'field_id' => 'required|exists:fields,id',
            'branch_id' => 'required|exists:branches,id',
            'nationality' => 'required',
            'qualification' => 'required',
            'iqama_num' => 'required|size:10|unique:rounds,iqama_num',
            'iqama_expire_at' => 'required|date',
            'phone1' => 'required',
            'image' => 'required|image|mimes:jpg,png,jpeg,gif,svg',
        ]);

        $add = new Round();
        $add->std_name_en = $request->std_name_en;
        $add->std_name_ar = $request->std_name_ar;
        $add->email = $request->email;
        $add->field_id = $request->field_id;
        $add->branch_id = $request->branch_id;
        $add->nationality = $request->nationality;
        $add->qualification = $request->qualification;
        $add->iqama_num = $request->iqama_num;
        $add->iqama_expire_at = $request->iqama_expire_at;
        $add->phone1 = $request->phone1;
        $add->phone2 = $request->phone2;
        $add->job_number = $request->job_number;
        $add->notes = $request->notes;
        if ($request->image) {
            $add->image = Helper::uploadImage('rounds', $request->image);
        }

        if ($request->attachments) {
            $add->attachments = Helper::uploadFile('rounds', $request->attachments);
        }

        $add->save();

        toastr()->success(trans('home.round_added_successfully'), trans('home.saved'));
        return redirect()->route('rounds.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $lang = \LaravelLocalization::getCurrentLocale();
        $round = Round::find($id);
        $nationalities = Countries::getNames($lang);
        $fields = Field::all();
        $branches = Branch::all();
        if ($round) {
            return view('admin.rounds.editRound', compact('round','nationalities','fields','branches'));
        } else {
            abort('views.404');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'std_name_en' => 'required|string',
            'std_name_ar' => 'required|string',
            'email' => 'required|email',
            'field_id' => 'required|exists:fields,id',
            'branch_id' => 'required|exists:branches,id',
            'nationality' => 'required',
            'qualification' => 'required',
            'iqama_num' => 'required|size:10',
            'iqama_expire_at' => 'required|date',
            'phone1' => 'required',
            'image' => 'sometimes|image|mimes:jpg,png,jpeg,gif,svg',
        ]);

        $updated = Round::find($id);

        $updated->std_name_en = $request->std_name_en;
        $updated->std_name_ar = $request->std_name_ar;
        $updated->email = $request->email;
        $updated->field_id = $request->field_id;
        $updated->branch_id = $request->branch_id;
        $updated->nationality = $request->nationality;
        $updated->qualification = $request->qualification;
        $updated->iqama_num = $request->iqama_num;
        $updated->iqama_expire_at = $request->iqama_expire_at;
        $updated->phone1 = $request->phone1;
        $updated->phone2 = $request->phone2;
        $updated->job_number = $request->job_number;
        $updated->notes = $request->notes;
        if ($request->image) {
            $updated->image = Helper::updateUploadedImage('rounds', $request->image,$updated->image);
        }

        if ($request->attachments) {
            $updated->attachments = Helper::updateUploadFile('rounds', $request->attachments,$updated->attachments);
        }

        $updated->save();

        toastr()->success(trans('home.round_updated_successfully'), trans('home.updated'));
        return redirect()->route('rounds.index');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            $m = Round::findOrFail($id);
            $m->delete();
        }
    }

    public function importExcel(Request $request)
    {
        if (empty($request->file('excelFile'))) {
            toastr()->error(trans('home.file_not_found'), trans('home.not_found'));
        }
        $rounds = Excel::import(new RoundImport,$request->file('excelFile'));

        foreach ($rounds as $round) {
            Round::create($round);
        }

        toastr()->success(trans('home.file_uploaded_successfully'), trans('home.file_uploaded'));
        return redirect()->back();
    }
}
