<?php

namespace App\Http\Controllers;

use App\Models\Center;
use App\Models\CenterHall;
use App\Models\Training;
use App\Models\User;
use App\Models\Course;
use App\Models\TrainingSchadual;
use App\Models\TrainingCourse;
use App\Models\Instructor;
use App\Models\Student;
use App\Models\StudentAddress;
use App\Models\StudentInfo;
use App\Models\Region;
use App\Models\Survey;
use App\Models\MarketingProgramRequest;
use Spatie\Permission\Models\Role;
use DB;
use DateTime;
use Session;
use Carbon\Carbon;

use Illuminate\Http\Request;

class ReportController extends Controller
{
    
    public function allReports(){
        $n_centers = 0;
        $n_courses = 0;
        $n_trainings = 0;
        $n_students = 0;
        $n_instructors = 0;
        $n_super_admins = 0;
        $n_admins = 0;
        $n_coordinators = 0;
        $n_marketers = 0;
        $n_partners = 0;
        $n_finished_courses = 0;
        $n_started_courses = 0;
        $n_not_started_courses = 0;
        $n_trainings_regions_count = 0;
        $n_filled_surveys_count = 0;
        $n_students_regions_count = 0;
        $n_deserved_certificate_students_count = 0;
        
        if(auth()->user()->type == 'instructor') {
            $n_courses = TrainingCourse::where('instructor_id',auth()->user()->id)->distinct('course_id')->count();
            $n_trainings = TrainingCourse::where('instructor_id',auth()->user()->id)->distinct('training_id')->count();
            $training_ids = TrainingCourse::where('instructor_id',auth()->user()->id)->pluck('training_id')->toArray();
            $n_students = count(Student::whereIn('training_id',$training_ids)->pluck('user_id')->toArray());
            $n_finished_courses = TrainingSchadual::whereIn('training_id',$training_ids)->where('end_date','<',new DateTime())->where('start_date','<',new DateTime())->count();
            $n_started_courses = TrainingSchadual::whereIn('training_id',$training_ids)->where('end_date','>=',new DateTime())->where('start_date','<=',new DateTime())->count();
            $n_not_started_courses = TrainingSchadual::whereIn('training_id',$training_ids)->where('end_date','>',new DateTime())->where('start_date','>',new DateTime())->count();
        } else if(auth()->user()->type == 'partner') {
            $center_ids =Partner::where('user_id',auth()->user()->id)->pluck('center_id')->toArray();
            $training_ids = TrainingSchadual::whereIn('center_id',$center_ids)->pluck('training_id')->toArray();
            $n_trainings = count($training_ids);
            $n_courses = count(TrainingCourse::whereIn('training_id',$training_ids)->pluck('course_id')->toArray());


            $n_instructors = count(TrainingCourse::whereIn('training_id',$training_ids)->distinct('instructor_id')->pluck('instructor_id')->toArray());
            $n_students = count(Student::whereIn('training_id',$training_ids)->distinct('user_id')->pluck('user_id')->toArray());
            $n_finished_courses = TrainingSchadual::whereIn('training_id',$training_ids)->where('end_date','<',new DateTime())->where('start_date','<',new DateTime())->count();
            $n_started_courses = TrainingSchadual::whereIn('training_id',$training_ids)->where('end_date','>=',new DateTime())->where('start_date','<=',new DateTime())->count();
            $n_not_started_courses = TrainingSchadual::whereIn('training_id',$training_ids)->where('end_date','>',new DateTime())->where('start_date','>',new DateTime())->count();
        } else if(auth()->user()->type == 'coordinator') {
            $n_trainings = count(Training::where('coordinator_id',auth()->user()->id)->pluck('id')->toArray());
            $n_instructors = Training::whereNotNull('instructor_id')->where('coordinator_id',auth()->user()->id)->count();
        } else if(auth()->user()->type == 'marketer') {
            $n_trainings = Training::where('marketer_id',auth()->user()->id)->count();
        } else {
            $n_centers = Center::count();
            $n_courses = Course::count();
            $n_trainings = Training::count();
            $n_students = User::where('type','student')->count();
            $n_partners = User::where('type','partner')->count();
            $n_instructors = Role::find(4)->users()->count();
            $n_super_admins = Role::find(1)->users()->count();
            $n_coordinators = Role::find(6)->users()->count();
            $n_marketers = Role::find(7)->users()->count();
            
            $n_finished_courses = TrainingSchadual::where('end_date','<',new DateTime())->where('start_date','<',new DateTime())->count();
            $n_started_courses = TrainingSchadual::where('end_date','>=',new DateTime())->where('start_date','<=',new DateTime())->count();
            $n_not_started_courses = TrainingSchadual::where('end_date','>',new DateTime())->where('start_date','>',new DateTime())->count();
            
            $n_trainings_regions_count = TrainingSchadual::select('centers_halls.region_id')
                                            ->join('centers_halls','trainings_schaduals.center_id','centers_halls.center_id')
                                            ->distinct('region_id')
                                            ->count();
            
            $n_filled_surveys_count = Survey::select('survay_results.user_id')->join('survay_results','survays.id','survay_results.survay_id')->distinct('user_id')->count();
            
            $n_deserved_certificate_students_count = Student::whereHas('attendance', function($query) {
                                                                $query->select(DB::raw('count(*) as attendance_count'))
                                                                      ->groupBy('user_id')
                                                                      ->having('attendance_count', '>', 3);
                                                        })->where('student_view_certificate',1)->count();
                
        }
        return view('admin.reports.allReports',compact('n_filled_surveys_count','n_deserved_certificate_students_count','n_trainings_regions_count','n_centers','n_courses','n_trainings','n_students','n_partners','n_instructors','n_super_admins','n_coordinators','n_marketers','n_finished_courses','n_started_courses','n_not_started_courses'));
    }
    
    public function jobSeekersReports(){
        
        $registered_count = MarketingProgramRequest::count();
        $gada_count = MarketingProgramRequest::where('location','gada')->count();
        $riyadh_count = MarketingProgramRequest::where('location','riyadh')->count();
        $other_region_count = MarketingProgramRequest::where('location','other_region')->count();
        $male_count = MarketingProgramRequest::where('gender','male')->count();
        $female_count = MarketingProgramRequest::where('gender','female')->count();
        $university_count = MarketingProgramRequest::where('qualification','university')->count();
        $diploma_count = MarketingProgramRequest::where('qualification','diploma')->count();
        $secondary_count = MarketingProgramRequest::where('qualification','secondary')->count();
        $intermediate_count = MarketingProgramRequest::where('qualification','intermediate')->count();
        
        return view('admin.reports.job_seekers_reports',
                compact(
                    'registered_count','gada_count','riyadh_count','other_region_count','male_count',
                    'secondary_count','female_count','university_count','diploma_count','intermediate_count'
                ));
    }
    
    ///////////////////// function return view of center report ///////////////////////////////
    public function centerReportView(){
        $centers=Center::where('status',1)->get();

        return view('admin.reports.centerReports.CenterReport',compact('centers'));
    }
    
    ///////////// function return result using ajax generate  center report////////////////////
    public function centerReportStatistics(){
        
        $centerId=$_POST['centerId'];
        $dateFrom=$_POST['dateFrom'];
        $dateTo=$_POST['dateTo'];
        $from=date('Y-m-d H:i:s', strtotime($dateFrom." -1 days"));
        $to=date('Y-m-d H:i:s', strtotime($dateTo." +1 days"));
        

        if(empty($_POST['dateFrom']) && empty($_POST['dateTo'])) {
            $centers = Center::count();
            if($centerId=='all'){
                $center = null;
                $halls = CenterHall::count();
                
                $center_regions_ids = CenterHall::pluck('region_id')->toArray();
                $center_regions = Region::whereIn('id',$center_regions_ids)->count();
                
                $trainings = Training::count();
                $courses = Course::count();
                $instructors = User::where('type','instructor')->count();
                $students = User::where('type','student')->count();
                
                $student_user_ids = User::where('type','student')->pluck('id')->toArray();
                $students_ids = StudentInfo::whereIn('user_id', $student_user_ids)->pluck('id')->toArray();
                $students_regions_ids = StudentAddress::whereIn('student_id',$students_ids)->distinct('region_id')->pluck('region_id')->toArray();
                $students_regions = Region::whereIn('id',$students_regions_ids)->count();
                
                $most_popular_courses = Student::select('courses.name_ar','courses.name_en','courses.code',\DB::raw('count(student_training_registered.training_id) as tr_count'))
                        ->join('trainings','trainings.id','student_training_registered.training_id')
                        ->join('trainings_courses','trainings_courses.training_id','trainings.id')
                        ->join('courses','courses.id','trainings_courses.course_id')
                        ->groupBy('student_training_registered.training_id','student_training_registered.training_id')
                        ->orderBy('tr_count','DESC')
                        ->limit(8)
                        ->get();
                
                return response()->json([
                    'html' => view('admin.reports.centerReports.centerReportStatistics', compact('centerId','most_popular_courses','center_regions','students_regions','centers','halls','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }
            
            $center = Center::findOrFail($centerId);
            $halls = CenterHall::where('center_id', $centerId)->count();
            
            $center_regions_ids = CenterHall::where('center_id', $centerId)->distinct('region_id')->pluck('region_id')->toArray();
            $center_regions = Region::whereIn('id',$center_regions_ids)->count();
            
            $training_ids = TrainingSchadual::where('center_id', $centerId)->pluck('training_id')->toArray();
            $trainings = Training::whereIn('id', $training_ids)->count();
            
             $most_popular_courses = Student::select('courses.name_ar','courses.name_en','courses.code',\DB::raw('count(student_training_registered.training_id) as tr_count'))
                        ->join('trainings','trainings.id','student_training_registered.training_id')
                        ->join('trainings_courses','trainings_courses.training_id','trainings.id')
                        ->join('courses','courses.id','trainings_courses.course_id')
                        ->whereIn('trainings.id',$training_ids)
                        ->groupBy('student_training_registered.training_id','student_training_registered.training_id')
                        ->orderBy('tr_count','DESC')
                        ->limit(8)
                        ->get();
    
            $course_ids = TrainingCourse::whereIn('training_id', $training_ids)->pluck('course_id')->toArray();
            $courses = Course::whereIn('id', $course_ids)->count();
            
            $instructor_ids = Instructor::where('center_id', $centerId)->pluck('user_id')->toArray();
            $instructors = User::where('type','instructor')->whereIn('id', $instructor_ids)->count();
            
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            $students = User::where('type','student')->whereIn('id', $student_ids)->count();
            
            $student_user_ids = User::where('type','student')->whereIn('id', $student_ids)->pluck('id')->toArray();
            $students_info_ids = StudentInfo::whereIn('user_id',$student_user_ids)->pluck('id')->toArray();
            $students_regions_ids = StudentAddress::whereIn('student_id',$students_info_ids)->distinct('region_id')->pluck('region_id')->toArray();
            $students_regions = Region::whereIn('id',$students_regions_ids)->count();
        
        } 
        else if(isset($_POST['dateFrom']) && empty($_POST['dateTo'])){
            $centers = Center::where('created_at','>=', $from)->count();
            if($centerId=='all'){
                $center = null;
                $halls = CenterHall::where('created_at','>=', $from)->count();
                
                $center_regions_ids = CenterHall::where('created_at','>=', $from)->distinct('region_id')->pluck('region_id')->toArray();
                $center_regions = Region::whereIn('id',$center_regions_ids)->count();
                
                $trainings = Training::where('created_at','>=', $from)->count();
                $courses = Course::where('created_at','>=', $from)->count();
                $instructors = User::where('created_at','>=', $from)->where('type','instructor')->count();
                $students = User::where('created_at','>=', $from)->where('type','student')->count();
                
                $student_user_ids = User::where('created_at','>=', $from)->where('type','student')->pluck('id')->toArray();
                $students_ids = StudentInfo::whereIn('user_id', $student_user_ids)->pluck('id')->toArray();
                $students_regions_ids = StudentAddress::whereIn('student_id',$students_ids)->distinct('region_id')->pluck('region_id')->toArray();
                $students_regions = Region::whereIn('id',$students_regions_ids)->count();
                
                $most_popular_courses = Student::select('courses.name_ar','courses.name_en','courses.code',\DB::raw('count(student_training_registered.training_id) as tr_count'))
                        ->join('trainings','trainings.id','student_training_registered.training_id')
                        ->join('trainings_courses','trainings_courses.training_id','trainings.id')
                        ->join('courses','courses.id','trainings_courses.course_id')
                        ->whereBetween('student_training_registered.created_at', [$from, $to])
                        ->groupBy('student_training_registered.training_id','student_training_registered.training_id')
                        ->orderBy('tr_count','DESC')
                        ->limit(8)
                        ->get();
                
                return response()->json([
                    'html' => view('admin.reports.centerReports.centerReportStatistics', compact('centerId','most_popular_courses','center_regions','students_regions','centers','halls','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }
            
            $center = Center::findOrFail($centerId);
            $halls = CenterHall::where('created_at','>=', $from)->where('center_id', $centerId)->count();
            
            $center_regions_ids = CenterHall::where('created_at','>=', $from)->where('center_id', $centerId)->distinct('region_id')->pluck('region_id')->toArray();
            $center_regions = Region::whereIn('id',$center_regions_ids)->count();
            
            $training_ids = TrainingSchadual::where('center_id', $centerId)->pluck('training_id')->toArray();
            $trainings = Training::where('created_at','>=', $from)->whereIn('id', $training_ids)->count();
            
             $most_popular_courses = Student::select('courses.name_ar','courses.name_en','courses.code',\DB::raw('count(student_training_registered.training_id) as tr_count'))
                        ->join('trainings','trainings.id','student_training_registered.training_id')
                        ->join('trainings_courses','trainings_courses.training_id','trainings.id')
                        ->join('courses','courses.id','trainings_courses.course_id')
                        ->where('student_training_registered.created_at','>=', $from)
                        ->whereIn('trainings.id',$training_ids)
                        ->groupBy('student_training_registered.training_id','student_training_registered.training_id')
                        ->orderBy('tr_count','DESC')
                        ->limit(8)
                        ->get();
    
            $course_ids = TrainingCourse::whereIn('training_id', $training_ids)->pluck('course_id')->toArray();
            $courses = Course::where('created_at','>=', $from)->whereIn('id', $course_ids)->count();
            
            $instructor_ids = Instructor::where('center_id', $centerId)->pluck('user_id')->toArray();
            $instructors = User::where('created_at','>=', $from)->where('type','instructor')->whereIn('id', $instructor_ids)->count();
            
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            $students = User::where('created_at','>=', $from)->where('type','student')->whereIn('id', $student_ids)->count();
            
            $student_user_ids = User::where('created_at','>=', $from)->where('type','student')->whereIn('id', $student_ids)->pluck('id')->toArray();
            $students_info_ids = StudentInfo::whereIn('user_id',$student_user_ids)->pluck('id')->toArray();
            $students_regions_ids = StudentAddress::whereIn('student_id',$students_info_ids)->distinct('region_id')->pluck('region_id')->toArray();
            $students_regions = Region::whereIn('id',$students_regions_ids)->count();
        }
        else if(empty($_POST['dateFrom']) && isset($_POST['dateTo'])){
            $centers = Center::where('created_at','<=', $to)->count();
            if($centerId=='all'){
                $center = null;
                $halls = CenterHall::where('created_at','<=', $to)->count();
                
                $center_regions_ids = CenterHall::where('created_at','<=', $to)->distinct('region_id')->pluck('region_id')->toArray();
                $center_regions = Region::whereIn('id',$center_regions_ids)->count();
                
                $trainings = Training::where('created_at','<=', $to)->count();
                $courses = Course::where('created_at','<=', $to)->count();
                $instructors = User::where('created_at','<=', $to)->where('type','instructor')->count();
                $students = User::where('created_at','<=', $to)->where('type','student')->count();
                
                $student_user_ids = User::where('created_at','<=', $to)->where('type','student')->pluck('id')->toArray();
                $students_ids = StudentInfo::whereIn('user_id', $student_user_ids)->pluck('id')->toArray();
                $students_regions_ids = StudentAddress::whereIn('student_id',$students_ids)->distinct('region_id')->pluck('region_id')->toArray();
                $students_regions = Region::whereIn('id',$students_regions_ids)->count();
                
                $most_popular_courses = Student::select('courses.name_ar','courses.name_en','courses.code',\DB::raw('count(student_training_registered.training_id) as tr_count'))
                        ->join('trainings','trainings.id','student_training_registered.training_id')
                        ->join('trainings_courses','trainings_courses.training_id','trainings.id')
                        ->join('courses','courses.id','trainings_courses.course_id')
                        ->whereBetween('student_training_registered.created_at', [$from, $to])
                        ->groupBy('student_training_registered.training_id','student_training_registered.training_id')
                        ->orderBy('tr_count','DESC')
                        ->limit(8)
                        ->get();
                
                return response()->json([
                    'html' => view('admin.reports.centerReports.centerReportStatistics', compact('centerId','most_popular_courses','center_regions','students_regions','centers','halls','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }
            
            $center = Center::findOrFail($centerId);
            $halls = CenterHall::where('created_at','<=', $to)->where('center_id', $centerId)->count();
            
            $center_regions_ids = CenterHall::where('created_at','<=', $to)->where('center_id', $centerId)->distinct('region_id')->pluck('region_id')->toArray();
            $center_regions = Region::whereIn('id',$center_regions_ids)->count();
            
            $training_ids = TrainingSchadual::where('center_id', $centerId)->pluck('training_id')->toArray();
            $trainings = Training::where('created_at','<=', $to)->whereIn('id', $training_ids)->count();
            
             $most_popular_courses = Student::select('courses.name_ar','courses.name_en','courses.code',\DB::raw('count(student_training_registered.training_id) as tr_count'))
                        ->join('trainings','trainings.id','student_training_registered.training_id')
                        ->join('trainings_courses','trainings_courses.training_id','trainings.id')
                        ->join('courses','courses.id','trainings_courses.course_id')
                        ->whereBetween('student_training_registered.created_at','<=', $to)
                        ->whereIn('trainings.id',$training_ids)
                        ->groupBy('student_training_registered.training_id','student_training_registered.training_id')
                        ->orderBy('tr_count','DESC')
                        ->limit(8)
                        ->get();
    
            $course_ids = TrainingCourse::whereIn('training_id', $training_ids)->pluck('course_id')->toArray();
            $courses = Course::where('created_at','<=', $to)->whereIn('id', $course_ids)->count();
            
            $instructor_ids = Instructor::where('center_id', $centerId)->pluck('user_id')->toArray();
            $instructors = User::where('created_at','<=', $to)->where('type','instructor')->whereIn('id', $instructor_ids)->count();
            
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            $students = User::where('created_at','<=', $to)->where('type','student')->whereIn('id', $student_ids)->count();
            
            $student_user_ids = User::where('created_at','<=', $to)->where('type','student')->whereIn('id', $student_ids)->pluck('id')->toArray();
            $students_info_ids = StudentInfo::whereIn('user_id',$student_user_ids)->pluck('id')->toArray();
            $students_regions_ids = StudentAddress::whereIn('student_id',$students_info_ids)->distinct('region_id')->pluck('region_id')->toArray();
            $students_regions = Region::whereIn('id',$students_regions_ids)->count();
        }
        else {
            $centers = Center::whereBetween('created_at', [$from, $to])->count();
            if($centerId=='all'){
                $center = null;
                $halls = CenterHall::whereBetween('created_at', [$from, $to])->count();
                
                $center_regions_ids = CenterHall::whereBetween('created_at', [$from, $to])->distinct('region_id')->pluck('region_id')->toArray();
                $center_regions = Region::whereIn('id',$center_regions_ids)->count();
                
                $trainings = Training::whereBetween('created_at', [$from, $to])->count();
                $courses = Course::whereBetween('created_at', [$from, $to])->count();
                $instructors = User::whereBetween('created_at', [$from, $to])->where('type','instructor')->count();
                $students = User::whereBetween('created_at', [$from, $to])->where('type','student')->count();
                
                $student_user_ids = User::whereBetween('created_at', [$from, $to])->where('type','student')->pluck('id')->toArray();
                $students_ids = StudentInfo::whereIn('user_id', $student_user_ids)->pluck('id')->toArray();
                $students_regions_ids = StudentAddress::whereIn('student_id',$students_ids)->distinct('region_id')->pluck('region_id')->toArray();
                $students_regions = Region::whereIn('id',$students_regions_ids)->count();
                
                $most_popular_courses = Student::select('courses.name_ar','courses.name_en','courses.code',\DB::raw('count(student_training_registered.training_id) as tr_count'))
                        ->join('trainings','trainings.id','student_training_registered.training_id')
                        ->join('trainings_courses','trainings_courses.training_id','trainings.id')
                        ->join('courses','courses.id','trainings_courses.course_id')
                        ->whereBetween('student_training_registered.created_at', [$from, $to])
                        ->groupBy('student_training_registered.training_id','student_training_registered.training_id')
                        ->orderBy('tr_count','DESC')
                        ->limit(8)
                        ->get();
                
                return response()->json([
                    'html' => view('admin.reports.centerReports.centerReportStatistics', compact('centerId','most_popular_courses','center_regions','students_regions','centers','halls','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }
            
            $center = Center::findOrFail($centerId);
            $halls = CenterHall::whereBetween('created_at', [$from, $to])->where('center_id', $centerId)->count();
            
            $center_regions_ids = CenterHall::whereBetween('created_at', [$from, $to])->where('center_id', $centerId)->distinct('region_id')->pluck('region_id')->toArray();
            $center_regions = Region::whereIn('id',$center_regions_ids)->count();
            
            $training_ids = TrainingSchadual::where('center_id', $centerId)->pluck('training_id')->toArray();
            $trainings = Training::whereBetween('created_at', [$from, $to])->whereIn('id', $training_ids)->count();
            
             $most_popular_courses = Student::select('courses.name_ar','courses.name_en','courses.code',\DB::raw('count(student_training_registered.training_id) as tr_count'))
                        ->join('trainings','trainings.id','student_training_registered.training_id')
                        ->join('trainings_courses','trainings_courses.training_id','trainings.id')
                        ->join('courses','courses.id','trainings_courses.course_id')
                        ->whereBetween('student_training_registered.created_at', [$from, $to])
                        ->whereIn('trainings.id',$training_ids)
                        ->groupBy('student_training_registered.training_id','student_training_registered.training_id')
                        ->orderBy('tr_count','DESC')
                        ->limit(8)
                        ->get();
    
            $course_ids = TrainingCourse::whereIn('training_id', $training_ids)->pluck('course_id')->toArray();
            $courses = Course::whereBetween('created_at', [$from, $to])->whereIn('id', $course_ids)->count();
            
            $instructor_ids = Instructor::where('center_id', $centerId)->pluck('user_id')->toArray();
            $instructors = User::whereBetween('created_at', [$from, $to])->where('type','instructor')->whereIn('id', $instructor_ids)->count();
            
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            $students = User::whereBetween('created_at', [$from, $to])->where('type','student')->whereIn('id', $student_ids)->count();
            
            $student_user_ids = User::whereBetween('created_at', [$from, $to])->where('type','student')->whereIn('id', $student_ids)->pluck('id')->toArray();
            $students_info_ids = StudentInfo::whereIn('user_id',$student_user_ids)->pluck('id')->toArray();
            $students_regions_ids = StudentAddress::whereIn('student_id',$students_info_ids)->distinct('region_id')->pluck('region_id')->toArray();
            $students_regions = Region::whereIn('id',$students_regions_ids)->count();
        }
        
        return response()->json([
            'html' => view('admin.reports.centerReports.centerReportStatistics', compact('centerId','most_popular_courses','center_regions','students_regions','center','centers','halls','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
        ]);
        
    }
    public function centerReportResult(){
        
        $centerId=$_POST['centerId'];
        $filter=$_POST['filter'];
        $dateFrom=$_POST['dateFrom'];
        $dateTo=$_POST['dateTo'];
        $from=date('Y-m-d H:i:s', strtotime($dateFrom." -1 days"));
        $to=date('Y-m-d H:i:s', strtotime($dateTo." +1 days"));
        
        $halls = null;
        $center_regions = null;
        $trainings = null;
        $courses = null;
        $students = null;
        $students_regions = null;
        $instructors = null;
        $centers = null;
        $center = null;
        if(empty($_POST['dateFrom']) && empty($_POST['dateTo'])) {
            if($centerId=='all'){
                if($filter == 'centers') {
                    $centers=Center::get();
                }
                if($filter == 'halls') {
                    $halls = CenterHall::get();
                }
                if($filter == 'center_regions') {
                    $center_regions_ids = CenterHall::distinct('region_id')->pluck('region_id')->toArray();
                    $center_regions = Region::whereIn('id',$center_regions_ids)->get();
                }
                if($filter == 'trainings') {
                    $trainings = Training::get();
                }
                if($filter == 'courses') {
                    $courses = Course::get();
                }
                if($filter == 'instructors') {
                    $instructors = User::where('type','instructor')->get();
                }
                if($filter == 'students') {
                    $students = User::where('type','student')->get();
                }
                if($filter == 'students_regions') {
                    $student_user_ids = User::where('type','student')->pluck('id')->toArray();
                    $students_ids = StudentInfo::whereIn('user_id', $student_user_ids)->pluck('id')->toArray();
                    $students_regions_ids = StudentAddress::whereIn('student_id',$students_ids)->distinct('region_id')->pluck('region_id')->toArray();
                    $students_regions = Region::whereIn('id',$students_regions_ids)->get();
                }
                return response()->json([
                    'html' => view('admin.reports.centerReports.CenterReportResult', compact('center','centers','students_regions','center_regions','halls','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }
            
            $center = Center::findOrFail($centerId);
            $training_ids = TrainingSchadual::where('center_id', $centerId)->pluck('training_id')->toArray();
            $course_ids = TrainingCourse::whereIn('training_id', $training_ids)->pluck('course_id')->toArray();
            $instructor_ids = Instructor::where('center_id', $centerId)->pluck('user_id')->toArray();
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            
    
            if($filter == 'halls') {
                $halls = CenterHall::where('center_id', $centerId)->get();
            }
            
            if($filter == 'center_regions') {
                $center_regions_ids = CenterHall::where('center_id', $centerId)->distinct('region_id')->pluck('region_id')->toArray();
                $center_regions = Region::whereIn('id',$center_regions_ids)->get();
            }
            
            if($filter == 'trainings') {
                $trainings = Training::whereIn('id', $training_ids)->get();
            }
            
            if($filter == 'instructors') {
                $instructors = User::where('type','instructor')->whereIn('id', $instructor_ids)->get();
            }
            
            if($filter == 'courses') {
                $courses = Course::whereIn('id', $course_ids)->get();
            }
            
            if($filter == 'students') {
                $students = User::where('type','student')->whereIn('id', $student_ids)->get();
            }
            
            if($filter == 'students_regions') {
                $student_user_ids = User::where('type','student')->whereIn('id', $student_ids)->pluck('id')->toArray();
                $students_info_ids = StudentInfo::whereIn('user_id',$student_user_ids)->pluck('id')->toArray();
                $students_regions_ids = StudentAddress::whereIn('student_id',$students_info_ids)->distinct('region_id')->pluck('region_id')->toArray();
                $students_regions = Region::whereIn('id',$students_regions_ids)->get();
            }
        } 
        else if(empty($_POST['dateTo']) && isset($_POST['dateFrom'])) {
            if($centerId=='all'){
                if($filter == 'centers') {
                    $centers=Center::where('created_at','>=', $from)->get();
                }
                if($filter == 'halls') {
                    $halls = CenterHall::where('created_at','>=', $from)->get();
                }
                if($filter == 'center_regions') {
                    $center_regions_ids = CenterHall::where('created_at','>=', $from)->distinct('region_id')->pluck('region_id')->toArray();
                    $center_regions = Region::whereIn('id',$center_regions_ids)->get();
                }
                if($filter == 'trainings') {
                    $trainings = Training::where('created_at','>=', $from)->get();
                }
                if($filter == 'courses') {
                    $courses = Course::where('created_at','>=', $from)->get();
                }
                if($filter == 'instructors') {
                    $instructors = User::where('created_at','>=', $from)->where('type','instructor')->get();
                }
                if($filter == 'students') {
                    $students = User::where('created_at','>=', $from)->where('type','student')->get();
                }
                if($filter == 'students_regions') {
                    $student_user_ids = User::where('created_at','>=', $from)->where('type','student')->pluck('id')->toArray();
                    $students_ids = StudentInfo::whereIn('user_id', $student_user_ids)->pluck('id')->toArray();
                    $students_regions_ids = StudentAddress::whereIn('student_id',$students_ids)->distinct('region_id')->pluck('region_id')->toArray();
                    $students_regions = Region::whereIn('id',$students_regions_ids)->get();
                }
                return response()->json([
                    'html' => view('admin.reports.centerReports.CenterReportResult', compact('center','centers','students_regions','center_regions','halls','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }
            
            $center = Center::findOrFail($centerId);
            $training_ids = TrainingSchadual::where('center_id', $centerId)->pluck('training_id')->toArray();
            $course_ids = TrainingCourse::whereIn('training_id', $training_ids)->pluck('course_id')->toArray();
            $instructor_ids = Instructor::where('center_id', $centerId)->pluck('user_id')->toArray();
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            
    
            if($filter == 'halls') {
                $halls = CenterHall::where('created_at','>=', $from)->where('center_id', $centerId)->get();
            }
            
            if($filter == 'center_regions') {
                $center_regions_ids = CenterHall::where('created_at','>=', $from)->where('center_id', $centerId)->distinct('region_id')->pluck('region_id')->toArray();
                $center_regions = Region::whereIn('id',$center_regions_ids)->get();
            }
            
            if($filter == 'trainings') {
                $trainings = Training::where('created_at','>=', $from)->whereIn('id', $training_ids)->get();
            }
            
            if($filter == 'instructors') {
                $instructors = User::where('created_at','>=', $from)->where('type','instructor')->whereIn('id', $instructor_ids)->get();
            }
            
            if($filter == 'courses') {
                $courses = Course::where('created_at','>=', $from)->whereIn('id', $course_ids)->get();
            }
            
            if($filter == 'students') {
                $students = User::where('created_at','>=', $from)->where('type','student')->whereIn('id', $student_ids)->get();
            }
            
            if($filter == 'students_regions') {
                $student_user_ids = User::where('created_at','>=', $from)->where('type','student')->whereIn('id', $student_ids)->pluck('id')->toArray();
                $students_info_ids = StudentInfo::whereIn('user_id',$student_user_ids)->pluck('id')->toArray();
                $students_regions_ids = StudentAddress::whereIn('student_id',$students_info_ids)->distinct('region_id')->pluck('region_id')->toArray();
                $students_regions = Region::whereIn('id',$students_regions_ids)->get();
            }
        } 
        else if(empty($_POST['dateFrom']) && isset($_POST['dateTo'])) {
            if($centerId=='all'){
                if($filter == 'centers') {
                    $centers=Center::where('created_at','<=', $to)->get();
                }
                if($filter == 'halls') {
                    $halls = CenterHall::where('created_at','<=', $to)->get();
                }
                if($filter == 'center_regions') {
                    $center_regions_ids = CenterHall::where('created_at','<=', $to)->distinct('region_id')->pluck('region_id')->toArray();
                    $center_regions = Region::whereIn('id',$center_regions_ids)->get();
                }
                if($filter == 'trainings') {
                    $trainings = Training::where('created_at','<=', $to)->get();
                }
                if($filter == 'courses') {
                    $courses = Course::where('created_at','<=', $to)->get();
                }
                if($filter == 'instructors') {
                    $instructors = User::where('created_at','<=', $to)->where('type','instructor')->get();
                }
                if($filter == 'students') {
                    $students = User::where('created_at','<=', $to)->where('type','student')->get();
                }
                if($filter == 'students_regions') {
                    $student_user_ids = User::where('created_at','<=', $to)->where('type','student')->pluck('id')->toArray();
                    $students_ids = StudentInfo::whereIn('user_id', $student_user_ids)->pluck('id')->toArray();
                    $students_regions_ids = StudentAddress::whereIn('student_id',$students_ids)->distinct('region_id')->pluck('region_id')->toArray();
                    $students_regions = Region::whereIn('id',$students_regions_ids)->get();
                }
                return response()->json([
                    'html' => view('admin.reports.centerReports.CenterReportResult', compact('center','centers','students_regions','center_regions','halls','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }
            
            $center = Center::findOrFail($centerId);
            $training_ids = TrainingSchadual::where('center_id', $centerId)->pluck('training_id')->toArray();
            $course_ids = TrainingCourse::whereIn('training_id', $training_ids)->pluck('course_id')->toArray();
            $instructor_ids = Instructor::where('center_id', $centerId)->pluck('user_id')->toArray();
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            
    
            if($filter == 'halls') {
                $halls = CenterHall::where('created_at','<=', $to)->where('center_id', $centerId)->get();
            }
            
            if($filter == 'center_regions') {
                $center_regions_ids = CenterHall::where('created_at','<=', $to)->where('center_id', $centerId)->distinct('region_id')->pluck('region_id')->toArray();
                $center_regions = Region::whereIn('id',$center_regions_ids)->get();
            }
            
            if($filter == 'trainings') {
                $trainings = Training::where('created_at','<=', $to)->whereIn('id', $training_ids)->get();
            }
            
            if($filter == 'instructors') {
                $instructors = User::where('created_at','<=', $to)->where('type','instructor')->whereIn('id', $instructor_ids)->get();
            }
            
            if($filter == 'courses') {
                $courses = Course::where('created_at','<=', $to)->whereIn('id', $course_ids)->get();
            }
            
            if($filter == 'students') {
                $students = User::where('created_at','<=', $to)->where('type','student')->whereIn('id', $student_ids)->get();
            }
            
            if($filter == 'students_regions') {
                $student_user_ids = User::where('created_at','<=', $to)->where('type','student')->whereIn('id', $student_ids)->pluck('id')->toArray();
                $students_info_ids = StudentInfo::whereIn('user_id',$student_user_ids)->pluck('id')->toArray();
                $students_regions_ids = StudentAddress::whereIn('student_id',$students_info_ids)->distinct('region_id')->pluck('region_id')->toArray();
                $students_regions = Region::whereIn('id',$students_regions_ids)->get();
            }
        } 
        else {
            if($centerId=='all'){
                if($filter == 'centers') {
                    $centers=Center::whereBetween('created_at', [$from, $to])->get();
                }
                if($filter == 'halls') {
                    $halls = CenterHall::whereBetween('created_at', [$from, $to])->get();
                }
                if($filter == 'center_regions') {
                    $center_regions_ids = CenterHall::whereBetween('created_at', [$from, $to])->distinct('region_id')->pluck('region_id')->toArray();
                    $center_regions = Region::whereIn('id',$center_regions_ids)->get();
                }
                if($filter == 'trainings') {
                    $trainings = Training::whereBetween('created_at', [$from, $to])->get();
                }
                if($filter == 'courses') {
                    $courses = Course::whereBetween('created_at', [$from, $to])->get();
                }
                if($filter == 'instructors') {
                    $instructors = User::whereBetween('created_at', [$from, $to])->where('type','instructor')->get();
                }
                if($filter == 'students') {
                    $students = User::whereBetween('created_at', [$from, $to])->where('type','student')->get();
                }
                if($filter == 'students_regions') {
                    $student_user_ids = User::whereBetween('created_at', [$from, $to])->where('type','student')->pluck('id')->toArray();
                    $students_ids = StudentInfo::whereIn('user_id', $student_user_ids)->pluck('id')->toArray();
                    $students_regions_ids = StudentAddress::whereIn('student_id',$students_ids)->distinct('region_id')->pluck('region_id')->toArray();
                    $students_regions = Region::whereIn('id',$students_regions_ids)->get();
                }
                return response()->json([
                    'html' => view('admin.reports.centerReports.CenterReportResult', compact('center','centers','students_regions','center_regions','halls','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }
            
            $center = Center::findOrFail($centerId);
            $training_ids = TrainingSchadual::where('center_id', $centerId)->pluck('training_id')->toArray();
            $course_ids = TrainingCourse::whereIn('training_id', $training_ids)->pluck('course_id')->toArray();
            $instructor_ids = Instructor::where('center_id', $centerId)->pluck('user_id')->toArray();
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            
    
            if($filter == 'halls') {
                $halls = CenterHall::whereBetween('created_at', [$from, $to])->where('center_id', $centerId)->get();
            }
            
            if($filter == 'center_regions') {
                $center_regions_ids = CenterHall::whereBetween('created_at', [$from, $to])->where('center_id', $centerId)->distinct('region_id')->pluck('region_id')->toArray();
                $center_regions = Region::whereIn('id',$center_regions_ids)->get();
            }
            
            if($filter == 'trainings') {
                $trainings = Training::whereBetween('created_at', [$from, $to])->whereIn('id', $training_ids)->get();
            }
            
            if($filter == 'instructors') {
                $instructors = User::whereBetween('created_at', [$from, $to])->where('type','instructor')->whereIn('id', $instructor_ids)->get();
            }
            
            if($filter == 'courses') {
                $courses = Course::whereBetween('created_at', [$from, $to])->whereIn('id', $course_ids)->get();
            }
            
            if($filter == 'students') {
                $students = User::whereBetween('created_at', [$from, $to])->where('type','student')->whereIn('id', $student_ids)->get();
            }
            
            if($filter == 'students_regions') {
                $student_user_ids = User::whereBetween('created_at', [$from, $to])->where('type','student')->whereIn('id', $student_ids)->pluck('id')->toArray();
                $students_info_ids = StudentInfo::whereIn('user_id',$student_user_ids)->pluck('id')->toArray();
                $students_regions_ids = StudentAddress::whereIn('student_id',$students_info_ids)->distinct('region_id')->pluck('region_id')->toArray();
                $students_regions = Region::whereIn('id',$students_regions_ids)->get();
            }
        }
        
        return response()->json([
            'html' => view('admin.reports.centerReports.CenterReportResult', compact('center','centers','students_regions','center_regions','halls','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
        ]);
        
    }


    ///////////////////// function return view of training report ///////////////////////////////
    public function courseReportView(){
        $courses = Course::where('status',1)->get();

        return view('admin.reports.courseReports.CourseReport',compact('courses'));
    }
    
    ///////////// function return result using ajax generate training report////////////////////
    public function courseReportStatistics(){
        
        $courseId=$_POST['courseId'];
        $dateFrom=$_POST['dateFrom'];
        $dateTo=$_POST['dateTo'];
        $from=date('Y-m-d H:i:s', strtotime($dateFrom." -1 days"));
        $to=date('Y-m-d H:i:s', strtotime($dateTo." +1 days"));
        
        if(empty($_POST['dateFrom']) && empty($_POST['dateTo'])) {
            $courses = Course::count();
            if($courseId=='all'){
                $center = null;
                $centers = Center::count();
                $trainings = Training::count();
                $instructors = User::where('type','instructor')->count();
                $students = User::where('type','student')->count();
                return response()->json([
                    'html' => view('admin.reports.courseReports.courseReportStatistics', compact('courseId','centers','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }
            
            $course = Course::findOrFail($courseId);
            
            $training_ids = TrainingCourse::where('course_id', $courseId)->pluck('training_id')->toArray();
            $trainings = Training::whereIn('id', $training_ids)->count();
            
            $center_ids = TrainingSchadual::whereIn('training_id', $training_ids)->pluck('center_id')->toArray();
            $centers = Center::whereIn('id', $center_ids)->count();
            
            $instructor_ids = Instructor::whereIn('center_id', $center_ids)->pluck('user_id')->toArray();
            $instructors = User::where('type','instructor')->whereIn('id', $instructor_ids)->count();
            
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            $students = User::where('type','student')->whereIn('id', $student_ids)->count();
        }
        if(isset($_POST['dateFrom']) && empty($_POST['dateTo'])) {
            $courses = Course::where('created_at','>=', $from)->count();
            if($courseId=='all'){
                $center = null;
                $centers = Center::where('created_at','>=', $from)->count();
                $trainings = Training::where('created_at','>=', $from)->count();
                $instructors = User::where('created_at','>=', $from)->where('type','instructor')->count();
                $students = User::where('created_at','>=', $from)->where('type','student')->count();
                return response()->json([
                    'html' => view('admin.reports.courseReports.courseReportStatistics', compact('courseId','centers','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }
            
            $course = Course::findOrFail($courseId);
            
            $training_ids = TrainingCourse::where('course_id', $courseId)->pluck('training_id')->toArray();
            $trainings = Training::where('created_at','>=', $from)->whereIn('id', $training_ids)->count();
            
            $center_ids = TrainingSchadual::whereIn('training_id', $training_ids)->pluck('center_id')->toArray();
            $centers = Center::where('created_at','>=', $from)->whereIn('id', $center_ids)->count();
            
            $instructor_ids = Instructor::whereIn('center_id', $center_ids)->pluck('user_id')->toArray();
            $instructors = User::where('created_at','>=', $from)->where('type','instructor')->whereIn('id', $instructor_ids)->count();
            
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            $students = User::where('created_at','>=', $from)->where('type','student')->whereIn('id', $student_ids)->count();
        }
        if(empty($_POST['dateFrom']) && isset($_POST['dateTo'])) {
            $courses = Course::where('created_at','<=', $to)->count();
            if($courseId=='all'){
                $center = null;
                $centers = Center::where('created_at','<=', $to)->count();
                $trainings = Training::where('created_at','<=', $to)->count();
                $instructors = User::where('created_at','<=', $to)->where('type','instructor')->count();
                $students = User::where('created_at','<=', $to)->where('type','student')->count();
                return response()->json([
                    'html' => view('admin.reports.courseReports.courseReportStatistics', compact('courseId','centers','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }
            
            $course = Course::findOrFail($courseId);
            
            $training_ids = TrainingCourse::where('course_id', $courseId)->pluck('training_id')->toArray();
            $trainings = Training::where('created_at','<=', $to)->whereIn('id', $training_ids)->count();
            
            $center_ids = TrainingSchadual::whereIn('training_id', $training_ids)->pluck('center_id')->toArray();
            $centers = Center::where('created_at','<=', $to)->whereIn('id', $center_ids)->count();
            
            $instructor_ids = Instructor::whereIn('center_id', $center_ids)->pluck('user_id')->toArray();
            $instructors = User::where('created_at','<=', $to)->where('type','instructor')->whereIn('id', $instructor_ids)->count();
            
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            $students = User::where('created_at','<=', $to)->where('type','student')->whereIn('id', $student_ids)->count();
        }
        else {
            $courses = Course::whereBetween('created_at', [$from, $to])->count();
            if($courseId=='all'){
                $center = null;
                $centers = Center::whereBetween('created_at', [$from, $to])->count();
                $trainings = Training::whereBetween('created_at', [$from, $to])->count();
                $instructors = User::whereBetween('created_at', [$from, $to])->where('type','instructor')->count();
                $students = User::whereBetween('created_at', [$from, $to])->where('type','student')->count();
                return response()->json([
                    'html' => view('admin.reports.courseReports.courseReportStatistics', compact('courseId','centers','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }
            
            $course = Course::findOrFail($courseId);
            
            $training_ids = TrainingCourse::where('course_id', $courseId)->pluck('training_id')->toArray();
            $trainings = Training::whereBetween('created_at', [$from, $to])->whereIn('id', $training_ids)->count();
            
            $center_ids = TrainingSchadual::whereIn('training_id', $training_ids)->pluck('center_id')->toArray();
            $centers = Center::whereBetween('created_at', [$from, $to])->whereIn('id', $center_ids)->count();
            
            $instructor_ids = Instructor::whereIn('center_id', $center_ids)->pluck('user_id')->toArray();
            $instructors = User::whereBetween('created_at', [$from, $to])->where('type','instructor')->whereIn('id', $instructor_ids)->count();
            
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            $students = User::whereBetween('created_at', [$from, $to])->where('type','student')->whereIn('id', $student_ids)->count();
        }
        
        return response()->json([
            'html' => view('admin.reports.courseReports.courseReportStatistics', compact('courseId','course','courses','trainings','centers','instructors','students','dateFrom','dateTo'))->render(),
        ]);
    }
    
    public function courseReportResult(){
        
        $courseId=$_POST['courseId'];
        $filter=$_POST['filter'];
        $dateFrom=$_POST['dateFrom'];
        $dateTo=$_POST['dateTo'];
        $from=date('Y-m-d H:i:s', strtotime($dateFrom." -1 days"));
        $to=date('Y-m-d H:i:s', strtotime($dateTo." +1 days"));
        
        $course = null;
        $trainings = null;
        $courses = null;
        $students = null;
        $instructors = null;
        $centers = null;

        if(empty($_POST['dateFrom']) && empty($_POST['dateTo'])) {
            if($courseId=='all'){
                if($filter == 'courses') {
                    $courses = Course::get();
                }
                if($filter == 'centers') {
                    $centers = Center::get();
                }
                if($filter == 'trainings') {
                    $trainings = Training::get();
                }
                if($filter == 'instructors') {
                    $instructors = User::where('type','instructor')->get();
                }
                if($filter == 'students') {
                    $students = User::where('type','student')->get();
                }
                return response()->json([
                    'html' => view('admin.reports.courseReports.courseReportResult', compact('course','centers','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }   
            
            $course = Course::findOrFail($courseId);
        
            $training_ids = TrainingCourse::where('course_id', $courseId)->pluck('training_id')->toArray();
            $center_ids = TrainingSchadual::whereIn('training_id', $training_ids)->pluck('center_id')->toArray();
            $instructor_ids = Instructor::whereIn('center_id', $center_ids)->pluck('user_id')->toArray();
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            
    
            
            if($filter == 'trainings') {
                $trainings = Training::whereIn('id', $training_ids)->get();
            }
            
            if($filter == 'instructors') {
                $instructors = User::where('type','instructor')->whereIn('id', $instructor_ids)->get();
            }
            
            if($filter == 'centers') {
                $centers = Center::whereIn('id', $center_ids)->get();
            }
            
            if($filter == 'students') {
                $students = User::where('type','student')->whereIn('id', $student_ids)->get();
            }
        }
        if(isset($_POST['dateFrom']) && empty($_POST['dateTo'])) {
            if($courseId=='all'){
                if($filter == 'courses') {
                    $courses = Course::where('created_at','>=', $from)->get();
                }
                if($filter == 'centers') {
                    $centers = Center::where('created_at','>=', $from)->get();
                }
                if($filter == 'trainings') {
                    $trainings = Training::where('created_at','>=', $from)->get();
                }
                if($filter == 'instructors') {
                    $instructors = User::where('created_at','>=', $from)->where('type','instructor')->get();
                }
                if($filter == 'students') {
                    $students = User::where('created_at','>=', $from)->where('type','student')->get();
                }
                return response()->json([
                    'html' => view('admin.reports.courseReports.courseReportResult', compact('course','centers','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }   
            
            $course = Course::findOrFail($courseId);
        
            $training_ids = TrainingCourse::where('course_id', $courseId)->pluck('training_id')->toArray();
            $center_ids = TrainingSchadual::whereIn('training_id', $training_ids)->pluck('center_id')->toArray();
            $instructor_ids = Instructor::whereIn('center_id', $center_ids)->pluck('user_id')->toArray();
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            
    
            
            if($filter == 'trainings') {
                $trainings = Training::where('created_at','>=', $from)->whereIn('id', $training_ids)->get();
            }
            
            if($filter == 'instructors') {
                $instructors = User::where('created_at','>=', $from)->where('type','instructor')->whereIn('id', $instructor_ids)->get();
            }
            
            if($filter == 'centers') {
                $centers = Center::where('created_at','>=', $from)->whereIn('id', $center_ids)->get();
            }
            
            if($filter == 'students') {
                $students = User::where('created_at','>=', $from)->where('type','student')->whereIn('id', $student_ids)->get();
            }
        }
        if(empty($_POST['dateFrom']) && isset($_POST['dateTo'])) {
            if($courseId=='all'){
                if($filter == 'courses') {
                    $courses = Course::where('created_at','<=', $to)->get();
                }
                if($filter == 'centers') {
                    $centers = Center::where('created_at','<=', $to)->get();
                }
                if($filter == 'trainings') {
                    $trainings = Training::where('created_at','<=', $to)->get();
                }
                if($filter == 'instructors') {
                    $instructors = User::where('created_at','<=', $to)->where('type','instructor')->get();
                }
                if($filter == 'students') {
                    $students = User::where('created_at','<=', $to)->where('type','student')->get();
                }
                return response()->json([
                    'html' => view('admin.reports.courseReports.courseReportResult', compact('course','centers','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }   
            
            $course = Course::findOrFail($courseId);
        
            $training_ids = TrainingCourse::where('course_id', $courseId)->pluck('training_id')->toArray();
            $center_ids = TrainingSchadual::whereIn('training_id', $training_ids)->pluck('center_id')->toArray();
            $instructor_ids = Instructor::whereIn('center_id', $center_ids)->pluck('user_id')->toArray();
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            
    
            
            if($filter == 'trainings') {
                $trainings = Training::where('created_at','<=', $to)->whereIn('id', $training_ids)->get();
            }
            
            if($filter == 'instructors') {
                $instructors = User::where('created_at','<=', $to)->where('type','instructor')->whereIn('id', $instructor_ids)->get();
            }
            
            if($filter == 'centers') {
                $centers = Center::where('created_at','<=', $to)->whereIn('id', $center_ids)->get();
            }
            
            if($filter == 'students') {
                $students = User::where('created_at','<=', $to)->where('type','student')->whereIn('id', $student_ids)->get();
            }
        }
        else {
            if($courseId=='all'){
                if($filter == 'courses') {
                    $courses = Course::whereBetween('created_at', [$from, $to])->get();
                }
                if($filter == 'centers') {
                    $centers = Center::whereBetween('created_at', [$from, $to])->get();
                }
                if($filter == 'trainings') {
                    $trainings = Training::whereBetween('created_at', [$from, $to])->get();
                }
                if($filter == 'instructors') {
                    $instructors = User::whereBetween('created_at', [$from, $to])->where('type','instructor')->get();
                }
                if($filter == 'students') {
                    $students = User::whereBetween('created_at', [$from, $to])->where('type','student')->get();
                }
                return response()->json([
                    'html' => view('admin.reports.courseReports.courseReportResult', compact('course','centers','trainings','courses','instructors','students','dateFrom','dateTo'))->render(),
                ]);
            }   
            
            $course = Course::findOrFail($courseId);
        
            $training_ids = TrainingCourse::where('course_id', $courseId)->pluck('training_id')->toArray();
            $center_ids = TrainingSchadual::whereIn('training_id', $training_ids)->pluck('center_id')->toArray();
            $instructor_ids = Instructor::whereIn('center_id', $center_ids)->pluck('user_id')->toArray();
            $student_ids = Student::whereIn('training_id', $training_ids)->pluck('user_id')->toArray();
            
    
            
            if($filter == 'trainings') {
                $trainings = Training::whereBetween('created_at', [$from, $to])->whereIn('id', $training_ids)->get();
            }
            
            if($filter == 'instructors') {
                $instructors = User::whereBetween('created_at', [$from, $to])->where('type','instructor')->whereIn('id', $instructor_ids)->get();
            }
            
            if($filter == 'centers') {
                $centers = Center::whereBetween('created_at', [$from, $to])->whereIn('id', $center_ids)->get();
            }
            
            if($filter == 'students') {
                $students = User::whereBetween('created_at', [$from, $to])->where('type','student')->whereIn('id', $student_ids)->get();
            }
        }
        
        return response()->json([
            'html' => view('admin.reports.courseReports.courseReportResult', compact('course','courses','trainings','centers','instructors','students','dateFrom','dateTo'))->render(),
        ]);
        
    }


    ///////////// function return viewe of Daily Report///////////////////////////////////////

//     public function dailyReportView(){
//         return view('admin.reports.dailyReport.dailyReport');
//     }
    
//     ///////////// function return result ajax dailyReportResult ///////////////////////////////
    
//     public function dailyReportResult(){
//         $date=$_POST['date'];
//         $orders=Order::whereDate('created_at', '=', $date)->get();        
//         return response()->json([
//             'html' => view('admin.reports.dailyReport.dailyReportResult', compact('orders','date'))->render(),
//         ]);
//     }


//     ///////////// function return viewe of monthely Report///////////////////////////////////////

//     public function monthelyReportView(){
//         return view('admin.reports.monthelyReport.monthelyReport');
//     }
    
//     ///////////// function return result ajax monthelyReportResult ///////////////////////////////
    
//     public function monthelyReportResult(){
//         $month = substr($_POST['month'], 5);
//         $year = substr($_POST['month'],0,4);
//         $orders=Order::whereYear('created_at', '=', $year)->whereMonth('created_at', '=', $month)->get();                
//         return response()->json([
//             'html' => view('admin.reports.monthelyReport.monthelyReportResult', compact('orders','month'))->render(),
//         ]);
//     }

//     ///////////// function return viewe of weekly Report///////////////////////////////////////

//     public function weeklyReportView(){
//         return view('admin.reports.weeklyReport.weeklyReport');
//     }
    
//     ///////////// function return result ajax weeklyReportResult ///////////////////////////////
//     public function weeklyReportResult(){
//         $orders = Order::whereBetween('created_at', [Carbon::now()->subWeek()->format("Y-m-d H:i:s"), Carbon::now()])->get();              
//         return response()->json([
//             'html' => view('admin.reports.weeklyReport.weeklyReportResult', compact('orders'))->render(),
//         ]);
//     }

//     ///////////// function return viewe of product Report///////////////////////////////////////
//     public function productReportView(){
//         $products = Product::get();
//         return view('admin.reports.productReport.productReport',compact('products'));
//     }
    
//     ///////////// function return result ajax productReportResult ///////////////////////////////
//     public function productReportResult(){
//         $product_id = $_POST['product_id'];
//         $ordersProduct =OrderProduct::where('product_id',$product_id)->get();
//         return response()->json([
//             'html' => view('admin.reports.productReport.productReportResult', compact('ordersProduct'))->render(),
//         ]);
//     }

//     ///////////// function return viewe of product Report///////////////////////////////////////
//     public function ordersProductsReportView(){
//         return view('admin.reports.orderProductsReport.orderProductsReport');
//     }
    
//     ///////////// function return result ajax productReportResult ///////////////////////////////
//     public function ordersProductsReportResult(){
        
        
//         $dateFrom=$_POST['dateFrom'];
//         $dateTo=$_POST['dateTo'];
//         $from=date('Y-m-d H:i:s', strtotime($dateFrom." -1 days"));
//         $to=date('Y-m-d H:i:s', strtotime($dateTo." +1 days"));
        
//         $ordersProducts =OrderProduct::whereBetween('created_at', [$from, $to])->select('product_id', DB::raw('count(product_id) as productCount'))->groupBy('product_id')->get();
//         return response()->json([
//             'html' => view('admin.reports.orderProductsReport.orderProductsReportResult', compact('ordersProducts','dateFrom','dateTo'))->render(),
//         ]);
//     }
    

    
//     ////////// function return view Generate coupon report /////////////
    
//     public function couponReportView()
//     {
//         $regions=Region::all();
//         return view('admin.reports.generateCouponReport.couponReport',compact('regions'));
//     }
//     ///////// function return result using ajax generate coupon report ///////
    
//     public function couponReport(){
//         $regionId=$_POST['regionId'];
//         $dateFrom=$_POST['dateFrom'];
//         $dateTo=$_POST['dateTo'];
//         $valueUpTo=$_POST['valueUpTo'];
//         $orderUpTo=$_POST['orderUpTo'];
//         $form=date('Y-m-d H:i:s', strtotime($dateFrom));
//         $to=date('Y-m-d H:i:s', strtotime($dateTo));
        
//         if($regionId == '' && $valueUpTo == '' && $orderUpTo == ''){
//             $users=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->select(DB::raw('sum(products_price) as total'),DB::raw('count(*) as Count'),'user_id','region_id','area_id')->groupBy('user_id')->get();
//             $userIds=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->groupBy('user_id')->pluck('user_id')->toArray();
//             session()->put('userIds',$userIds);
            
//             return response()->json([
//             'html' => view('admin.reports.generateCouponReport.couponReportResult', compact('users'))->render(),
//         ]);
//         }

//         if($regionId && $valueUpTo=='' && $orderUpTo==''){
//             $users=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->where('region_id',$regionId)->select(DB::raw('sum(products_price) as total'),DB::raw('count(*) as Count'),'user_id','region_id','area_id')->groupBy('user_id')->get();
//             $userIds=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->where('region_id',$regionId)->groupBy('user_id')->pluck('user_id')->toArray();
//             session()->put('userIds',$userIds);
//             return response()->json([
//             'html' => view('admin.reports.generateCouponReport.couponReportResult', compact('users'))->render(),
//         ]);
//         }
        
//         if($regionId=='' && $valueUpTo && $orderUpTo==''){
//             $users=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->select(DB::raw('sum(products_price) as total'),DB::raw('count(*) as Count'),'user_id','region_id','area_id')->groupBy('user_id')->having('total','>=',$valueUpTo)->get();
//             $userIds=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->select(DB::raw('sum(products_price) as total'),'user_id')->groupBy('user_id')->having('total','>=',$valueUpTo)->pluck('user_id')->toArray();
//             session()->put('userIds',$userIds);
//             return response()->json([
//             'html' => view('admin.reports.generateCouponReport.couponReportResult', compact('users'))->render(),
//         ]);
//         }
        
//         if($regionId=='' && $valueUpTo=='' && $orderUpTo){
//             $users=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->select(DB::raw('sum(products_price) as total'),DB::raw('count(*) as Count'),'user_id','region_id','area_id')->groupBy('user_id')->having('Count','>=',$orderUpTo)->get();
//             $userIds=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->select(DB::raw('count(*) as Count'),'user_id')->groupBy('user_id')->having('Count','>=',$orderUpTo)->pluck('user_id')->toArray();
//             session()->put('userIds',$userIds);
//             return response()->json([
//             'html' => view('admin.reports.generateCouponReport.couponReportResult', compact('users'))->render(),
//         ]);
//         }
        
//         if($regionId && $valueUpTo && $orderUpTo==''){
//             $users=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->where('region_id',$regionId)->select(DB::raw('sum(products_price) as total'),DB::raw('count(*) as Count'),'user_id','region_id','area_id')->groupBy('user_id')->having('total','>=',$valueUpTo)->get();
//             $userIds=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->select(DB::raw('sum(products_price) as total'),'user_id')->where('region_id',$regionId)->groupBy('user_id')->having('total','>=',$valueUpTo)->pluck('user_id')->toArray();
            
//             session()->put('userIds',$userIds);
//             return response()->json([
//             'html' => view('admin.reports.generateCouponReport.couponReportResult', compact('users'))->render(),
//         ]);
//         }
        
//         if($regionId && $valueUpTo=='' && $orderUpTo){
//             $users=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->where('region_id',$regionId)->select(DB::raw('sum(products_price) as total'),DB::raw('count(*) as Count'),'user_id','region_id','area_id')->groupBy('user_id')->having('Count','>=',$orderUpTo)->get();
//             $userIds=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->select(DB::raw('count(*) as Count'),'user_id')->where('region_id',$regionId)->groupBy('user_id')->having('Count','>=',$orderUpTo)->pluck('user_id')->toArray();
//             session()->put('userIds',$userIds);
//             return response()->json([
//             'html' => view('admin.reports.generateCouponReport.couponReportResult', compact('users'))->render(),
//         ]);
//         }
        
//         if($regionId=='' && $valueUpTo && $orderUpTo){
//             $users=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->select(DB::raw('sum(products_price) as total'),DB::raw('count(*) as Count'),'user_id','region_id','area_id')->groupBy('user_id')->having('Count','>=',$orderUpTo)->having('total','>=',$valueUpTo)->get();
//             $userIds=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->select(DB::raw('count(*) as Count'),DB::raw('sum(products_price) as total'),'user_id')->groupBy('user_id')->having('Count','>=',$orderUpTo)->having('total','>=',$valueUpTo)->pluck('user_id')->toArray();
//             session()->put('userIds',$userIds);
//             return response()->json([
//             'html' => view('admin.reports.generateCouponReport.couponReportResult', compact('users'))->render(),
//         ]);
//         }
        
//         if($regionId && $valueUpTo && $orderUpTo){
//             $users=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->where('region_id',$regionId)->select(DB::raw('sum(products_price) as total'),DB::raw('count(*) as Count'),'user_id','region_id','area_id')->groupBy('user_id')->having('Count','>=',$orderUpTo)->having('total','>=',$valueUpTo)->get();
//             $userIds=Order::whereBetween('created_at', [$form, $to])->where('status','Deliverd')->select(DB::raw('count(*) as Count'),DB::raw('sum(products_price) as total'),'user_id')->where('region_id',$regionId)->groupBy('user_id')->having('Count','>=',$orderUpTo)->having('total','>=',$valueUpTo)->pluck('user_id')->toArray();
//             session()->put('userIds',$userIds);
//             return response()->json([
//             'html' => view('admin.reports.generateCouponReport.couponReportResult', compact('users'))->render(),
//         ]);
//         }
//     }
    
//     ////////// function return view user coupon report /////////////
    
//     public function userCouponReportView()
//     {
//         $users=User::all();
//         $coupons=Coupon::all();
//         return view('admin.reports.userCouponReport.userCouponReport',compact('users','coupons'));
//     }
    
//     ///////// function return result using ajax generate user coupon report ///////
//     public function userCouponReport(){
//         $couponId=$_POST['couponId'];
//         $userId=$_POST['userId'];
//         $dateFrom=$_POST['dateFrom'];
//         $dateTo=$_POST['dateTo'];
//         $form=date('Y-m-d H:i:s', strtotime($dateFrom));
//         $to=date('Y-m-d H:i:s', strtotime($dateTo));
        
//         if($couponId=='' && $userId==''){
//             $users=Order::whereBetween('created_at', [$form, $to])->select(DB::raw('sum(products_price) as total'),DB::raw('sum(coupoun_discount) as coupon_discount'),DB::raw('count(coupon_id) as Count'),'user_id','coupon_id')->groupBy('coupon_id')->get();
//             $couponTotalDiscount=[];
//             $couponCount=[];
//             foreach($users as $user){
//                 array_push($couponTotalDiscount,$user->coupon_discount);
//                 array_push($couponCount,$user->Count);
//             }
//             $total=array_sum($couponTotalDiscount);
//             $totalCount=array_sum($couponCount);
//             return response()->json([
//             'html' => view('admin.reports.userCouponReport.ReportResult', compact('users','total','totalCount'))->render(),
//         ]);
//         }
        
//         if($couponId && $userId==''){
//             $users=Order::whereBetween('created_at', [$form, $to])->where('coupon_id',$couponId)->select(DB::raw('sum(products_price) as total'),DB::raw('sum(coupoun_discount) as coupon_discount'),DB::raw('count(coupon_id) as Count'),'user_id','coupon_id')->groupBy('user_id')->get();
//             $couponTotalDiscount=[];
//             $couponCount=[];
//             foreach($users as $user){
//                 array_push($couponTotalDiscount,$user->coupon_discount);
//                 array_push($couponCount,$user->Count);
//             }
//             $total=array_sum($couponTotalDiscount);
//             $totalCount=array_sum($couponCount);
//             return response()->json([
//             'html' => view('admin.reports.userCouponReport.ReportResult', compact('users','total','totalCount'))->render(),
//         ]);
//         }
        
//         if($couponId=='' && $userId){
//             $users=Order::whereBetween('created_at', [$form, $to])->where('user_id',$userId)->select(DB::raw('sum(products_price) as total'),DB::raw('sum(coupoun_discount) as coupon_discount'),DB::raw('count(coupon_id) as Count'),'user_id','coupon_id')->groupBy('coupon_id')->get();
//             $couponTotalDiscount=[];
//             $couponCount=[];
//             foreach($users as $user){
//                 array_push($couponTotalDiscount,$user->coupon_discount);
//                 array_push($couponCount,$user->Count);
//             }
//             $total=array_sum($couponTotalDiscount);
//             $totalCount=array_sum($couponCount);
//             return response()->json([
//             'html' => view('admin.reports.userCouponReport.ReportResult', compact('users','total','totalCount'))->render(),
//         ]);
//         }
        
//         if($couponId && $userId){
//             $users=Order::whereBetween('created_at', [$form, $to])->where('user_id',$userId)->where('coupon_id',$couponId)->select(DB::raw('sum(products_price) as total'),DB::raw('sum(coupoun_discount) as coupon_discount'),DB::raw('count(coupon_id) as Count'),'user_id','coupon_id')->groupBy('coupon_id')->get();
//             $couponTotalDiscount=[];
//             $couponCount=[];
//             foreach($users as $user){
//                 array_push($couponTotalDiscount,$user->coupon_discount);
//                 array_push($couponCount,$user->Count);
//             }
//             $total=array_sum($couponTotalDiscount);
//             $totalCount=array_sum($couponCount);
//             return response()->json([
//             'html' => view('admin.reports.userCouponReport.ReportResult', compact('users','total','totalCount'))->render(),
//         ]);
//         }
//     }
    
//     ////////// function return view user coupon report /////////////
    
//     public function generalCouponReportView()
//     {
//         $coupons=Coupon::all();
//         return view('admin.reports.generalCouponReport.couponReport',compact('coupons'));
//     }
    
//     ///////// function return result using ajax generate user coupon report ///////
//     public function generalCouponReport(){
//         $couponId=$_POST['couponId'];
//         $dateFrom=$_POST['dateFrom'];
//         $dateTo=$_POST['dateTo'];
//         $form=date('Y-m-d H:i:s', strtotime($dateFrom));
//         $to=date('Y-m-d H:i:s', strtotime($dateTo));
        
//         if($couponId){
//             $coupons=Order::whereBetween('created_at', [$form, $to])->where('coupon_id',$couponId)->select(DB::raw('sum(products_price) as total'),DB::raw('sum(coupoun_discount) as coupon_discount'),DB::raw('count(coupon_id) as Count'),'coupon_id')->groupBy('coupon_id')->get();
//             dd($coupons);
//             return response()->json([
//             'html' => view('admin.reports.userCouponReport.ReportResult', compact('coupons'))->render(),
//         ]);
//         }
//     }
// ///////////////////////// function return view acoountig report/////////////////

//     public function accountingReportView(){
//         $paymentMethods=PaymentMethods::where('status',1)->get();
        
//          return view('admin.reports.accountingReport.invoicesReport',compact('paymentMethods'));
//     }
    
//   ///////// function return result using ajax generate  report ///////
//     public function accountingReport(){
//         $status=$_POST['status'];
//         $paymentMethodId=$_POST['paymentMethodId'];
//         $dateFrom=$_POST['dateFrom'];
//         $dateTo=$_POST['dateTo'];
//         $from=date('Y-m-d H:i:s', strtotime($dateFrom." -1 days"));
//         $to=date('Y-m-d H:i:s', strtotime($dateTo." +1 days"));
        
//         if($paymentMethodId=='' && $status==''){
//             $invoices=Invoice::whereBetween('created_at', [$from, $to])->get();
//             return response()->json([
//             'html' => view('admin.reports.accountingReport.ReportResult', compact('invoices','from','to'))->render(),
//         ]);
//         }
        
//         if($paymentMethodId && $status){
//             $invoices=Invoice::whereBetween('created_at', [$from, $to])->where('payment_method_id',$paymentMethodId)->where('status',$status)->get();
//             return response()->json([
//             'html' => view('admin.reports.accountingReport.ReportResult', compact('invoices','from','to'))->render(),
//         ]);
//         }
        
//         if($paymentMethodId=='' && $status){
//             $invoices=Invoice::whereBetween('created_at', [$from, $to])->where('status',$status)->get();
//             return response()->json([
//             'html' => view('admin.reports.accountingReport.ReportResult', compact('invoices','from','to'))->render(),
//         ]);
//         }
        
//         if($paymentMethodId && $status==''){
//             $invoices=Invoice::whereBetween('created_at', [$from, $to])->where('payment_method_id',$paymentMethodId)->get();
//             return response()->json([
//             'html' => view('admin.reports.accountingReport.ReportResult', compact('invoices','from','to'))->render(),
//         ]);
//         }
//     }
//     ////////////// function return view outsourceInvoiceReport////////////////////////
//     public function outsourceInvoiceReport(){
//         $outsources = Outsource::all();
//         return view('admin.reports.outsourceInvoiceReport.outsourceInvoiceReport',compact('outsources'));
//     }
    
//     ///////// function return result using ajax generate  outsourceInvoice report ///////
//     public function outsourceInvoiceReportResult(){
//         $status=$_POST['status'];
//         $outsourceId=$_POST['outsourceId'];
//         $dateFrom=$_POST['dateFrom'];
//         $dateTo=$_POST['dateTo'];
//         $from=date('Y-m-d H:i:s', strtotime($dateFrom." -1 days"));
//         $to=date('Y-m-d H:i:s', strtotime($dateTo." +1 days"));
        
//         if($outsourceId=='' && $status==''){
//             $invoices=OutsourceInvoice::whereBetween('created_at', [$from, $to])->get();
//             $invoiceTotal=OutsourceInvoice::whereBetween('created_at', [$from, $to])->select(DB::raw('sum(our_price) as our_price'),DB::raw('sum(selling_price * quantity) as selling_price'))->get();
//             return response()->json([
//             'html' => view('admin.reports.outsourceInvoiceReport.ReportResult', compact('invoices','invoiceTotal','from','to'))->render(),
//         ]);
//         }
        
//         if($outsourceId && $status){
//             $invoices=OutsourceInvoice::whereBetween('created_at', [$from, $to])->where('outsource_id',$outsourceId)->where('status',$status)->get();
//             $invoiceTotal=OutsourceInvoice::whereBetween('created_at', [$from, $to])->where('outsource_id',$outsourceId)->where('status',$status)->select(DB::raw('sum(our_price) as our_price'),DB::raw('sum(selling_price * quantity) as selling_price'))->get();
//             return response()->json([
//             'html' => view('admin.reports.outsourceInvoiceReport.ReportResult', compact('invoices','invoiceTotal','from','to'))->render(),
//         ]);
//         }
        
//         if($outsourceId=='' && $status){
//             $invoices=OutsourceInvoice::whereBetween('created_at', [$from, $to])->where('status',$status)->get();
//             $invoiceTotal=OutsourceInvoice::whereBetween('created_at', [$from, $to])->where('status',$status)->select(DB::raw('sum(our_price) as our_price'),DB::raw('sum(selling_price * quantity) as selling_price'))->get();
//             return response()->json([
//             'html' => view('admin.reports.outsourceInvoiceReport.ReportResult', compact('invoices','invoiceTotal','from','to'))->render(),
//         ]);
//         }
        
//         if($outsourceId && $status==''){
//             $invoices=OutsourceInvoice::whereBetween('created_at', [$from, $to])->where('outsource_id',$outsourceId)->get();
//             $invoiceTotal=OutsourceInvoice::whereBetween('created_at', [$from, $to])->where('outsource_id',$outsourceId)->select(DB::raw('sum(our_price) as our_price'),DB::raw('sum(selling_price * quantity) as selling_price'))->get();
//             return response()->json([
//             'html' => view('admin.reports.outsourceInvoiceReport.ReportResult', compact('invoices','invoiceTotal','from','to'))->render(),
//         ]);
//         }
//     }
    
}
