<?php

namespace App\Http\Controllers;

use App\Models\PartnerFront;
use DB;
use File;
use Image;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;
use App\Helpers\Helper;


class PartnerFrontController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct(){
        $this->middleware(['permission:partners_front']);
    }

    public function index()
    {
        //
        $partners = PartnerFront::orderBy('id','DESC')->get();
        return view('admin.partners_front.partners',compact('partners'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('admin.partners_front.addPartner');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $add = new PartnerFront();
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->status = $request->status;

        $link_en = str_replace(" ","-",$add->name_en);
        $add->link_en = str_replace(" ","-",$link_en);  
        $link_ar = str_replace(" ","-",$add->name_ar);
        $add->link_ar = str_replace(" ","-",$link_ar); 
        
        $add->meta_title_en = $request->meta_title_en;
        $add->meta_desc_en = $request->meta_desc_en;
        $add->meta_title_ar = $request->meta_title_ar;
        $add->meta_desc_ar = $request->meta_desc_ar;
        $add->meta_robots = $request->meta_robots ; 
        $add->alt_img = $request->alt_img ;
        if($request->image){
            $add->image = Helper::uploadImage('partners_front',$request->image);
        } 
        $add->save();
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return redirect()->route('partners_front.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $partner=PartnerFront::find($id);
        if($partner){
            return view('admin.partners_front.editPartner',compact('partner'));
        }else{
            abort('404');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $add = PartnerFront::find($id);
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;

        $link_en = str_replace(" ","-",$add->name_en);
        $add->link_en = str_replace(" ","-",$link_en);  
        $link_ar = str_replace(" ","-",$add->name_ar);
        $add->link_ar = str_replace(" ","-",$link_ar); 
        
        $add->meta_title_en = $request->meta_title_en;
        $add->meta_desc_en = $request->meta_desc_en;
        $add->meta_title_ar = $request->meta_title_ar;
        $add->meta_desc_ar = $request->meta_desc_ar;
        $add->meta_robots = $request->meta_robots ; 
        $add->status = $request->status ;

        if($add->image && $request->image){
            $add->image = Helper::updateUploadedImage('partners_front',$request->image ,$add->image);
        }elseif($request->image){
            $add->image = Helper::uploadImage('partners_front',$request->image);
        } 
         $add->alt_img = $request->alt_img ;
        
        $add->save();
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return redirect()->route('partners_front.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids){
        $ids = explode(',', $ids);
        $allElements = ($ids[0] == 'on')? true:false;
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }

        $img_path = base_path() . '/uploads/partners_front/';
        if($allElements){
            
            foreach ($ids as $id) {
                $partner = PartnerFront::findOrFail($id);
                if ($partner->image) {
                    (file_exists(sprintf($img_path . '%s', $partner->image)))?unlink(sprintf($img_path . '%s', $partner->image)):'';
                }
            }
            Schema::disableForeignKeyConstraints();
            Brand::truncate();
            
        }else{
        
            foreach ($ids as $id) {
                $partner = PartnerFront::findOrFail($id);
                if ($partner->image) {
                    (file_exists(sprintf($img_path . '%s', $partner->image)))?unlink(sprintf($img_path . '%s', $partner->image)):'';
                }
                $partner->delete();
            }
        }
    }
    
}
