<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\NewsItem;
use App\Models\NewsCategory;
use App\Models\Category;
use DB;
use File;
use Illuminate\Support\Facades\Input;
use Image;
use App\Models\Faq;
use App\Models\Writer;
use App\Helpers\Helper;

class NewsItemController extends Controller
{


    public function __construct()
    {
        $this->middleware('permission:newsItem');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $newsItems = NewsItem::orderBy('id','desc')->get();
        
        return view('admin.newsItems.newsItems',compact('newsItems'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $newsCourseCategories = Category::where('status',1)->get();
        $writers = Writer::where('status',1)->get();
        $newsCategories = NewsCategory::where('status',1)->get();
        return view('admin.newsItems.addNewsItem',compact('newsCategories','newsCourseCategories','writers'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        $newsitem = new NewsItem();
        $newsitem->name_en = $request->name_en;
        $newsitem->name_ar = $request->name_ar;
        $newsitem->newscategory_id  = $request->newscategory_id ;
        // $newsitem->course_category_id  = $request->course_category_id ;
        $newsitem->link_en = str_replace(" ","-",$request->link_en);
        $newsitem->link_ar = str_replace(" ","-",$request->link_ar);
        $newsitem->date = $request->date;
        $newsitem->redirect_url = $request->redirect_url;
        $newsitem->alt_img = $request->alt_img;
        $newsitem->writer_id = $request->writer_id;
        $newsitem->text_source_en = $request->text_source_en;
        $newsitem->text_source_ar = $request->text_source_ar;
        $newsitem->status = $request->status;
        $newsitem->home = $request->home;
        $newsitem->text_en = $request->text_en;
        $newsitem->text_ar = $request->text_ar;
        $newsitem->meta_title_en = $request->meta_title_en;
        $newsitem->meta_title_ar = $request->meta_title_ar;
        $newsitem->meta_desc_en =$request->meta_desc_en;
        $newsitem->meta_desc_ar =$request->meta_desc_ar;
        $newsitem->meta_robots =$request->meta_robots;
        if($request->image){
            $newsitem->image = Helper::uploadImage('newsitems',$request->image);
        } 
        $newsitem->save();
        
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return redirect()->route('news-items.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $newsCourseCategories = Category::where('status',1)->get();
        $newsItem = NewsItem::find($id);
        if($newsItem){
            $newsCategories = NewsCategory::where('status',1)->get();
            $questions = Faq::where('type','news_item')->where('news_item_id',$id)->get();
            $writers = Writer::get();
            return view('admin.newsItems.editNewsItem',compact('newsCategories','newsCourseCategories','newsItem','questions','writers'));
        }else{
            abort('404');
        }
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $newsitem = NewsItem::find($id);
        $newsitem->name_en = $request->name_en;
        $newsitem->name_ar = $request->name_ar;
        $newsitem->newscategory_id = $request->newscategory_id;
        // $newsitem->course_category_id = $request->course_category_id;
        $newsitem->link_en = str_replace(" ","-",$request->link_en);
        $newsitem->link_ar = str_replace(" ","-",$request->link_ar);
        $newsitem->date = $request->date;
        $newsitem->alt_img = $request->alt_img;
        $newsitem->writer_id = $request->writer_id;
        $newsitem->status = $request->status;
        $newsitem->redirect_url = $request->redirect_url;
        $newsitem->home = $request->home;
        $newsitem->text_en = $request->text_en;
        $newsitem->text_ar = $request->text_ar;
        $newsitem->text_source_en = $request->text_source_en;
        $newsitem->text_source_ar = $request->text_source_ar;
        $newsitem->meta_title_en = $request->meta_title_en;
        $newsitem->meta_title_ar = $request->meta_title_ar;
        $newsitem->meta_desc_en =$request->meta_desc_en;
        $newsitem->meta_desc_ar =$request->meta_desc_ar;
        $newsitem->meta_robots =$request->meta_robots;
        if($newsitem->image && $request->image){
            $newsitem->image = Helper::updateUploadedImage('newsitems',$request->image ,$newsitem->image);
        }elseif($request->image){
            $newsitem->image = Helper::uploadImage('newsitems',$request->image);
        } 
        $newsitem->save();
        
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return redirect()->route('news-items.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids){
        $ids = explode(',', $ids);
        $allElements = ($ids[0] == 'on')? true:false;
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }

        $img_path = base_path() . '/uploads/newsitems/';
        if($allElements){
            foreach ($ids as $id) {
                $newsitem = NewsItem::findOrFail($id);
                Faq::where('type','news_item')->where('news_item_id',$id)->delete();
                
                if ($newsitem->image) {
                    (file_exists(sprintf($img_path . '%s', $newsitem->image)))?unlink(sprintf($img_path . '%s', $newsitem->image)):'';
                }
            }
            NewsItem::truncate();
            
        }else{
        
            foreach ($ids as $id) {
                $newsitem = NewsItem::findOrFail($id);
                Faq::where('type','news_item')->where('news_item_id',$id)->delete();
                if ($newsitem->image) {
                    (file_exists(sprintf($img_path . '%s', $newsitem->image)))?unlink(sprintf($img_path . '%s', $newsitem->image)):'';
                }
                $newsitem->delete();
            }
        }
    }
    
    public function storeFaq(Request $request){
        $faq= new Faq();
        $faq->question_en = $request->question_en;
        $faq->answer_en = $request->answer_en;
        $faq->question_ar = $request->question_ar;
        $faq->answer_ar = $request->answer_ar;
        $faq->type = 'news_item';
        $faq->news_item_id = $request->news_item_id;
        $faq->save();
        
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return back();
    }

    public function updateFaq(Request $request){
        $faq=Faq::find($request->faq_id);
        $faq->question_en = $request->question_en;
        $faq->answer_en = $request->answer_en;
        $faq->question_ar = $request->question_ar;
        $faq->answer_ar = $request->answer_ar;
        $faq->save();
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return back();
    }
    
    public function removeFaq(){
        $faqId= $_POST['faq_id'];
        Faq::find($faqId)->delete();
    }
}
