<?php

namespace App\Http\Controllers;

use App\Models\Chapter;
use App\Models\Lesson;
use Illuminate\Http\Request;
use App\Models\Course;
use File;
use Image;
class LessonController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:lessons');
    }

    public function index()
    {
        $lessons = Lesson::with('chapter', 'course','attachments')->get();
        return view('admin.lessons.lessons', compact('lessons'));
    }
    public function create()
    {
        $courses = Course::with('type')->get();
        return view('admin.lessons.addLesson', compact('courses'));
    }
    public function store(Request $request)
    {
        $request->validate([
            'name_en'=>'required',
            'name_ar'=>'required',
            'course_id'=>'required',
            'chapter_id'=>'required',
        ]);
        $lesson = new Lesson();
        $course = Course::findOrFail($request->course_id);
        if($course->type_id==3){
            $pattern = '/<iframe[^>]*\ssrc=("|\')(.*?)("|\')[^>]*>/s';
            preg_match($pattern, $request->content_link_en, $matches);
            $src = $matches[2]; // Get the src attribute value
            $iframeTag = '<iframe src="' . htmlspecialchars($src) . '" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write" style="width:100%;height:100%;" ></iframe>';
        }
        $lesson->course_id = $request->course_id;
        $lesson->chapter_id = $request->chapter_id;
        $lesson->name_en = $request->name_en;
        $lesson->name_ar = $request->name_ar;
        $lesson->text_en = $request->text_en;
        $lesson->text_ar = $request->text_ar;
        $lesson->content_link_en = $course->type_id==3?$iframeTag: $request->content_link_en;
        $lesson->content_link_ar = $request->content_link_ar;
        $lesson->duration = $request->duration;
        $lesson->date = $request->meeting_date;
        $lesson->time = $request->meeting_time;
        $lesson->order = $request->order;
        $lesson->free = $request->free?1:0;
        $lesson->link_en = $request->link_en ? preg_replace('/[ \/]/', '-', $request->link_en) : preg_replace('/[ \/]/', '-', $request->name_en);
        $lesson->link_ar = $request->link_ar ? preg_replace('/[ \/]/', '-', $request->link_ar) : preg_replace('/[ \/]/', '-', $request->name_ar);
        $lesson->status = $request->status ?? 0;
        $lesson->save();

        return redirect('admin/lessons/'.$lesson->id.'/edit')->with('success', trans('home.your_item_added_successfully'));
    }
    public function edit($id)
    {
        $lesson = Lesson::with('attachments')->where('id',$id)->first();
        if ($lesson) {
            $courses = Course::with('type')->get();
            $chapters = Chapter::where('course_id',$lesson->course_id)->get();
            return view('admin.lessons.editLesson', compact('courses','lesson','chapters'));
        } else {
            abort('404');
        }
    }

    public function update(Request $request, $id)
    {
        
        $lesson = Lesson::find($id);
        $course = Course::findOrFail($lesson->course_id); 
        if($course->type_id==3){
            $pattern = '/<iframe[^>]*\ssrc=("|\')(.*?)("|\')[^>]*>/s';
            // $pattern = '/<iframe[^>]*>.*?<\/iframe>/s';
            preg_match($pattern, $request->content_link_en, $matches);
            $src = $matches[2]; // Get the src attribute value
            $iframeTag = '<iframe src="' . htmlspecialchars($src) . '" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write" style="width:100%;height:100%;" ></iframe>';
        }



        $lesson->chapter_id = $request->chapter_id??$lesson->chapter_id;
        $lesson->name_en = $request->name_en;
        $lesson->name_ar = $request->name_ar;
        $lesson->text_en = $request->text_en;
        $lesson->text_ar = $request->text_ar;
        $lesson->content_link_en = $course->type_id==3?$iframeTag: $request->content_link_en;
        $lesson->content_link_ar = $request->content_link_ar;
        $lesson->duration = $request->duration;
        $lesson->date = $request->meeting_date;
        $lesson->time = $request->meeting_time;
        $lesson->order = $request->order;
        $lesson->free = $request->free?1:0;
        $lesson->link_en = $request->link_en ? preg_replace('/[ \/]/', '-', $request->link_en) : preg_replace('/[ \/]/', '-', $request->name_en);
        $lesson->link_ar = $request->link_ar ? preg_replace('/[ \/]/', '-', $request->link_ar) : preg_replace('/[ \/]/', '-', $request->name_ar);
        $lesson->status = $request->status ?? 0;
        $lesson->save();

        return redirect('admin/lessons')->with('success', trans('home.your_item_updated_successfully'));
    }
    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            $m = Lesson::findOrFail($id);
            $m->delete();
        }
    }
}
