<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Imports\InstructorImport;
use Illuminate\Http\Request;
use Symfony\Component\Intl\Countries;

use App\Models\Center;
use App\Models\Instructor;
use App\Models\Nationality;
use App\Models\User;
use App\Models\Country;
use App\Models\InstructorInfo;
use App\Models\InstructorAddress;
use App\DataTables\InstructorsDataTable;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\DB;
use Image;

class InstructorController extends Controller
{

    public function __construct()
    {
        // $this->middleware('permission:instructor');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(InstructorsDataTable $dataTable,$center_id=null)
    {
        // $instructors = Instructor::with('user')
        //             ->groupBy('user_id')
        //             ->select('id','user_id', DB::raw('count(*) as count'))
        //             ->get();
        // return view('admin.instructors.index', compact('instructors'));
        $centers_selectors = Center::where('status',1)->get();
        return $dataTable->with(['center_id' => $center_id])->render('admin.instructors.index_copy',['centers_selectors' => $centers_selectors]);
    }

    public function create()
    {
        // return auth()->user()->partner->first()->centers->first();
        $centers = Center::all();
        $countries = Country::all();
        $nationalities = Nationality::select('country_enNationality','country_arNationality')->get();
        return view('admin.instructors.create',compact('centers','countries','nationalities'));
    }
    
    // form to assign instructors to training
    public function assign_instructor()
    {
        $centers = Center::all();
        $users = User::with('instructor_info')
            ->where('type', 'partner')
            ->whereHas('instructor_info', function ($query) {
                $query->whereNotNull('ssn');
            })
            ->get();

        return view('admin.instructors.assign_instructor',compact('centers','users'));
    }
    
    // store instructors to trainig action
    public function assign_instructor_store(Request $request)
    {
        $request->validate([
            'center' => 'required|string',
            'instructors' => 'required',
        ]);
        
        foreach($request->instructors as $instructor){
            
            $instructor_check = Instructor::where('user_id',$instructor)->where('center_id',$request->center)->first();
            if(!$instructor_check){
                $instructor= new Instructor();
                $instructor->user_id = $instructor;
                $instructor->center_id = $request->center;
                $instructor->created_by = auth()->user()->id;
                $instructor->save();
            }
        }
        toastr()->success(trans('home.item_added_successfully'), trans('home.saved'));
        return redirect()->route('instructors.index');
    }
    
    // Form Un_Assign instructors to trainig
    public function un_assign_instructor()
    {
        $centers = Center::all();
        $users = User::with('instructor_info')
            ->where('type', 'partner')
            ->whereHas('instructor_info', function ($query) {
                $query->whereNotNull('ssn');
            })
            ->get();

        return view('admin.instructors.un_assign_instructor',compact('trainings','users'));
    }
    
    //  Un_Assign instructors to trainig action
    public function un_assign_instructor_remove(Request $request)
    {
        $request->validate([
            'center' => 'required',
            'instructors' => 'required',
        ]);
        Instructor::whereIn('user_id',$request->instructors)->whereIn('center_id',$request->center)->delete();

        toastr()->success(trans('home.item_deleted_successfully'), trans('home.saved'));
        return redirect()->route('instructors.index');
    }
    
    
    // store instructors data and its training

    public function store(Request $request)
    {
        // return $request->centers;
        $request->validate([
            'f_name' => 'required|string',
            'email' => ['nullable','string', 'email', 'max:255', 'unique:users'],
            'mobile' => 'required',
            'centers' => 'required',
            'image' => 'sometimes|image|mimes:jpg,png,jpeg,gif,svg',
        ],
        [
            'centers.required' => trans("home.please insert center for this partner"),
            ]
        );
        // new user
        $user =new User();
        $user->f_name = $request->f_name;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->verification_code = rand(111111, 999999);
        $user->type = 'instructor';
        $user->device_type = 'web';
        $user->status = 1;
        $user->created_by = auth()->user()->id;
        
        if ($request->hasFile("image")) {

            $file = $request->file("image");
            // $mime = FacadesFile::mimeType($file);
            $mime = $request->file('image')->getMimeType();
            $mimearr = explode('/', $mime);

            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path() . '/uploads/users/source/' . $fileName;

            Image::make($file->getRealPath())->save($path);

            $user->image = $fileName;
        }
        $user->save();
        
        $user->assignRole('مدرب / Trainer');
        // user_information
        $instructor_info = new InstructorInfo();
        $instructor_info->user_id = $user->id;
        $instructor_info->ssn = $request->ssn;
        $instructor_info->mobile = $request->mobile;
        $instructor_info->whatsapp = $request->whatsapp;
        $instructor_info->nationality = $request->nationality;
        $instructor_info->specialization = $request->specialization;
        $instructor_info->sub_specialization = $request->sub_specialization;
        $instructor_info->job_title = $request->job_title;
        $instructor_info->registration_date = now();
        $instructor_info->created_by = auth()->user()->id;
        
        if ($request->hasFile('cv')) {
            $instructor_info->cv  = Helper::uploadFile('instructors/cvs',$request->cv);
        }
        $instructor_info->save();
        
        // user_address
        $instructor_address = new InstructorAddress();
        $instructor_address->instructor_id = $instructor_info->id;
        $instructor_address->country_id = $request->country_id;
        $instructor_address->region_id = $request->region_id;
        $instructor_address->area_id = $request->area_id;
        // $instructor_address->address = $request->address;
        // $instructor_address->building_num = $request->building_num;
        // $instructor_address->flat_num = $request->flat_num;
        // $instructor_address->land_mark = $request->land_mark;
        $instructor_address->created_by = auth()->user()->id;
        $instructor_address->save();
        if($request->centers){
            foreach($request->centers as $center_id){
                $instructor= new Instructor();
                $instructor->user_id = $user->id;
                $instructor->center_id = $center_id;
                $instructor->created_by = auth()->user()->id;
                $instructor->save();
            }
        }
        toastr()->success(trans('home.item_added_successfully'), trans('home.saved'));
        return redirect()->route('instructors.index');
        
    }
        

    public function edit($id)
    {
        $centers = Center::all();
        $countries = Country::all();
        $nationalities = Nationality::select('country_enNationality','country_arNationality')->get();
        $user = User::with(['instructor_info','centers'])
                ->where('id', $id)
                ->whereHas('instructor_info', function ($query) {
                    $query->whereNotNull('ssn');
                })
            ->first();
        // return $user;
        if ($user) {
            return view('admin.instructors.edit', compact('user','centers','countries','nationalities'));
        } else {
            abort('views.404');
        }
    }


    public function update(Request $request, $id)
    {
        $user = User::findOrFail($id);
          $request->validate([
            'f_name' => 'required|string',
            'email' => 'nullable|string|email|max:255|unique:users,email,'.$id,
            'mobile' => 'required',
            'image' => 'image|mimes:jpg,png,jpeg,gif,svg',
        ]);
        // new user
        $user->f_name = $request->f_name;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->verification_code = rand(111111, 999999);
        $user->type = 'instructor';
        $user->device_type = 'web';
        $user->status =$request->status?? 0;
        $user->updated_by = auth()->user()->id;
        
        if ($request->hasFile("image")) {

            $file = $request->file("image");
            $mime = $request->file('image')->getMimeType();
            $mimearr = explode('/', $mime);
            
            $img_path = base_path() . '/uploads/users/source/';
            if ($user->image) {
                    (file_exists($img_path .  $user->image))?unlink($img_path . $user->image):'';
            }

            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path() . '/uploads/users/source/' . $fileName;

            Image::make($file->getRealPath())->save($path);

            $user->image = $fileName;
        }
        $user->save();
        
        // user_information
        $instructor_info = InstructorInfo::where('user_id',$id)->first();
        $instructor_info->ssn = $request->ssn;
        $instructor_info->mobile = $request->mobile;
        $instructor_info->whatsapp = $request->whatsapp;
        $instructor_info->nationality = $request->nationality;
        $instructor_info->specialization = $request->specialization;
        $instructor_info->sub_specialization = $request->sub_specialization;
        $instructor_info->job_title = $request->job_title;
        $instructor_info->registration_date = now();
        $instructor_info->updated_by = auth()->user()->id;
        if ($request->hasFile('cv')) {
            $instructor_info->cv  = Helper::updateUploadFile('instructors/cvs',$request->cv,$instructor_info->cv);
        }
        $instructor_info->save();
        
        // user_address
        $instructor_address = InstructorAddress::where('instructor_id',$instructor_info->id)->first();
        if($instructor_address) {
            $instructor_address->instructor_id = $instructor_info->id;
            $instructor_address->country_id = $request->country_id;
            $instructor_address->region_id = $request->region_id;
            $instructor_address->area_id = $request->area_id;
            // $instructor_address->address = $request->address;
            // $instructor_address->building_num = $request->building_num;
            // $instructor_address->flat_num = $request->flat_num;
            // $instructor_address->land_mark = $request->land_mark;
            $instructor_address->updated_by = auth()->user()->id;
            $instructor_address->save();
        } else {
            $instructor_address = new InstructorAddress();
            $instructor_address->instructor_id = $instructor_info->id;
            $instructor_address->country_id = $request->country_id;
            $instructor_address->region_id = $request->region_id;
            $instructor_address->area_id = $request->area_id;
            // $instructor_address->address = $request->address;
            // $instructor_address->building_num = $request->building_num;
            // $instructor_address->flat_num = $request->flat_num;
            // $instructor_address->land_mark = $request->land_mark;
            $instructor_address->updated_by = auth()->user()->id;
            $instructor_address->save();
        }
        
        
        $instructor = Instructor::where('user_id', $user->id)->delete();
        if($request->centers && $request->centers[0] != null ) {
            foreach ($request->centers as $center_id) {
                $existingInstructor = Instructor::where('user_id', $user->id)
                                          ->where('center_id', $center_id)
                                          ->first();
                if (!$existingInstructor) {
                    $instructor = new Instructor();
                    $instructor->user_id = $user->id;
                    $instructor->center_id = $center_id;
                    $instructor->created_by = auth()->user()->id;
                    $instructor->save();
                }
            }
        }
        toastr()->success(trans('home.item_updated_successfully'), trans('home.saved'));
        return redirect()->route('instructors.index');
    }
    
    
    public function instructors_per_centers(Request $request){
        $center = Center::find($request->center_id);
        $instructors = Instructor::with('user')->where('center_id',$request->center_id)->get();
        return view('admin.instructors.instructors_per_training', compact('center','instructors'));
        
    }
    
    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            $user = User::findOrFail($id);
            $img_path = base_path() . '/uploads/users/source/';
            if ($user->image) {
                    (file_exists($img_path .  $user->image))?unlink($img_path . $user->image):'';
            }
             $user->delete();
           
        }
    }
    
    

    // public function importExcel(Request $request)
    // {
    //     if (empty($request->file('excelFile'))) {
    //         toastr()->error(trans('home.file_not_found'), trans('home.not_found'));
    //     }
    //     $instructors = Excel::import(new InstructorImport,$request->file('excelFile'));

    //     foreach ($instructors as $instructor) {
    //         Instructor::create($instructor);
    //     }

    //     toastr()->success(trans('home.file_uploaded_successfully'), trans('home.file_uploaded'));
    //     return redirect()->back();
    // }
}
