<?php

namespace App\Http\Controllers;

use App\Models\HomeSlider;
use DB;
use File;
use Image;
use Illuminate\Http\Request;
use App\Helpers\Helper;

class HomeSliderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct(){
        $this->middleware(['permission:sliders']);
    }

    public function index()
    {
        $sliders = HomeSlider::orderBy('id','DESC')->get();
        return view('admin.sliders.sliders',compact('sliders'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.sliders.addSlider');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $add = new HomeSlider();
        $add->title = $request->title;
        $add->text = $request->text;
        $add->link = $request->link;
        $add->order = $request->order;
        $add->lang = $request->lang;
        $add->status = $request->status;
        
        if($request->image){
            $add->image = Helper::uploadImage('sliders',$request->image);
        } 
        $add->save();
        
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return redirect()->route('sliders.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $slider=HomeSlider::find($id);
        if($slider){
            return view('admin.sliders.editSlider',compact('slider'));
        }else{
            abort('404');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $add = HomeSlider::find($id);
        $add->title = $request->title;
        $add->text = $request->text;
        $add->link = $request->link;
        $add->order = $request->order;
        $add->lang = $request->lang;
        $add->status = $request->status;
        if($add->image && $request->image){
            $add->image = Helper::updateUploadedImage('sliders',$request->image ,$add->image);
        }elseif($request->image){
            $add->image = Helper::uploadImage('sliders',$request->image);
        } 
        $add->save();
        
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.uppdated'));
        return redirect()->route('sliders.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        $allElements = ($ids[0] == 'on')? true:false;
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }

        $img_path = base_path() . '/uploads/sliders/';
        if($allElements){
            
            foreach ($ids as $id) {
                $slider = HomeSlider::findOrFail($id);
                if ($slider->image) {
                    (file_exists(sprintf($img_path . '%s', $slider->image)))?unlink(sprintf($img_path . '%s', $slider->image)):'';
                }
            }
            HomeSlider::truncate();
            
        }else{
        
            foreach ($ids as $id) {
                $slider = HomeSlider::findOrFail($id);
                if ($slider->image) {
                    (file_exists(sprintf($img_path . '%s', $slider->image)))?unlink(sprintf($img_path . '%s', $slider->image)):'';
                }
                $slider->delete();
            }
        }
    }
    
}
