<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Imports\HallImport;
use Illuminate\Http\Request;
use Symfony\Component\Intl\Countries;

use App\DataTables\CenterHallDataTable;
use App\Models\Center;
use App\Models\CenterHall;
use App\Models\Country;
use App\Models\Region;
use App\Models\Area;
use App\Models\Partner;
use Maatwebsite\Excel\Facades\Excel;

class HallController extends Controller
{

    public function __construct()
    {
        // $this->middleware('permission:hall');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(CenterHallDataTable $dataTable)
    {
        // $halls = CenterHall::find(4);
        // return $halls->center;
        //  if(auth()->user()->type=="partner"){
        //     // $centers_ids = auth()->user()->partner->centers()->get()->pluck('id')->toArray();
        //     $centers_ids =Partner::where('user_id',auth()->user()->id)->pluck('center_id')->toArray();
        //     $centers = Center::whereIn('id',$centers_ids)->get();
        //     $halls = CenterHall::whereIn('center_id',$centers_ids)->get();
        // }else{
        //     $halls = CenterHall::all();
        // }
        // return view('admin.halls.halls', compact('halls'));
        
        return $dataTable->render('admin.halls.index_copy');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = Country::get();
        $centers = Center::all();
        return view('admin.halls.addHall',compact('centers','countries'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            // 'name_en' => 'required|string',
            'name_ar' => 'required|string',
            'center_id' => 'required|exists:centers,id',
            'capacity' => 'required|integer',
            'type' => 'required',
            'map_url' => 'required',
            'logo' => 'sometimes|image|mimes:jpg,png,jpeg,gif,svg',
        ]);

        $add = new CenterHall();
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->building_name = $request->building_name;
        $add->floor = $request->floor;
        $add->center_id = $request->center_id;
        $add->capacity = $request->capacity;
        $add->type = $request->type;
        $add->disabled_suitable = $request->disabled_suitable;
        $add->map_url = $request->map_url;
        $add->country_id = $request->country_id;
        $add->region_id = $request->region_id;
        $add->area_id = $request->area_id;
        $add->address_en = $request->address_en;
        $add->address_ar = $request->address_ar;
        $add->map_url = $request->map_url;
        $add->created_by = auth()->user()->id;
        
        if ($request->logo) {
            $add->logo = Helper::uploadImage('center_halls', $request->logo);
        }

        $add->save();

        toastr()->success(trans('home.hall_added_successfully'), trans('home.saved'));
        return redirect()->route('center_halls.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $hall = CenterHall::findOrFail($id);
        $centers = Center::all();
        if ($hall) {
            $countries = Country::get();
            $regions = Region::get();
            $areas = Area::get();
            return view('admin.halls.editHall', compact('hall','centers','countries','regions','areas'));
        } else {
            abort('views.404');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            // 'name_en' => 'required|string',
            'name_ar' => 'required|string',
            'center_id' => 'required|exists:centers,id',
            'capacity' => 'required|integer',
            'type' => 'required',
            'map_url' => 'required',
            'logo' => 'sometimes|image|mimes:jpg,png,jpeg,gif,svg',
        ]);

        $updated = CenterHall::findOrFail($id);

        $updated->name_en = $request->name_en;
        $updated->name_ar = $request->name_ar;
        $updated->building_name = $request->building_name;
        $updated->floor = $request->floor;
        $updated->center_id = $request->center_id;
        $updated->capacity = $request->capacity;
        $updated->type = $request->type;
        $updated->disabled_suitable = $request->disabled_suitable;
        $updated->map_url = $request->map_url;
        $updated->country_id = $request->country_id;
        $updated->region_id = $request->region_id;
        $updated->area_id = $request->area_id;
        $updated->address_en = $request->address_en;
        $updated->address_ar = $request->address_ar;
        $updated->map_url = $request->map_url;
        $updated->updated_by = auth()->user()->id;

        
        if ($request->logo) {
            $updated->logo = Helper::updateUploadedImage('center_halls', $request->logo,$updated->logo);
        }

        $updated->save();

        toastr()->success(trans('home.hall_updated_successfully'), trans('home.updated'));
        return redirect()->route('center_halls.index');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
           CenterHall::destroy($id);
        }
    }

}
