<?php

namespace App\Http\Controllers;

use DB;
use File;
use Image;
use App\Models\GalleryImage;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Helpers\Helper;

class GalleryImageController extends Controller
{
 

    public function __construct(){
        $this->middleware(['permission:galleryImage']);
    }


    public function index(){
        $galleryImages = GalleryImage::orderBy('order','asc')->get();
        return view('admin.galleryImages.galleryImages',compact('galleryImages'));
    }
    
    
    public function createPluck(){
        $images = DB::table('temp_upload_files')->where('type','gallery_image')->get();
        if(count($images) > 0){
            foreach($images as $image){
                try{
                    $img_path = base_path() . '/uploads/galleryImages/';
                    if($image->server_name){
                        (file_exists(sprintf($img_path . '%s', $image->server_name)))?unlink(sprintf($img_path . '%s', $image->server_name)):'';
                    }
                }catch(Exception $e){
                }
            }
            DB::table('temp_upload_files')->where('type','gallery_image')->delete();
            session()->forget('imagesUpload');
            session()->forget('imagesUploadRealName');
        }
        return view('admin.galleryImages.addPluckGalleryImages');
    }
    
    
    public function storePluck(Request $request){
        ///////// save gallery images//////
        if(\Session::has('imagesUpload')){
            // $images = \Session::get('imagesUpload');
            $images = DB::table('temp_upload_files')->where('type','gallery_image')->get();
            foreach ($images as $key=>$file) {
                $img = new GalleryImage();
                $img->img = $file->server_name;
                $img->status=1;
                $img->save();
            }
        }

        DB::table('temp_upload_files')->where('type','gallery_image')->delete();
        session()->forget('imagesUpload');
        session()->forget('imagesUploadRealName');
        
        $GalleryImageIds = GalleryImage::pluck('id')->toArray();
        foreach ($GalleryImageIds as $index => $id) {
            GalleryImage::where('id', $id)->update(['order' => $index + 1]);
        }
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return redirect()->route('gallery-images.index');
    }


    public function create(){
        return view('admin.galleryImages.addGalleryImage');
    }
    
    
    public function store(Request $request){
        $add = new GalleryImage();
        $add->text_en = $request->text_en;
        $add->text_ar = $request->text_ar;
        $add->order = $request->order;
        $add->status = $request->status;
        if($request->img){
            $add->img = Helper::uploadImage('galleryImages',$request->img);
        } 
        $add->save();
        
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return redirect()->route('gallery-images.index');
    }
    
    public function edit($id){
        $galleryImage=GalleryImage::find($id);
        if($galleryImage){
            return view('admin.galleryImages.editGalleryImage',compact('galleryImage'));
        }else{
            abort('404');
        }
    }
    
    public function update(Request $request,$id){
        $add = GalleryImage::find($id);
        $add->text_en = $request->text_en;
        $add->text_ar = $request->text_ar;
        $img->type = $request->type;
        $add->order = $request->order;
        $add->status = $request->status;
        
        if($add->img && $request->img){
            $add->img = Helper::updateUploadedImage('sevices',$request->img ,$add->img);
        }elseif($request->img){
            $add->img = Helper::uploadImage('sevices',$request->img);
        } 
        $add->save();

        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return redirect()->route('gallery-images.index');
    }

    public function reorderImeges(Request $request){
        $request->validate([
            'ids'   => 'required|array',
            'ids.*' => 'integer',
        ]);

        foreach ($request->ids as $index => $id) {
            GalleryImage::where('id', $id)->update(['order' => $index + 1]);
        }
        
        $positions = GalleryImage::pluck('order', 'id');

        return response(compact('positions'), Response::HTTP_OK);

    }
    
    
    /////// upload product images///////////////
    public function uploadImages(Request $request){
        if($request->hasFile('file')){
            $file = $request->file("file");
            $realName = $file->getClientOriginalName();
            $fileName = Helper::uploadImage('galleryImages',$file);

            DB::table('temp_upload_files')->insert(['server_name' => $fileName,'original_name' => $realName , 'type'=>'gallery_image']);
            if(\Session::has('imagesUpload')){
                \Session::push('imagesUpload',$fileName);
                \Session::push('imagesUploadRealName',$realName);
            }else{
                $images = [];
                array_push($images,$fileName);
                \Session::put('imagesUpload',$images);
                
                $realImages = [];
                array_push($realImages,$realName);
                \Session::put('imagesUploadRealName',$realImages);
            }
        }
    }
    
    ///////// delete uploaded images///////////
    public function removeUploadImages(Request $request){
        $name = $request->name;
        $names = \Session::get('imagesUploadRealName');
        $images = \Session::get('imagesUpload');
        $key = array_search($name, $names);
        
        $img_path = base_path() . '/uploads/galleryImages/';
       (file_exists(sprintf($img_path . '%s', $images[$key])))?unlink(sprintf($img_path . '%s', $images[$key])):'';
              
        unset($images[$key]);
        unset($names[$key]);
        \Session::put('imagesUpload',$images);
        \Session::put('imagesUploadRealName',$names);
        DB::table('temp_upload_files')->where('original_name',$name)->delete();
    }
    
    public function destroy($ids){
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            $m = GalleryImage::findOrFail($id);
            $img_path = base_path() . '/uploads/gallery-images/source/';

            if ($m->image) {
                (file_exists(sprintf($img_path . '%s', $images[$key])))?unlink(sprintf($img_path . '%s', $m->image)):'';
            }
            $m->delete();
        }
        
        $GalleryImageIds = GalleryImage::pluck('id')->toArray();
        foreach ($GalleryImageIds as $index => $id) {
            GalleryImage::where('id', $id)->update(['order' => $index + 1]);
        }
    }

}
