<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Faq;

class FaqController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:faq');
    }
    
    public function editFaq(){
        $questions = Faq::where('type','general')->get();
        return view('admin.faqs.editFaq',compact('questions'));
    }

    public function storeFaq(Request $request){ 
        
        $faq=new Faq();
        $faq->type='general';
        $faq->question_en = $request->question_en;
        $faq->answer_en = $request->answer_en;
        $faq->question_ar = $request->question_ar;
        $faq->answer_ar = $request->answer_ar;
        $faq->save();
        
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return back();
    }
    
    public function updateGeneralFaq(Request $request){
        $faq=Faq::find($request->faq_id);
        $faq->question_en = $request->question_en;
        $faq->answer_en = $request->answer_en;
        $faq->question_ar = $request->question_ar;
        $faq->answer_ar = $request->answer_ar;
        $faq->save();
        
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return back();
    }
    
    public function removeGeneralFaq(){
        $faqId= $_POST['faq_id'];
        Faq::find($faqId)->delete();
        
        toastr()->error(trans('home.your_item_deletd_successfully') , trans('home.deleted'));
    }
}
