<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Imports\CourseImport;
use Illuminate\Http\Request;
use Symfony\Component\Intl\Countries;

use App\Models\Exame;
use App\Models\Course;
use App\Models\InstructorInfo;
use App\Models\TrainingCourse;
use App\Models\TrainingExam;
use App\Models\ExameQuestion;
use App\Models\ExameAnswer;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\DB;
class ExameQuestionsController extends Controller
{

    public function __construct()
    {
        // $this->middleware('permission:exames');
    }

    public function index()
    {
        if(auth()->user()->type=="instructor"){
            // $instructor_id = InstructorInfo::where('user_id',auth()->user()->id)->first()->id;
            $training_ids = TrainingCourse::where('instructor_id',auth()->user()->id)->pluck('training_id')->toArray();
            $exam_ids = TrainingExam::whereIn('training_id',$training_ids)->pluck('exam_id')->toArray();
            $exames_questions = ExameQuestion::whereIn('exame_id',$exam_ids)->get();
        }else {
            $exames_questions = ExameQuestion::all();
        }
        return view('admin.examQuestions.index', compact('exames_questions'));
    }


    public function create()
    {
        $exames = Exame::all();
        return view('admin.examQuestions.create',compact('exames'));
    }

  
    public function store(Request $request)
    {
        $request->validate([
            'question_en' => 'required|string',
            'question_ar' => 'required|string',
            'exame' =>  'required|string',
        ]);

        $add = new ExameQuestion();
        $add->question_en = $request->question_en;
        $add->question_ar = $request->question_ar;
        $add->exame_id = $request->exame;
        $add->status = $request->status;
        $add->created_by = auth()->user()->id;
        $add->save();

        toastr()->success(trans('home.your_item_added_successfully'), trans('home.saved'));
        return redirect()->route('questions.edit',$add->id);
    }



    public function edit($id)
    {
        $question = ExameQuestion::find($id);
        $answers = ExameAnswer::where('question_id',$id)->get();
        $exames = Exame::all();
        if ($question) {
            return view('admin.examQuestions.edit', compact('question','exames','answers'));
        } else {
            abort('views.404');
        }
    }

    public function show($id)
    {
        $exames_questions = ExameQuestion::where('exame_id',$id)->get();
        return view('admin.examQuestions.index', compact('exames_questions'));
    }

    public function update(Request $request, $id)
    {
         $request->validate([
            'question_en' => 'required|string',
            'question_ar' => 'required|string',
            'exame' =>  'required|string',
        ]);

        $add = ExameQuestion::find($id);
        $add->question_en = $request->question_en;
        $add->question_ar = $request->question_ar;
        $add->exame_id = $request->exame;
        $add->status = $request->status;
        $add->updated_by = auth()->user()->id;
        $add->save();
        
        $answers_en=$request->answer_en;
        if($answers_en){
            $answers_ar=$request->answer_ar;
            $is_correct=$request->is_correct;
            foreach($answers_en as $key=>$answer_en){
                if($answer_en && $answers_ar[$key]){
                    $answer=new ExameAnswer();
                    $answer->question_id = $id;
                    $answer->answer_en=$answer_en;
                    $answer->answer_ar=$answers_ar[$key];
                    $answer->is_correct=$is_correct[$key];
                    $answer->created_by = auth()->user()->id;
                    $answer->save();
                }
            }
        }

        toastr()->success(trans('home.your_item_updated_successfully'), trans('home.updated'));
        return redirect()->route('questions.index');
    }

    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        $allElements = ($ids[0] == 'on')? true:false;
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        if($allElements){
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');
            ExameQuestion::truncate();
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
            
        }else{
            foreach ($ids as $id) {
                ExameQuestion::findOrFail($id)->delete();
            }
        }
    }  
    
    
    public function delete_answer_question(Request $request){
        ExameAnswer::findOrFail($request->answer_id)->delete();
    }
    
    public function editanswer(Request $request){
        $answer = ExameAnswer::find($request->answer_id);
        return response()->json(['view' => view('admin.examQuestions.edit_answer_modal', compact('answer'))->render() ]);


    }
    
    public function updateAnswer(Request $request){
        $answer = ExameAnswer::find($request->answer_id);
        $answer->answer_en=$request->answer_en;
        $answer->answer_ar=$request->answer_ar;
        $answer->is_correct=$request->is_correct;
        $answer->updated_by = auth()->user()->id;
        $answer->save();
         toastr()->success(trans('home.your_item_updated_successfully'), trans('home.updated'));
        return redirect()->route('questions.edit',$answer->question_id);

    }

}
