<?php

namespace App\Http\Controllers;

use App\Models\Event;
use Illuminate\Http\Request;
use Spatie\CalendarLinks\Link;
use Carbon\Carbon;

use DB;
use File;
use Image;

class EventController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:webinars');
    }

    public function index()
    {
        $webinars = Event::all();
        return view('admin.webinars.webinars', compact('webinars'));
    }


    public function create()
    {
        return view('admin.webinars.addwebinar');
    }


    public function store(Request $request)
    {
        $request->validate([
            'name_en' => 'required|string',
            'name_ar' => 'required|string',
            'start_date' => 'required',
            'end_date' => 'required',
        ]);

        $add = new Event();
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->location = $request->location;
        $add->start_date = $request->start_date;
        $add->start_date = $request->start_date;
        $add->end_date = $request->end_date;
        $add->speaker = $request->speaker;
        $add->type = $request->type;
        $add->price = $request->price;
        $add->video_link = $request->video_link;

        
        $add->text_en = $request->text_en;
        $add->text_en_2 = $request->text_en_2;
        $add->text_ar = $request->text_ar;
        $add->text_ar_2 = $request->text_ar_2;
        
        $add->status = $request->status ?? 0;
        $add->link_en = $request->link_en ? preg_replace('/[ \/]/', '-', $request->link_en) : preg_replace('/[ \/]/', '-', $request->name_en);
        $add->link_ar = $request->link_ar ? preg_replace('/[ \/]/', '-', $request->link_ar) : preg_replace('/[ \/]/', '-', $request->name_ar);
        if ($request->hasFile("image")) {

            $file = $request->file("image");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            $extension = $mimearr[1];
            $fileName = rand(11111, 99999) . '.' . $extension;
            $path = base_path('uploads/webinars/source/' . $fileName);

            Image::make($file->getRealPath())->save($path);
            $add->image = $fileName;
        }
        $timezone = 'Africa/Cairo'; // or use the appropriate timezone
        $startDate = Carbon::createFromFormat('Y-m-d\TH:i', $request->start_date, $timezone);
        $endDate = Carbon::createFromFormat('Y-m-d\TH:i', $request->end_date, $timezone);

        // // Create the calendar link
        // $link = Link::create($request->name_en, $startDate, $endDate)
        //     ->description($request->name_en)
        //     ->address($request->location);
        // $add->google_calender = $link->google();
        $add->save();

        return redirect()->route('webinars.index')->with('success', trans('home.your_item_added_successfully'));
    }



    public function edit($id)
    {
        $webinar = Event::find($id);
        if ($webinar) {
            return view('admin.webinars.editwebinar', compact('webinar'));
        } else {
            abort('views.404');
        }
    }

    public function update(Request $request, $id)
    {
        
        $add = Event::find($id);
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->location = $request->location;
        $add->start_date = $request->start_date;
        $add->start_date = $request->start_date;
        $add->end_date = $request->end_date;
        $add->speaker = $request->speaker;
        $add->type = $request->type;
        $add->price = $request->price;
        $add->video_link = $request->video_link;

        $add->text_en = $request->text_en;
        $add->text_en_2 = $request->text_en_2;
        $add->text_ar = $request->text_ar;
        $add->text_ar_2 = $request->text_ar_2;
        $add->status = $request->status ?? 0;
        $add->link_en = $request->link_en ? preg_replace('/[ \/]/', '-', $request->link_en) : preg_replace('/[ \/]/', '-', $request->name_en);
        $add->link_ar = $request->link_ar ? preg_replace('/[ \/]/', '-', $request->link_ar) : preg_replace('/[ \/]/', '-', $request->name_ar);
        if ($request->hasFile("image")) {

            $file = $request->file("image");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            $extension = $mimearr[1];
            $fileName = rand(11111, 99999) . '.' . $extension;
            if ($add->image != null) {
                $img_path = base_path() . '/uploads/webinars/source/';
                file_exists($img_path.$add->image) ? unlink($img_path.$add->image):'';
            }
            $path = base_path('uploads/webinars/source/' . $fileName);

            Image::make($file->getRealPath())->save($path);
            $add->image = $fileName;
        }
        $timezone = 'Africa/Cairo'; // or use the appropriate timezone
        $startDate = Carbon::createFromFormat('Y-m-d\TH:i', $request->start_date, $timezone);
        $endDate = Carbon::createFromFormat('Y-m-d\TH:i', $request->end_date, $timezone);

        // // Create the calendar link
        // $link = Link::create($request->name_en, $startDate, $endDate)
        //     ->description($request->name_en)
        //     ->address($request->location);
        // $add->google_calender = $link->google();
        $add->save();

        return redirect()->route('webinars.index')->with('success', trans('home.your_item_updated_successfully'));

    }

    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }

        foreach ($ids as $id) {
            $m = Event::findOrFail($id);
            $img_path = base_path() . '/uploads/webinars/source/';

            if ($m->image != null) {
                file_exists($img_path . $m->image) ? unlink($img_path . $m->image) : '';
            }
            $m->delete();
        }
    }




}
