<?php

namespace App\Http\Controllers;

use App\Models\Brand;
use DB;
use File;
use Image;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;
use App\Helpers\Helper;


class BrandController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct(){
        $this->middleware(['permission:brands']);
    }

    public function index()
    {
        //
        $brands = Brand::orderBy('id','DESC')->get();
        return view('admin.brands.brands',compact('brands'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('admin.brands.addBrand');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $add = new Brand();
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->status = $request->status;

        $link_en = str_replace(" ","-",$add->name_en);
        $add->link_en = str_replace(" ","-",$link_en);  
        $link_ar = str_replace(" ","-",$add->name_ar);
        $add->link_ar = str_replace(" ","-",$link_ar); 
        
        $add->meta_title_en = $request->meta_title_en;
        $add->meta_desc_en = $request->meta_desc_en;
        $add->meta_title_ar = $request->meta_title_ar;
        $add->meta_desc_ar = $request->meta_desc_ar;
        $add->meta_robots = $request->meta_robots ; 
        $add->alt_img = $request->alt_img ;
        if($request->image){
            $add->image = Helper::uploadImage('brands',$request->image);
        } 
        $add->save();
        toastr()->success(trans('home.your_item_saved_successfully') , trans('home.saved'));
        return redirect()->route('brands.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $brand=Brand::find($id);
        if($brand){
            return view('admin.brands.editBrand',compact('brand'));
        }else{
            abort('404');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $add = Brand::find($id);
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;

        $link_en = str_replace(" ","-",$add->name_en);
        $add->link_en = str_replace(" ","-",$link_en);  
        $link_ar = str_replace(" ","-",$add->name_ar);
        $add->link_ar = str_replace(" ","-",$link_ar); 
        
        $add->meta_title_en = $request->meta_title_en;
        $add->meta_desc_en = $request->meta_desc_en;
        $add->meta_title_ar = $request->meta_title_ar;
        $add->meta_desc_ar = $request->meta_desc_ar;
        $add->meta_robots = $request->meta_robots ; 
        $add->status = $request->status ;

        if($add->image && $request->image){
            $add->image = Helper::updateUploadedImage('brands',$request->image ,$add->image);
        }elseif($request->image){
            $add->image = Helper::uploadImage('brands',$request->image);
        } 
         $add->alt_img = $request->alt_img ;
        
        $add->save();
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return redirect()->route('brands.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids){
        $ids = explode(',', $ids);
        $allElements = ($ids[0] == 'on')? true:false;
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }

        $img_path = base_path() . '/uploads/brands/';
        if($allElements){
            
            foreach ($ids as $id) {
                $brand = Brand::findOrFail($id);
                if ($brand->image) {
                    (file_exists(sprintf($img_path . '%s', $brand->image)))?unlink(sprintf($img_path . '%s', $brand->image)):'';
                }
            }
            Schema::disableForeignKeyConstraints();
            Brand::truncate();
            
        }else{
        
            foreach ($ids as $id) {
                $brand = Brand::findOrFail($id);
                if ($brand->image) {
                    (file_exists(sprintf($img_path . '%s', $brand->image)))?unlink(sprintf($img_path . '%s', $brand->image)):'';
                }
                $brand->delete();
            }
        }
    }
    
}
