<?php

namespace App\Http\Controllers\Auth;

use App\Country;
use App\Http\Controllers\Controller;
use App\Models\Cart;
use App\Models\CartCourse;
use App\Models\GuestCart;
use App\Models\GuestCartCourse;
use App\Models\GuestWishlist;
use App\Models\Wishlist;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

use Illuminate\Http\Request;
use App\Vendor;
use Illuminate\Support\Str;
use Auth;
use Session;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */


    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {
        return User::create([
            'f_name' => $data['f_name'],
            'l_name' => $data['l_name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }

    protected function validator(array $data)
    {
        return Validator::make($data, [
            'f_name' => 'required|string|max:150',
            'l_name' => 'required|string|max:150',
            'email' => 'required|string|email|max:150|unique:users',
            'password' => 'required|string|min:6|confirmed',
        ]);
    }

    ///////////// vendor registeration///////////
    public function showVendorRegisterForm(){
        return view('auth.register');
    }

    protected function register(Request $request)
    {
        $this->validator($request->all());

        $request->validate([
            'f_name' => ['required', 'string', 'max:150'],
            'l_name' => ['required', 'string', 'max:150'],
            'email' => ['required', 'string', 'email', 'max:150', 'unique:users'],
            'password' => ['required', 'string', 'min:6', 'confirmed'],
        ]);
        $user = $this->create($request->all());
    
        if (Auth::attempt(['email' => $request->email, 'password' => $request->password])) {
            $this->guestOperations();
            return redirect('/');
        }

    }
    public function guestOperations(){
     

        //////// add guest cart ///////
        if(Session::has('session_id')){
            $session_id = Session::get('session_id');
            
            
            //////// Wishlist ///////
            $guest_wishlist_course_ids = GuestWishlist::where('session_id',$session_id)->pluck('course_id')->toArray();
            foreach($guest_wishlist_course_ids as $course_wish_id ){
                Wishlist::updateOrCreate([
                    'user_id'=>auth()->user()->id,
                    'course_id'=>$course_wish_id,
                ]);
            }
            GuestWishlist::where('session_id',$session_id)->delete();
            
            //////// Cart ///////

            $guestCart = GuestCart::where('session_id',$session_id)->first();
            $cartCourses = GuestCartCourse::where('guest_cart_id',$guestCart->id)->get();
            $amount = 0;

            $cart=Cart::where('user_id',Auth::user()->id)->first();
            if(!$cart){
                // /////create user cart///
                $cart= new Cart();
                $cart->user_id=Auth::user()->id;
                $cart->coupon_id = null;
                $cart->coupon_discount = null;
                $cart->total_price = 0;
                $cart->save();
            }

            foreach($cartCourses as $cartCourse){

                $check_cartCourse=CartCourse::where('course_id',$cartCourse->course_id)->where('cart_id',$cart->id)->orderBy('id','desc')->first();

                if(!$check_cartCourse){
                    //////ADD CART course ////////
                    $add= new CartCourse();
                    $add->cart_id=$cart->id;
                    $add->course_id=$cartCourse->course_id;
                    $add->price=$cartCourse->price;
                    $add->price_before_discount=$cartCourse->price_before_discount;
                    $add->save();
                    $amount += $cartCourse->price;
                }
            }
            $cart->total_price += $amount;
            $cart->save();

            // ////// delete guest cart////
            $guestCart->delete();
            Session::forget('session_id');
        }
    }


}
