<?php

namespace App\Http\Controllers;

use App\Models\Attachment;
use App\Models\Chapter;
use App\Models\Course;
use App\Models\Lesson;
use Illuminate\Http\Request;
use File;
use Image;
class AttachmentController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('permission:lessons');
    }

    public function store(Request $request){
        $lesson = Lesson::with('attachments')->where('id',$request->lesson_id)->first();
        if ($lesson) {
            $request->validate([
            'attachment' => 'required'
            ]);
            $attachment = new Attachment();
            $attachment->name_en = $request->name_en;
            $attachment->name_ar = $request->name_ar;
            $attachment->lesson_id = $request->lesson_id;
            
            if ($request->hasFile("attachment")) {

                $file = $request->file("attachment");
                $mime = File::mimeType($file);
                $mimearr = explode('/', $mime);
                
                // $destinationPath = base_path() . '/uploads/'; // upload path
                $extension = $mimearr[1]; // getting file extension
                $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
                $path = base_path('uploads/attachments/source/' );                
                
                $file->move($path, $fileName);

                $attachment->path = $fileName;
            }

            $attachment->save();
            return redirect()->route('lessons.edit', $lesson->id)->with('success', trans('home.your_item_added_successfully'));;
        }else{
            abort('404');
        }

    }
    public function edit($attach_id){
        $attachment = Attachment::where('id',$attach_id)->first();
        return response()->json([ 'html' => view('admin.attachments.editAttachment', compact('attachment'))->render(),
    ]);



    }

    public function update(Request $request, $id){
        $attachment = Attachment::where('id',$id)->first();
        
        if ($attachment) {

            $attachment->name_en = $request->name_en;
            $attachment->name_ar = $request->name_ar;
            
            if ($request->hasFile("attachment")) {
                $path = base_path('uploads/attachments/source/' );     

                if ($attachment->path != null) {
                    file_exists($path.$attachment->path) ? unlink($path . $attachment->path):'';
                }

                $file = $request->file("attachment");
                $mime = File::mimeType($file);
                $mimearr = explode('/', $mime);
                
                // $destinationPath = base_path() . '/uploads/'; // upload path
                $extension = $mimearr[1]; // getting file extension
                $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
                
                $file->move($path, $fileName);

                $attachment->path = $fileName;
            }

            $attachment->save();
            return redirect()->route('lessons.edit', $attachment->lesson_id)->with('success', trans('home.your_item_added_successfully'));;
        }else{
            abort('404');
        }





        $course = Course::find($id);
        $course->name_en = $request->name_en;
        $course->name_ar = $request->name_ar;
        $course->text_en = $request->text_en;
        $course->text_ar = $request->text_ar;
        $course->level_id = $request->level_id;
        $course->category_id = $request->category_id;
        $course->type_id = $request->type_id;
        $course->duration = $request->duration;
        $course->teacher_id = json_encode($request->teacher_id) ;
        $course->course_point_id = json_encode($request->point_id) ;
        $course->course_requirment_id = json_encode($request->requirment_id) ;
        $course->course_material_id = json_encode($request->material_id) ;
        $course->status = $request->status??0;
        $course->header = $request->header??0;
        $course->meta_title_en = $request->meta_title_en;
        $course->meta_title_ar = $request->meta_title_ar;
        $course->meta_desc_en =$request->meta_desc_en;
        $course->meta_desc_ar =$request->meta_desc_ar;

        $course->link_en = $request->link_en?preg_replace("/[ \/]/", "-", $request->link_en):preg_replace("/[ \/]/", "-", $course->title_en);
        $course->link_ar = $request->link_ar?preg_replace("/[ \/]/", "-", $request->link_ar):preg_replace("/[ \/]/", "-", $course->title_ar);

        if ($request->hasFile("image")) {

            $file = $request->file("image");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            $img_path = base_path() . '/uploads/courses/source/';
            if ($course->image != null) {
                file_exists($img_path.$course->image) ? unlink($img_path . $course->image):'';
            }
           // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/courses/source/' . $fileName);

            Image::make($file->getRealPath())->save($path);

            $course->image = $fileName;
        }
        $course->save();

        return redirect('admin/courses')->with('success',trans('home.your_item_updated_successfully'));
    }

    public function destroy(Request $request, Attachment $attachment)
    {
        $img_path = base_path() . '/uploads/attachments/source/';

        $m = Attachment::findOrFail($attachment->id);
        if ($m->path != null) {
            file_exists($img_path.$m->path) ? unlink($img_path . $m->path):'';
        }
        $m->delete();
        return redirect()->route('lessons.edit', $attachment->lesson_id)->with('success', trans('home.your_item_deleted_successfully'));
    }


}
