<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\About;
use DB;
use File;
use Image;
use App\Helpers\Helper;

class AboutController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:about');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function editAbout()
    {
        $about = About::first();
        return view('admin.about.editAbout',compact('about'));
    }

    public function update(Request $request)
    {
        $add = About::first();
        $add->title_en = $request->title_en;
        $add->text_en = $request->text_en;
        $add->title_ar = $request->title_ar;
        $add->text_ar = $request->text_ar;
        $add->alt_img = $request->alt_img;
        $add->alt_banner = $request->alt_banner;
        $add->why_us_title_en = $request->why_us_title_en ;
        $add->why_us_title_ar = $request->why_us_title_ar ;
        $add->why_us_text_en = $request->why_us_text_en ;
        $add->why_us_text_ar = $request->why_us_text_ar ;
        if($add->image && $request->image){
            $add->image = Helper::updateUploadedImage('aboutStrucs',$request->image ,$add->image);
        }elseif($request->image){
            $add->image = Helper::uploadImage('aboutStrucs',$request->image);
        } 
        
        if($add->banner && $request->banner){
            $add->banner = Helper::updateUploadedImage('aboutStrucs',$request->banner ,$add->banner);
        }elseif($request->banner){
            $add->banner = Helper::uploadImage('aboutStrucs',$request->banner);
        } 
        
        if($add->profile && $request->profile){
            $add->profile = Helper::updateUploadedFile('about',$request->profile ,$add->profile);
        }elseif($request->profile){
            $add->profile = Helper::uploadFile('about',$request->profile);
        } 
        
        $add->save();
        
        toastr()->success(trans('home.your_item_updated_successfully') , trans('home.updated'));
        return back();
    }
}
