<?php
namespace App\Exports;

use App\Models\Training;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithHeadings;

class AttendanceExport implements FromCollection, WithHeadings

{
    use Exportable;
    protected $training;
    protected $lang;
    
    public function __construct(Training $training, $lang)
    {
        $this->training = $training;
        $this->lang = $lang;    
        
    }


     public function collection()
    {
        
        $data = [];
        
        $this->training->students->each(function ($student) use (&$data) {
            foreach ($student->attendance as $attendance) {
                $data[] = [
                    'Name' => $student->user->name(),
                    'SSN' => $student->user->student_info->ssn,
                    'Training Name' => $this->training->{'name_'.$this->lang},
                    'Center Name' => $this->training->trainings_schaduals->center ? $this->training->trainings_schaduals->center->{'name_'.$this->lang} : '',
                    'Attendance date' => \Carbon\Carbon::parse($attendance->attendance_date)->format("d / m / Y"),
                    'Created At' => \Carbon\Carbon::parse($attendance->created_at)->format("d / m / Y")
                ];
            }
        });
        return new Collection($data);
    }
    
     public function headings(): array
    {
        return [
            'Name',
            'SSN',
            'Training Name',
            'Center Name',
            'Attendance Date',
            'Created At'
        ];
    }
}

