<?php

namespace App\DataTables;

use App\Models\TrainingCourse;
use App\Models\Training;
use App\Models\User;
use App\Models\Student;
use App\Models\InstructorInfo;
use App\Models\Partner;
use App\Models\TrainingSchadual;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\EloquentDataTable;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;
use Auth;

class StudentSchedualDataTable extends DataTable
{
    /**
     * Build the DataTable class.
     *
     * @param QueryBuilder $query Results from query() method.
     */
    public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addColumn('mobile', function($row){
                        return $row->student_info->mobile ?? '-';
             })
            ->addColumn('ssn', function($row){
                        return $row->student_info->ssn ?? '-';
             })
            ->addColumn('trainings', function($row){
                       return '<button type="button" 
                                    class="btn btn-primary viewtrainings"
                                    data-toggle="modal" onclick="viewModel2('.$row->id.')" data-target="#view_trainingModal_' . $row->id . '" data-std_id="' . $row->id . '">
                                    <i class="fas fa-user-friends fa-xl"></i>
                                </button>';
             })
            ->filterColumn('ssn', function($query, $keyword) {
                    $sql = "students_info.ssn like ?";
                    $query->whereRaw($sql, ["%{$keyword}%"]);
                })
            ->filterColumn('mobile', function($query, $keyword) {
                    $sql = "students_info.mobile like ?";
                    $query->whereRaw($sql, ["%{$keyword}%"]);
                })
            ->filterColumn('f_name', function($query, $keyword) {
                $sql = "f_name like ?";
                $query->whereRaw($sql, ["%{$keyword}%"]);
            })
            ->rawColumns(['trainings','action','checkbox'])
            ->setRowId('id');
    }

    /**
     * Get the query source of dataTable.
     */

    public function query(User $model): QueryBuilder
    {
        
        if(auth()->user()->type=="partner"){
            $center_ids = Partner::where('user_id',auth()->user()->id)->pluck('center_id')->toArray();
            // $center_ids = auth()->user()->partner->centers->pluck('id')->toArray();
            $training_ids = TrainingSchadual::whereIn('center_id',$center_ids)->pluck('training_id')->toArray();
            $student_ids = Student::whereIn('training_id',$training_ids)->pluck('user_id')->toArray();
            return $model
            ->leftJoin('students_info','students_info.user_id','users.id')
            ->select('users.*','students_info.ssn','students_info.mobile')
            ->with(['student_info','trainings'])
            ->where('type','student')
            ->whereIn('users.id',$student_ids)->newQuery();
        }
        if(auth()->user()->type=="instructor"){
            // $instructor_id = InstructorInfo::where('user_id',auth()->user()->id)->first()->id;
            $training_ids = TrainingCourse::where('instructor_id',auth()->user()->id)->pluck('training_id')->toArray();
            $student_ids = Student::whereIn('training_id',$training_ids)->pluck('user_id')->toArray();
            return $model
            ->leftJoin('students_info','students_info.user_id','users.id')
            ->select('users.*','students_info.ssn','students_info.mobile')
            ->with(['student_info','trainings'])
            ->where('type','student')
            ->whereIn('users.id',$student_ids)->newQuery();
        }
        if(auth()->user()->type=="coordinator"){
            $training_ids = Training::where('coordinator_id',auth()->user()->id)->pluck('id')->toArray();
            $student_ids = Student::whereIn('training_id',$training_ids)->pluck('user_id')->toArray();
            return $model
            ->leftJoin('students_info','students_info.user_id','users.id')
            ->select('users.*','students_info.ssn','students_info.mobile')
            ->with(['student_info','trainings'])
            ->where('type','student')
            ->whereIn('users.id',$student_ids)->newQuery();
        }
        if(auth()->user()->type=="marketer"){
            $training_ids = Training::where('marketer_id',auth()->user()->id)->pluck('id')->toArray();
            $student_ids = Student::whereIn('training_id',$training_ids)->pluck('user_id')->toArray();
            return $model
            ->leftJoin('students_info','students_info.user_id','users.id')
            ->select('users.*','students_info.ssn','students_info.mobile')
            ->with(['student_info','trainings'])
            ->where('type','student')
            ->whereIn('users.id',$student_ids)->newQuery();
        }else {
            return $model
            ->leftJoin('students_info','students_info.user_id','users.id')
            ->select('users.*','students_info.ssn','students_info.mobile')
            ->with(['student_info','trainings'])
            ->where('type','student')->newQuery();
        }

    }

    /**
     * Optional method if you want to use the html builder.
     */
    public function html(): HtmlBuilder
    {   if(auth()->user()->can('table_export_buttons')) {
            if(auth()->user()->type == 'admin' || auth()->user()->type == 'super_admin') {
                $arr = ['excel','csv','print','pageLength'];
            }else if(auth()->user()->type == 'partner'){
                $arr = [];
            }else {
                $arr = ['print','pageLength'];
            }
        } else {
            $arr =[];
        }
        return $this->builder()
                    ->setTableId('students-table')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    //->dom('Bfrtip')
                     ->orderBy(1, 'asc') 
                    ->selectStyleSingle()
                    ->scrollX(true)
                    ->pageLength(50)
                    ->lengthMenu([['10','25','50','100','-1'],['10','25','50','100','All']])
                    ->parameters([
                        'dom'          => 'Bfrtip',
                        'buttons'      => $arr,
                        'columnDefs' => [
                            ['targets' => [-1], 'className' => 'text-right'],
                        ],
                        'language' => [
                                'url' => '//cdn.datatables.net/plug-ins/1.13.3/i18n/ar.json',
                        ],
                        'aoColumnDefs' => [
                            // Disable sorting and searching for "details" column
                            ['aTargets' => ['checkbox'], 'bSearchable' => false, 'bSortable' => false]
                        ]
                    ]);
    }

    /**
     * Get the dataTable columns definition.
     */
    public function getColumns(): array
    {
        return [ 
            Column::make('ssn')
                    ->title(__('home.ssn')),
            Column::make('f_name')
                    ->title(__('home.name')),
            Column::make('mobile')
                    ->title(__('home.phone')),
            Column::make('trainings')
                    ->title(__('home.trainings')),
        ];
    }

    /**
     * Get the filename for export.
     */
    protected function filename(): string
    {
        return 'Students_' . date('YmdHis');
    }
}
