<?php

namespace App\DataTables;

use App\Models\TrainingSchadual;
use App\Models\Training;
use App\Models\Partner;
use App\Models\User;
use App\Models\CenterResponsible;
use App\Models\Instructor;
use App\Models\InstructorInfo;
use App\Models\Center;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\EloquentDataTable;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;
use Auth;

class CenterDataTable extends DataTable
{
    /**
     * Build the DataTable class.
     *
     * @param QueryBuilder $query Results from query() method.
     */
    public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addColumn('checkbox', function($row){
                     return '<input type="checkbox" name="checkbox" class="tableChecked" value="'. $row->id .'" />';
                    })
        
            ->addColumn('action', function($row){
                            $url = url('admin/centers/'.$row->id.'/edit');
                            if(Auth::user()->can('editCenter')){
                            return '<a href="' . $url . '" class="btn btn-primary" ><i class="fas fa-edit"></i></a>';
                            }else {
                                return '';
                            }
                    })
            // ->addColumn('image', function($row){
            //             if($row->image){
            //                 $url = url('uploads/centers/'.$row->image);
            //                 return '<img src="' . $url . '" border="0" width="40" class="img-rounded" />';
            //             }else{
            //                 $url = url("resources/assets/back/img/noimage.png");
            //                 return '<img src="' . $url . '" border="0" width="40" class="img-rounded" />';
            //             }
            //         })
            ->addColumn('region', function($row){
                        if($row->region) {
                            return app()->getLocale() == 'en' ? $row->region->name_en ?? '-' : $row->region->name_en ?? '-';
                        }else
                            return '';
                    })
            // ->addColumn('partner', function($row){
            //             if($row->partner) {
            //                 return $row->partner->user->name();
            //             }else
            //                 return 'Super Admin';
            //         })
            ->addColumn('responsibles', function($row){
                            return '<button type="button" 
                                    class="btn btn-primary viewresponsible"
                                    data-toggle="modal" onclick="viewModel(' . $row->id . ')" data-target="#view_responsibleModal_' . $row->id . '" data-responsible_id="' . $row->id . '">
                                    <i class="fas fa-user-friends fa-xl"></i>
                                </button>';
                    })
            ->addColumn('identity_attachment', function($row){
                $feed = '';
                if($row->identity_attachment) {
                    $feed .= __('home.attached_file')
                    .'<a target="_blank" href="' . url('uploads/centers/attachments/files/'.$row->identity_attachment) . '" '
                    . '<i class="fas fa-eye"></i> '
                    .$row->identity_attachment . ' </a> <br>';
                }
                return $feed;
            })
            ->addColumn('profile_attachment', function($row){
                    $feed = '';
                    if($row->profile_attachment) {
                    $feed .= __('home.attached_file')
                    .'<a target="_blank" href="' . url('uploads/centers/attachments/files/'.$row->profile_attachment)
                    .'">
                          <i class="fas fa-eye"></i>
                        '.$row->profile_attachment . ' </a> <br>';
                    }
                    return $feed;
                    })
            // ->addColumn('responsible_of_contact', function($row){
            //             $user = User::find($row->responsible_of_contact);
            //             if($user) return $user->f_name;
            //             else return '-';
            //         })
             ->editColumn('status', function($row){
                        return ($row->status == 1)?trans('home.yes'):trans('home.no');
             })
             ->filterColumn('name_ar', function($query, $keyword) {
                    $sql = "centers.name_ar like ?";
                    $query->whereRaw($sql, ["%{$keyword}%"]);
                })
            ->filterColumn('status', function($query, $keyword) {
                        if ($keyword == 'yes' || $keyword == '%yes%' || $keyword == 'نعم' || $keyword == '%نعم%') {
                            $query->where('centers.status', 1);
                        } elseif ($keyword == 'no' || $keyword == '%no%' || $keyword == 'لا' || $keyword == '%لا%') {
                            $query->where('centers.status', 0);
                        }
                })
             ->filterColumn('region', function($query, $keyword) {
                    $sql = "regions.name_ar like ? or regions.name_en like ?";
                    $query->whereRaw($sql, ["%{$keyword}%","%{$keyword}%"]);
                })
            ->rawColumns(['profile_attachment','identity_attachment','responsibles','action','checkbox'])
            ->setRowId('id');
    }

    /**
     * Get the query source of dataTable.
     */
    public function query(Center $model): QueryBuilder
    {
        if(auth()->user()->type=="partner"){
            $center_ids = Partner::where('user_id',auth()->user()->id)->pluck('center_id')->toArray();
            return $model->leftJoin('regions','regions.id','centers.region_id')
                ->select('centers.*','regions.name_ar as region_name_ar','regions.name_en as region_name_en')
                ->whereIn('centers.id',$center_ids)
                ->newQuery();
        }
        else if(auth()->user()->type=="instructor"){
            // $instructor_id = InstructorInfo::where('user_id',auth()->user()->id)->first()->id;
            $center_ids = Instructor::where('instructor_id',auth()->user()->id)->pluck('center_id')->toArray();
            return $model->leftJoin('regions','regions.id','centers.region_id')
                ->select('centers.*','regions.name_ar as region_name_ar','regions.name_en as region_name_en')
                ->whereIn('centers.id',$center_ids)
                ->newQuery();
        }
        else if(auth()->user()->type=="coordinator"){
            $training_ids = Training::where('coordinator_id',auth()->user()->id)->pluck('id')->toArray();
            $center_ids = TrainingSchadual::whereIn('training_id',$training_ids)->pluck('center_id')->toArray();
            return $model->leftJoin('regions','regions.id','centers.region_id')
                ->select('centers.*','regions.name_ar as region_name_ar','regions.name_en as region_name_en')
                ->whereIn('centers.id',$center_ids)
                ->newQuery();
        }
        else if(auth()->user()->type=="marketer"){
            $training_ids = Training::where('marketer_id',auth()->user()->id)->pluck('id')->toArray();
            $center_ids = TrainingSchadual::whereIn('training_id',$training_ids)->pluck('center_id')->toArray();
            return $model->leftJoin('regions','regions.id','centers.region_id')
                ->select('centers.*','regions.name_ar as region_name_ar','regions.name_en as region_name_en')
                ->whereIn('centers.id',$center_ids)
                ->newQuery();
        }else {
            return $model->leftJoin('regions','regions.id','centers.region_id')
                ->select('centers.*','regions.name_ar as region_name_ar','regions.name_en as region_name_en')
                ->newQuery();
        }
    }

    /**
     * Optional method if you want to use the html builder.
     */
    public function html(): HtmlBuilder
    {   if(auth()->user()->can('table_export_buttons')) {
            if(auth()->user()->type == 'admin' || auth()->user()->type == 'super_admin') {
                $arr = ['excel','csv','print','pageLength'];
            }else if(auth()->user()->type == 'partner'){
                $arr = [];
            }else {
                $arr = ['print','pageLength'];
            }
        } else {
            $arr = [];
        }
        return $this->builder()
                    ->setTableId('centers-table')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    //->dom('Bfrtip')
                     ->orderBy(1, 'asc') 
                    ->selectStyleSingle()
                    ->scrollX(true)
                    ->pageLength(50)
                    ->lengthMenu([['10','25','50','100','-1'],['10','25','50','100','All']])
                    ->parameters([
                        'dom'          => 'Bfrtip',
                        'buttons'      => $arr,
                        'columnDefs' => [
                            ['targets' => [-1], 'className' => 'text-right'],
                        ],
                        'language' => [
                                'url' => '//cdn.datatables.net/plug-ins/1.13.3/i18n/ar.json',
                        ],
                        'aoColumnDefs' => [
                            // Disable sorting and searching for "details" column
                            ['aTargets' => ['checkbox'], 'bSearchable' => false, 'bSortable' => false]
                        ]
                    ]);
    }

    /**
     * Get the dataTable columns definition.
     */
    public function getColumns(): array
    {
        return [
            [
                'title' => '',
                'data'           => 'checkbox',
                'name'           => 'checkbox',
                'class'          => 'msg_check',
                'orderable'      => false,
                'searchable'     => false,
                'exportable'     => false,
                'printable'      => false,
                'width'          => '10px',
            ],
            Column::make('id')
                    ->title(__('home.id')),
            // Column::make('name_en')
            //         ->title(__('home.name_en')),
            Column::make('name_ar')
                    ->title(__('home.name_ar')),
            // Column::make('responsible_of_contact')
            //         ->title(__('home.responsible_of_contact')),
            Column::make('region')
                    ->title(__('home.region')),
            Column::make('identity_attachment')
                    ->title(__('home.commericalRegister/identity')),
            Column::make('profile_attachment')
                    ->title(__('home.profile_attachment')),
            // Column::make('image')
            //         ->title(__('home.image')),
            Column::make('status')
                    ->title(__('home.status')),
             Column::make('responsibles')
                    ->title(__('home.responsibles')),
            Column::make('action')
                    ->title(__('home.edit')),
            
        ];
    }

    /**
     * Get the filename for export.
     */
    protected function filename(): string
    {
        return 'Centers_' . date('YmdHis');
    }
}
